/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.core.util;

import net.malisis.core.block.IBoundingBox;
import net.malisis.core.util.EnumFacingUtils;
import net.malisis.core.util.MBlockState;
import net.minecraft.block.Block;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.World;
import org.apache.commons.lang3.ArrayUtils;

public class AABBUtils {
    private static int[] cos = new int[]{1, 0, -1, 0};
    private static int[] sin = new int[]{0, 1, 0, -1};

    public static AxisAlignedBB empty() {
        return AABBUtils.empty(new BlockPos(0, 0, 0));
    }

    public static AxisAlignedBB empty(BlockPos pos) {
        return new AxisAlignedBB((double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), (double)pos.getX(), (double)pos.getY(), (double)pos.getZ());
    }

    public static AxisAlignedBB identity() {
        return AABBUtils.identity(new BlockPos(0, 0, 0));
    }

    public static AxisAlignedBB identity(BlockPos pos) {
        return new AxisAlignedBB((double)pos.getX(), (double)pos.getY(), (double)pos.getZ(), (double)(pos.getX() + 1), (double)(pos.getY() + 1), (double)(pos.getZ() + 1));
    }

    public static AxisAlignedBB[] identities() {
        return AABBUtils.identities(new BlockPos(0, 0, 0));
    }

    public static AxisAlignedBB[] identities(BlockPos pos) {
        return new AxisAlignedBB[]{AABBUtils.identity(pos)};
    }

    public static AxisAlignedBB rotate(AxisAlignedBB aabb, EnumFacing dir) {
        return AABBUtils.rotate(aabb, EnumFacingUtils.getRotationCount(dir));
    }

    public static AxisAlignedBB[] rotate(AxisAlignedBB[] aabbs, EnumFacing dir) {
        return AABBUtils.rotate(aabbs, EnumFacingUtils.getRotationCount(dir));
    }

    public static AxisAlignedBB[] rotate(AxisAlignedBB[] aabbs, int angle) {
        if (ArrayUtils.isEmpty((Object[])aabbs) || angle == 0) {
            return aabbs;
        }
        for (int i = 0; i < aabbs.length; ++i) {
            aabbs[i] = AABBUtils.rotate(aabbs[i], angle);
        }
        return aabbs;
    }

    public static AxisAlignedBB rotate(AxisAlignedBB aabb, int angle) {
        return AABBUtils.rotate(aabb, angle, EnumFacing.Axis.Y);
    }

    public static AxisAlignedBB rotate(AxisAlignedBB aabb, int angle, EnumFacing.Axis axis) {
        if (aabb == null || angle == 0 || axis == null) {
            return aabb;
        }
        int a = -angle & 3;
        int s = sin[a];
        int c = cos[a];
        aabb = aabb.offset(-0.5, -0.5, -0.5);
        double minX = aabb.minX;
        double minY = aabb.minY;
        double minZ = aabb.minZ;
        double maxX = aabb.maxX;
        double maxY = aabb.maxY;
        double maxZ = aabb.maxZ;
        if (axis == EnumFacing.Axis.X) {
            minY = aabb.minY * (double)c - aabb.minZ * (double)s;
            maxY = aabb.maxY * (double)c - aabb.maxZ * (double)s;
            minZ = aabb.minY * (double)s + aabb.minZ * (double)c;
            maxZ = aabb.maxY * (double)s + aabb.maxZ * (double)c;
        }
        if (axis == EnumFacing.Axis.Y) {
            minX = aabb.minX * (double)c - aabb.minZ * (double)s;
            maxX = aabb.maxX * (double)c - aabb.maxZ * (double)s;
            minZ = aabb.minX * (double)s + aabb.minZ * (double)c;
            maxZ = aabb.maxX * (double)s + aabb.maxZ * (double)c;
        }
        if (axis == EnumFacing.Axis.Z) {
            minX = aabb.minX * (double)c - aabb.minY * (double)s;
            maxX = aabb.maxX * (double)c - aabb.maxY * (double)s;
            minY = aabb.minX * (double)s + aabb.minY * (double)c;
            maxY = aabb.maxX * (double)s + aabb.maxY * (double)c;
        }
        aabb = new AxisAlignedBB(minX, minY, minZ, maxX, maxY, maxZ);
        aabb = aabb.offset(0.5, 0.5, 0.5);
        return aabb;
    }

    public static AxisAlignedBB readFromNBT(NBTTagCompound tag) {
        return tag != null ? new AxisAlignedBB(tag.getDouble("minX"), tag.getDouble("minY"), tag.getDouble("minZ"), tag.getDouble("maxX"), tag.getDouble("maxY"), tag.getDouble("maxZ")) : null;
    }

    public static void writeToNBT(NBTTagCompound tag, AxisAlignedBB aabb) {
        if (tag == null || aabb == null) {
            return;
        }
        tag.setDouble("minX", aabb.minX);
        tag.setDouble("minY", aabb.minY);
        tag.setDouble("minZ", aabb.minZ);
        tag.setDouble("maxX", aabb.maxX);
        tag.setDouble("maxY", aabb.maxY);
        tag.setDouble("maxZ", aabb.maxZ);
    }

    public static AxisAlignedBB combine(AxisAlignedBB[] aabbs) {
        if (ArrayUtils.isEmpty((Object[])aabbs)) {
            return null;
        }
        AxisAlignedBB ret = null;
        for (AxisAlignedBB aabb : aabbs) {
            if (ret == null) {
                ret = aabb;
                continue;
            }
            if (aabb == null) continue;
            ret = ret.union(aabb);
        }
        return ret;
    }

    public static AxisAlignedBB[] offset(double x, double y, double z, AxisAlignedBB ... aabbs) {
        return AABBUtils.offset(new BlockPos(x, y, z), aabbs);
    }

    public static AxisAlignedBB offset(BlockPos pos, AxisAlignedBB aabb) {
        if (aabb == null || pos == null) {
            return aabb;
        }
        return aabb.offset((double)pos.getX(), (double)pos.getY(), (double)pos.getZ());
    }

    public static AxisAlignedBB[] offset(BlockPos pos, AxisAlignedBB ... aabbs) {
        if (ArrayUtils.isEmpty((Object[])aabbs)) {
            return aabbs;
        }
        for (int i = 0; i < aabbs.length; ++i) {
            if (aabbs[i] == null) continue;
            aabbs[i] = aabbs[i].offset((double)pos.getX(), (double)pos.getY(), (double)pos.getZ());
        }
        return aabbs;
    }

    public static boolean isColliding(AxisAlignedBB aabb, AxisAlignedBB[] aabbs) {
        return AABBUtils.isColliding(new AxisAlignedBB[]{aabb}, aabbs);
    }

    public static boolean isColliding(AxisAlignedBB[] aabbs, AxisAlignedBB aabb) {
        return AABBUtils.isColliding(aabbs, new AxisAlignedBB[]{aabb});
    }

    public static boolean isColliding(AxisAlignedBB[] aabbs1, AxisAlignedBB[] aabbs2) {
        if (ArrayUtils.isEmpty((Object[])aabbs1) || ArrayUtils.isEmpty((Object[])aabbs2)) {
            return false;
        }
        for (AxisAlignedBB aabb1 : aabbs1) {
            if (aabb1 == null) continue;
            for (AxisAlignedBB aabb2 : aabbs2) {
                if (aabb2 == null || !aabb1.intersectsWith(aabb2)) continue;
                return true;
            }
        }
        return false;
    }

    public static AxisAlignedBB[] getCollisionBoundingBoxes(World world, Block block, BlockPos pos) {
        return AABBUtils.getCollisionBoundingBoxes(world, new MBlockState(pos, block), false);
    }

    public static AxisAlignedBB[] getCollisionBoundingBoxes(World world, Block block, BlockPos pos, boolean offset) {
        return AABBUtils.getCollisionBoundingBoxes(world, new MBlockState(pos, block), offset);
    }

    public static AxisAlignedBB[] getCollisionBoundingBoxes(World world, MBlockState state) {
        return AABBUtils.getCollisionBoundingBoxes(world, state, false);
    }

    public static AxisAlignedBB[] getCollisionBoundingBoxes(World world, MBlockState state, boolean offset) {
        AxisAlignedBB[] aabbs = new AxisAlignedBB[]{};
        if (world == null || state == null) {
            return aabbs;
        }
        if (state.getBlock() instanceof IBoundingBox) {
            aabbs = ((IBoundingBox)state.getBlock()).getCollisionBoundingBoxes(world, state.getPos(), state.getBlockState());
        } else {
            AxisAlignedBB aabb = state.getBlock().getCollisionBoundingBox(world, state.getPos(), state.getBlockState());
            if (aabb != null) {
                aabbs = new AxisAlignedBB[]{aabb.offset((double)(-state.getX()), (double)(-state.getY()), (double)(-state.getZ()))};
            }
        }
        if (offset) {
            AABBUtils.offset(state.getX(), state.getY(), state.getZ(), aabbs);
        }
        return aabbs;
    }
}

