/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.core.renderer.icon.provider;

import net.malisis.core.renderer.icon.MalisisIcon;
import net.malisis.core.renderer.icon.provider.IBlockIconProvider;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.IBlockAccess;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;

public class SidesIconProvider
implements IBlockIconProvider {
    private MalisisIcon defaultIcon;
    private MalisisIcon[] sideIcons = new MalisisIcon[6];

    public SidesIconProvider(String defaultName, String[] sideNames) {
        this.setDefaultIcon(defaultName);
        this.setSideIcons(sideNames);
    }

    public SidesIconProvider(String defaultName) {
        this.setDefaultIcon(defaultName);
    }

    public SidesIconProvider(MalisisIcon defaultIcon, MalisisIcon[] sideIcons) {
        this.setDefaultIcon(defaultIcon);
        this.setSideIcons(sideIcons);
    }

    public SidesIconProvider(MalisisIcon defaultIcon) {
        this.setDefaultIcon(defaultIcon);
    }

    public void setDefaultIcon(String name) {
        this.defaultIcon = new MalisisIcon(name);
    }

    public void setDefaultIcon(MalisisIcon icon) {
        this.defaultIcon = icon;
    }

    public void setSideIcons(String[] names) {
        for (int i = 0; i < names.length; ++i) {
            if (StringUtils.isEmpty((CharSequence)names[i])) continue;
            this.setSideIcon(EnumFacing.getFront((int)i), new MalisisIcon(names[i]));
        }
    }

    public void setSideIcons(MalisisIcon[] icons) {
        for (int i = 0; i < icons.length; ++i) {
            if (icons[i] == null) continue;
            this.setSideIcon(EnumFacing.getFront((int)i), icons[i]);
        }
    }

    public void setSideIcon(EnumFacing side, MalisisIcon icon) {
        if (this.defaultIcon == null) {
            this.defaultIcon = icon;
        }
        this.sideIcons[side.getIndex()] = icon;
    }

    public void setSideIcon(EnumFacing side, String name) {
        this.setSideIcon(side, new MalisisIcon(name));
    }

    @Override
    public void registerIcons(TextureMap map) {
        if (this.defaultIcon != null) {
            this.defaultIcon = this.defaultIcon.register(map);
        }
        for (int i = 0; i < this.sideIcons.length; ++i) {
            if (this.sideIcons[i] == null) continue;
            this.sideIcons[i] = this.sideIcons[i].register(map);
        }
    }

    public MalisisIcon getIcon(EnumFacing side) {
        if (side == null || side.getIndex() > this.sideIcons.length) {
            return this.defaultIcon;
        }
        return (MalisisIcon)((Object)ObjectUtils.firstNonNull((Object[])new MalisisIcon[]{this.sideIcons[side.getIndex()], this.defaultIcon}));
    }

    @Override
    public MalisisIcon getIcon(IBlockAccess world, BlockPos pos, IBlockState state, EnumFacing side) {
        return this.getIcon(side);
    }

    @Override
    public MalisisIcon getIcon(ItemStack itemStack, EnumFacing side) {
        return this.getIcon(side);
    }

    @Override
    public MalisisIcon getIcon() {
        return this.defaultIcon;
    }
}

