/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.core.renderer.icon.provider;

import net.malisis.core.renderer.icon.IIconProvider;
import net.malisis.core.renderer.icon.MalisisIcon;
import net.malisis.core.renderer.icon.VanillaIcon;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.item.Item;

public class DefaultIconProvider
implements IIconProvider {
    protected MalisisIcon icon;

    public DefaultIconProvider(MalisisIcon icon) {
        this.icon = icon;
    }

    @Override
    public void registerIcons(TextureMap map) {
        this.icon = this.icon.register(map);
    }

    @Override
    public MalisisIcon getIcon() {
        return this.icon;
    }

    public static DefaultIconProvider from(Object object) {
        if (object == null) {
            return null;
        }
        if (object instanceof String) {
            return (String)object != "" ? new DefaultIconProvider(new MalisisIcon((String)object)) : null;
        }
        if (object instanceof Item) {
            return new DefaultIconProvider(new VanillaIcon((Item)object));
        }
        if (object instanceof Block) {
            return new DefaultIconProvider(new VanillaIcon((Block)object));
        }
        if (object instanceof IBlockState) {
            return new DefaultIconProvider(new VanillaIcon((IBlockState)object));
        }
        throw new IllegalArgumentException("Parameter has to be a String, a Block, an IBlockState or an Item");
    }
}

