/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.core.renderer.icon.provider;

import net.malisis.core.renderer.icon.MalisisIcon;
import net.malisis.core.renderer.icon.provider.IBlockIconProvider;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.IBlockAccess;

public class ConnectedIconsProvider
implements IBlockIconProvider {
    private static int NONE = 0;
    private static int LEFT = 1;
    private static int TOP = 2;
    private static int RIGHT = 4;
    private static int BOTTOM = 8;
    private static int FULL = LEFT | TOP | RIGHT | BOTTOM;
    public static EnumFacing[][] sides = new EnumFacing[][]{{EnumFacing.WEST, EnumFacing.NORTH, EnumFacing.EAST, EnumFacing.SOUTH}, {EnumFacing.WEST, EnumFacing.NORTH, EnumFacing.EAST, EnumFacing.SOUTH}, {EnumFacing.EAST, EnumFacing.UP, EnumFacing.WEST, EnumFacing.DOWN}, {EnumFacing.WEST, EnumFacing.UP, EnumFacing.EAST, EnumFacing.DOWN}, {EnumFacing.NORTH, EnumFacing.UP, EnumFacing.SOUTH, EnumFacing.DOWN}, {EnumFacing.SOUTH, EnumFacing.UP, EnumFacing.NORTH, EnumFacing.DOWN}};
    private MalisisIcon part1;
    private MalisisIcon part2;
    private MalisisIcon[] icons = new MalisisIcon[16];
    private boolean initialized = false;

    public ConnectedIconsProvider(String name) {
        this.part1 = new MalisisIcon(name);
        this.part2 = new MalisisIcon(name + "2");
    }

    public ConnectedIconsProvider(MalisisIcon part1, MalisisIcon part2) {
        this.part1 = part1;
        this.part2 = part2;
    }

    @Override
    public void registerIcons(TextureMap map) {
        this.part1 = this.part1.register(map);
        this.part2 = this.part2.register(map);
    }

    protected void initializeIcons() {
        float f = 0.33333334f;
        this.icons[ConnectedIconsProvider.LEFT | ConnectedIconsProvider.TOP] = this.part1.copy().clip(0.0f, 0.0f, f, f);
        this.icons[ConnectedIconsProvider.TOP] = this.part1.copy().clip(f, 0.0f, f, f);
        this.icons[ConnectedIconsProvider.RIGHT | ConnectedIconsProvider.TOP] = this.part1.copy().clip(2.0f * f, 0.0f, f, f);
        this.icons[ConnectedIconsProvider.LEFT] = this.part1.copy().clip(0.0f, f, f, f);
        this.icons[ConnectedIconsProvider.NONE] = this.part1.copy().clip(f, f, f, f);
        this.icons[ConnectedIconsProvider.RIGHT] = this.part1.copy().clip(2.0f * f, f, f, f);
        this.icons[ConnectedIconsProvider.LEFT | ConnectedIconsProvider.BOTTOM] = this.part1.copy().clip(0.0f, 2.0f * f, f, f);
        this.icons[ConnectedIconsProvider.BOTTOM] = this.part1.copy().clip(f, 2.0f * f, f, f);
        this.icons[ConnectedIconsProvider.RIGHT | ConnectedIconsProvider.BOTTOM] = this.part1.copy().clip(2.0f * f, 2.0f * f, f, f);
        this.icons[ConnectedIconsProvider.LEFT | ConnectedIconsProvider.TOP | ConnectedIconsProvider.BOTTOM] = this.part2.copy().clip(0.0f, 0.0f, f, f);
        this.icons[ConnectedIconsProvider.TOP | ConnectedIconsProvider.BOTTOM] = this.part2.copy().clip(f, 0.0f, f, f);
        this.icons[ConnectedIconsProvider.LEFT | ConnectedIconsProvider.RIGHT | ConnectedIconsProvider.TOP] = this.part2.copy().clip(2.0f * f, 0.0f, f, f);
        this.icons[ConnectedIconsProvider.LEFT | ConnectedIconsProvider.RIGHT] = this.part2.copy().clip(0.0f, f, f, f);
        this.icons[ConnectedIconsProvider.FULL] = this.part2.copy().clip(f, f, f, f);
        this.icons[ConnectedIconsProvider.LEFT | ConnectedIconsProvider.RIGHT | ConnectedIconsProvider.BOTTOM] = this.part2.copy().clip(0.0f, 2.0f * f, f, f);
        this.icons[ConnectedIconsProvider.RIGHT | ConnectedIconsProvider.TOP | ConnectedIconsProvider.BOTTOM] = this.part2.copy().clip(2.0f * f, 2.0f * f, f, f);
        this.initialized = true;
    }

    @Override
    public MalisisIcon getIcon() {
        if (!this.initialized) {
            this.initializeIcons();
        }
        return this.icons[FULL];
    }

    @Override
    public MalisisIcon getIcon(IBlockAccess world, BlockPos pos, IBlockState state, EnumFacing facing) {
        if (!this.initialized) {
            this.initializeIcons();
        }
        int connections = this.getConnections(world, pos, facing);
        return this.icons[connections];
    }

    private int getConnections(IBlockAccess world, BlockPos pos, EnumFacing facing) {
        Block block = world.getBlockState(pos).getBlock();
        int connection = 0;
        for (int i = 0; i < 4; ++i) {
            if (world.getBlockState(pos.offset(sides[facing.getIndex()][i])).getBlock() != block) continue;
            connection |= 1 << i;
        }
        return ~connection & 0xF;
    }
}

