/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.core.renderer.icon;

import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import net.malisis.core.asm.AsmUtils;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;

public class MalisisIcon
extends TextureAtlasSprite {
    private static Field mapRegisteredSprites = AsmUtils.changeFieldAccess(TextureMap.class, "mapRegisteredSprites", "field_110574_e");
    public static MalisisIcon missing = new MalisisIcon("missingno");
    protected int sheetWidth;
    protected int sheetHeight;
    protected boolean flippedU = false;
    protected boolean flippedV = false;
    protected int rotation = 0;
    protected Set<MalisisIcon> dependants = new HashSet<MalisisIcon>();

    public MalisisIcon() {
        super("");
        this.maxU = 1.0f;
        this.maxV = 1.0f;
    }

    public MalisisIcon(String name) {
        super(name);
        this.maxU = 1.0f;
        this.maxV = 1.0f;
    }

    public MalisisIcon(MalisisIcon baseIcon) {
        super(baseIcon.getIconName());
        this.maxU = 1.0f;
        this.maxV = 1.0f;
        baseIcon.addDependant(this);
    }

    public MalisisIcon(String name, float u, float v, float U, float V) {
        this(name);
        this.minU = u;
        this.minV = v;
        this.maxU = U;
        this.maxV = V;
    }

    public MalisisIcon(TextureAtlasSprite icon) {
        this(icon.getIconName());
        this.copyFrom(icon);
    }

    public void addDependant(MalisisIcon icon) {
        this.dependants.add(icon);
    }

    public void setSize(int width, int height) {
        this.width = width;
        this.height = height;
    }

    public void setUVs(float u, float v, float U, float V) {
        this.minU = u;
        this.minV = v;
        this.maxU = U;
        this.maxV = V;
    }

    public float getMinU() {
        return this.flippedU ? this.maxU : this.minU;
    }

    public float getMaxU() {
        return this.flippedU ? this.minU : this.maxU;
    }

    public float getMinV() {
        return this.flippedV ? this.maxV : this.minV;
    }

    public float getMaxV() {
        return this.flippedV ? this.minV : this.maxV;
    }

    public MalisisIcon flip(boolean horizontal, boolean vertical) {
        this.flippedU = horizontal;
        this.flippedV = vertical;
        return this;
    }

    public boolean isFlippedU() {
        return this.flippedU;
    }

    public boolean isFlippedV() {
        return this.flippedV;
    }

    public boolean isRotated() {
        return this.rotation != 0;
    }

    public void setRotation(int rotation) {
        this.rotation = rotation;
    }

    public int getRotation() {
        return this.rotation;
    }

    protected void initIcon(MalisisIcon baseIcon, int width, int height, int x, int y, boolean rotated) {
        this.copyFrom(baseIcon);
    }

    public MalisisIcon offset(int offsetX, int offsetY) {
        this.initSprite(this.sheetWidth, this.sheetHeight, this.getOriginX() + offsetX, this.getOriginY() + offsetY, this.isRotated());
        return this;
    }

    public MalisisIcon clip(int offsetX, int offsetY, int width, int height) {
        this.width = width;
        this.height = height;
        this.offset(offsetX, offsetY);
        return this;
    }

    public MalisisIcon clip(float offsetXFactor, float offsetYFactor, float widthFactor, float heightFactor) {
        int offsetX = Math.round((float)this.width * offsetXFactor);
        int offsetY = Math.round((float)this.height * offsetYFactor);
        this.width = Math.round((float)this.width * widthFactor);
        this.height = Math.round((float)this.height * heightFactor);
        this.offset(offsetX, offsetY);
        return this;
    }

    public void initSprite(int width, int height, int x, int y, boolean rotated) {
        this.sheetWidth = width;
        this.sheetHeight = height;
        super.initSprite(width, height, x, y, rotated);
        for (TextureAtlasSprite textureAtlasSprite : this.dependants) {
            if (textureAtlasSprite instanceof MalisisIcon) {
                ((MalisisIcon)textureAtlasSprite).initIcon(this, width, height, x, y, rotated);
                continue;
            }
            this.copyFrom(this);
        }
    }

    public void copyFrom(TextureAtlasSprite base) {
        super.copyFrom(base);
        for (int i = 0; i < base.getFrameCount(); ++i) {
            this.framesTextureData.add(base.getFrameTextureData(i));
        }
        if (base instanceof MalisisIcon) {
            MalisisIcon mbase = (MalisisIcon)base;
            this.sheetWidth = mbase.sheetWidth;
            this.sheetHeight = mbase.sheetHeight;
            this.flippedU = mbase.flippedU;
            this.flippedV = mbase.flippedV;
        }
    }

    public MalisisIcon copy() {
        MalisisIcon icon = new MalisisIcon();
        icon.copyFrom(this);
        return icon;
    }

    public MalisisIcon register(TextureMap textureMap) {
        TextureAtlasSprite icon = textureMap.getTextureExtry(this.getIconName());
        if (icon instanceof MalisisIcon) {
            return (MalisisIcon)icon;
        }
        if (icon != null && icon.getClass() == TextureAtlasSprite.class) {
            return this.replaceRegisteredIcon(textureMap);
        }
        textureMap.setTextureEntry(this.getIconName(), (TextureAtlasSprite)this);
        return this;
    }

    private MalisisIcon replaceRegisteredIcon(TextureMap textureMap) {
        try {
            HashMap map = (HashMap)mapRegisteredSprites.get(textureMap);
            map.put(this.getIconName(), this);
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            e.printStackTrace();
        }
        return this;
    }
}

