/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.core.renderer.icon;

import net.malisis.core.MalisisCore;
import net.malisis.core.renderer.icon.IIconProvider;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.Item;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.StringUtils;

public interface IMetaIconProvider {
    default public void setTexture(String textureName) {
        if (!StringUtils.isEmpty((CharSequence)textureName) && MalisisCore.isClient()) {
            this.createIconProvider(textureName);
        }
    }

    default public void setTexture(Item item) {
        if (item != null && MalisisCore.isClient()) {
            this.createIconProvider(item);
        }
    }

    default public void setTexture(Block block) {
        if (block != null && block.getDefaultState() != null && MalisisCore.isClient()) {
            this.createIconProvider(block.getDefaultState());
        }
    }

    default public void setTexture(IBlockState blockState) {
        if (blockState != null && MalisisCore.isClient()) {
            this.createIconProvider(blockState);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void createIconProvider(Object var1);

    @SideOnly(value=Side.CLIENT)
    public IIconProvider getIconProvider();
}

