/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.core.renderer.font;

import java.util.HashMap;
import java.util.Map;
import net.malisis.core.renderer.font.Link;
import net.minecraft.util.EnumChatFormatting;
import org.apache.commons.lang3.StringUtils;

public class FontRenderOptions {
    private static Map<Character, EnumChatFormatting> charFormats = new HashMap<Character, EnumChatFormatting>();
    private static int[] colors = new int[32];
    public float fontScale = 1.0f;
    public int color = 0;
    public boolean shadow = false;
    public boolean bold;
    public boolean italic;
    public boolean underline;
    public boolean strikethrough;
    public boolean disableECF = false;
    private FontRenderOptions defaultFro;
    private FontRenderOptions lineFro;
    private boolean defaultSaved = false;

    public FontRenderOptions() {
        this.defaultFro = new FontRenderOptions(false);
    }

    public FontRenderOptions(boolean b) {
    }

    public FontRenderOptions(FontRenderOptions fro) {
        this.defaultFro = new FontRenderOptions(false);
        this.from(fro);
        this.saveDefault();
        this.defaultSaved = false;
    }

    public FontRenderOptions(String ecfs) {
        this.defaultFro = new FontRenderOptions(false);
        this.processStyles(ecfs);
        this.saveDefault();
        this.defaultSaved = false;
    }

    public FontRenderOptions(String ecfs, int color) {
        this(ecfs);
        this.color = color;
        this.defaultFro.color = color;
    }

    public int processStyles(String text) {
        return this.processStyles(text, 0);
    }

    public int processStyles(String text, int index) {
        EnumChatFormatting ecf;
        if (!this.defaultSaved) {
            this.saveDefault();
        }
        if (this.disableECF) {
            return 0;
        }
        int offset = 0;
        while ((ecf = FontRenderOptions.getFormatting(text, index + offset)) != null) {
            offset += 2;
            this.apply(ecf);
        }
        return offset;
    }

    public void apply(EnumChatFormatting ecf) {
        if (!this.defaultSaved) {
            this.saveDefault();
        }
        if (ecf == EnumChatFormatting.RESET) {
            this.resetStyles();
        } else if (ecf.isColor()) {
            this.color = colors[ecf.ordinal()];
        } else {
            switch (ecf) {
                case STRIKETHROUGH: {
                    this.strikethrough = true;
                    break;
                }
                case BOLD: {
                    this.bold = true;
                    break;
                }
                case ITALIC: {
                    this.italic = true;
                    break;
                }
                case UNDERLINE: {
                    this.underline = true;
                    break;
                }
            }
        }
    }

    public void saveDefault() {
        this.defaultSaved = true;
        this.defaultFro.color = this.color;
        this.defaultFro.strikethrough = this.strikethrough;
        this.defaultFro.bold = this.bold;
        this.defaultFro.italic = this.italic;
        this.defaultFro.underline = this.underline;
        this.defaultFro.fontScale = this.fontScale;
    }

    public void resetStyles() {
        if (!this.defaultSaved) {
            this.saveDefault();
            return;
        }
        this.from(this.defaultFro);
    }

    public void setLineFro(FontRenderOptions fro) {
        if (this.lineFro == null) {
            this.lineFro = new FontRenderOptions();
        }
        this.lineFro.from(fro);
    }

    public void resetStylesLine() {
        if (this.lineFro == null) {
            this.resetStyles();
            return;
        }
        this.from(this.lineFro);
    }

    public void from(FontRenderOptions fro) {
        this.fontScale = fro.fontScale;
        this.color = fro.color;
        this.bold = fro.bold;
        this.italic = fro.italic;
        this.strikethrough = fro.strikethrough;
        this.underline = fro.underline;
    }

    public int getShadowColor() {
        if (this.color == 0) {
            return 0x222222;
        }
        if (this.color == 0xFFAA00) {
            return 0x2A2A00;
        }
        int r = this.color >> 16 & 0xFF;
        int g = this.color >> 8 & 0xFF;
        int b = this.color & 0xFF;
        return ((r /= 4) & 0xFF) << 16 | ((g /= 4) & 0xFF) << 8 | (b /= 4) & 0xFF;
    }

    public static EnumChatFormatting getFormatting(String text, int index) {
        if (StringUtils.isEmpty((CharSequence)text) || index < 0 || index > text.length() - 2) {
            return null;
        }
        char c = text.charAt(index);
        if (c != '\u00a7') {
            return null;
        }
        return charFormats.get(Character.valueOf(text.charAt(index + 1)));
    }

    public static boolean isFormatting(String text, int index) {
        return FontRenderOptions.getFormatting(text, index) != null;
    }

    public static Link getLink(String text, int index) {
        if (StringUtils.isEmpty((CharSequence)text) || index < 0 || index > text.length() - 2) {
            return null;
        }
        if (text.charAt(index) != '[') {
            return null;
        }
        int i = text.indexOf(93);
        if (i < 2) {
            return null;
        }
        Link link = new Link(index, text.substring(index + 1, i));
        return link.isValid() ? link : null;
    }

    static {
        for (EnumChatFormatting ecf : EnumChatFormatting.values()) {
            charFormats.put(Character.valueOf(ecf.toString().charAt(1)), ecf);
        }
        for (int i = 0; i < 16; ++i) {
            int j = (i >> 3 & 1) * 85;
            int r = (i >> 2 & 1) * 170 + j;
            int g = (i >> 1 & 1) * 170 + j;
            int b = (i >> 0 & 1) * 170 + j;
            if (i == 6) {
                r += 85;
            }
            FontRenderOptions.colors[i] = (r & 0xFF) << 16 | (g & 0xFF) << 8 | b & 0xFF;
        }
    }
}

