/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.core.renderer.font;

import net.malisis.core.renderer.font.FontGeneratorOptions;
import net.malisis.core.renderer.icon.MalisisIcon;

public class CharData {
    protected char c;
    protected float ascent;
    protected float width;
    protected float height;
    protected float u;
    protected float U;
    protected float v;
    protected float V;

    public CharData(char c, float ascent, float width, float height) {
        this.c = c;
        this.c = c;
        this.ascent = ascent;
        this.width = width;
        this.height = height;
    }

    public char getChar() {
        return this.c;
    }

    public float u() {
        return this.u;
    }

    public float U() {
        return this.U;
    }

    public float v() {
        return this.v;
    }

    public float V() {
        return this.V;
    }

    public float getCharWidth() {
        return this.width;
    }

    public float getCharHeight() {
        return this.height;
    }

    public float getAscent() {
        return this.ascent;
    }

    public float getFullWidth(FontGeneratorOptions options) {
        return this.width + options.mx + options.px;
    }

    public float getFullHeight(FontGeneratorOptions options) {
        return this.height + options.my + options.py;
    }

    public void setUVs(float u, float v, float U, float V) {
        this.u = u;
        this.v = v;
        this.U = U;
        this.V = V;
    }

    public void setUVs(int x, int y, int size, FontGeneratorOptions options) {
        this.u = ((float)x - options.mx) / (float)size;
        this.v = ((float)y - options.my) / (float)size;
        this.U = ((float)x + this.width + options.px) / (float)size;
        this.V = ((float)y + this.height + options.py) / (float)size;
    }

    public MalisisIcon getIcon() {
        return new MalisisIcon("" + this.getChar(), this.u(), this.v(), this.U(), this.V());
    }
}

