/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.core.renderer;

import java.lang.reflect.Array;

public class Parameter<T>
implements Cloneable {
    private T defaultValue;
    private T value;

    public Parameter(T defaultValue) {
        this.defaultValue = defaultValue;
    }

    public T getDefault() {
        return this.defaultValue;
    }

    public T getValue() {
        return this.value;
    }

    public void reset() {
        this.value = null;
    }

    public T get() {
        return this.value != null ? this.value : this.defaultValue;
    }

    public void set(T value) {
        this.value = value;
    }

    public Object get(int index) {
        if (this.value == null) {
            return this.value;
        }
        if (this.value != null && !(this.value instanceof Object[])) {
            throw new IllegalStateException("Trying to access indexed element of non-array Parameter");
        }
        Object[] v = (Object[])this.value;
        if (index < 0 || index >= v.length) {
            return null;
        }
        return Array.get(this.value, index);
    }

    public void merge(Parameter<T> parameter) {
        if (parameter.getValue() != null) {
            this.value = parameter.getValue();
        }
    }

    public String toString() {
        return this.value + " [" + this.defaultValue + "]";
    }

    protected Parameter clone() {
        try {
            return (Parameter)super.clone();
        }
        catch (CloneNotSupportedException e) {
            e.printStackTrace();
            return null;
        }
    }
}

