/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.core.renderer;

import java.lang.reflect.Field;
import javax.vecmath.Matrix4f;
import net.malisis.core.MalisisCore;
import net.malisis.core.MalisisRegistry;
import net.malisis.core.asm.AsmUtils;
import net.malisis.core.block.BoundingBoxType;
import net.malisis.core.block.IBoundingBox;
import net.malisis.core.block.ISmartCull;
import net.malisis.core.renderer.IBlockRenderer;
import net.malisis.core.renderer.IRenderWorldLast;
import net.malisis.core.renderer.RenderParameters;
import net.malisis.core.renderer.RenderType;
import net.malisis.core.renderer.element.Face;
import net.malisis.core.renderer.element.Shape;
import net.malisis.core.renderer.element.Vertex;
import net.malisis.core.renderer.element.shape.Cube;
import net.malisis.core.renderer.font.FontRenderOptions;
import net.malisis.core.renderer.font.MalisisFont;
import net.malisis.core.renderer.icon.IIconProvider;
import net.malisis.core.renderer.icon.IMetaIconProvider;
import net.malisis.core.renderer.icon.MalisisIcon;
import net.malisis.core.renderer.icon.provider.IBlockIconProvider;
import net.malisis.core.renderer.icon.provider.IItemIconProvider;
import net.malisis.core.renderer.model.MalisisModel;
import net.malisis.core.util.BlockPosUtils;
import net.malisis.core.util.EnumFacingUtils;
import net.malisis.core.util.ItemUtils;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.renderer.DestroyBlockProgress;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderGlobal;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.WorldRenderer;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.client.renderer.vertex.VertexFormatElement;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumWorldBlockLayer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.Timer;
import net.minecraft.util.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import org.lwjgl.opengl.GL11;

public class MalisisRenderer
extends TileEntitySpecialRenderer
implements IBlockRenderer,
IRenderWorldLast {
    private static Field isDrawingField;
    public static VertexFormat vertexFormat;
    private boolean initialized = false;
    protected WorldRenderer wr = Tessellator.getInstance().getWorldRenderer();
    protected IBlockAccess world;
    protected BlockPos pos;
    protected Block block;
    protected IBlockState blockState;
    protected TileEntity tileEntity;
    protected float partialTick = 0.0f;
    protected ItemStack itemStack;
    protected Item item;
    protected ItemCameraTransforms.TransformType tranformType;
    protected RenderGlobal renderGlobal;
    protected RenderType renderType;
    protected int drawMode;
    protected int baseBrightness;
    protected MalisisIcon overrideTexture;
    protected boolean getBlockDamage = false;
    protected DestroyBlockProgress destroyBlockProgress = null;
    protected boolean vertexDrawn = false;
    private static Timer timer;

    public void reset() {
        this.wr = null;
        this.renderType = RenderType.UNSET;
        this.drawMode = 0;
        this.world = null;
        this.pos = null;
        this.block = null;
        this.blockState = null;
        this.tileEntity = null;
        this.item = null;
        this.itemStack = null;
        this.overrideTexture = null;
        this.destroyBlockProgress = null;
        this.tranformType = null;
    }

    public void set(IBlockAccess world, Block block, BlockPos pos, IBlockState blockState) {
        this.world = world;
        this.pos = new BlockPos((Vec3i)pos);
        this.block = block;
        this.blockState = blockState;
        this.tileEntity = world.getTileEntity(pos);
    }

    public void set(IBlockAccess world) {
        this.world = world;
    }

    public void set(Block block) {
        this.block = block;
        this.blockState = block.getDefaultState();
    }

    public void set(IBlockState blockState) {
        this.block = blockState.getBlock();
        this.blockState = blockState;
    }

    public void set(BlockPos pos) {
        this.pos = new BlockPos((Vec3i)pos);
    }

    public void set(TileEntity te, float partialTick) {
        this.set((IBlockAccess)te.getWorld(), te.getBlockType(), te.getPos(), te.getWorld().getBlockState(te.getPos()));
        this.partialTick = partialTick;
        this.tileEntity = te;
    }

    public void set(ItemStack itemStack) {
        this.itemStack = itemStack;
        this.item = itemStack.getItem();
        IBlockState state = ItemUtils.getStateFromItemStack(itemStack);
        if (state != null) {
            this.set(state);
        }
    }

    @Override
    public synchronized boolean renderBlock(WorldRenderer wr, IBlockAccess world, BlockPos pos, IBlockState state) {
        this.wr = wr;
        this.set(world, state.getBlock(), pos, state);
        this.prepare(RenderType.BLOCK, new double[0]);
        this.render();
        this.clean();
        return this.vertexDrawn;
    }

    @Override
    public synchronized boolean renderItem(ItemStack itemStack, float partialTick) {
        this.wr = Tessellator.getInstance().getWorldRenderer();
        this.set(itemStack);
        this.prepare(RenderType.ITEM, new double[0]);
        this.render();
        this.clean();
        return true;
    }

    @Override
    public void setTransformType(ItemCameraTransforms.TransformType transformType) {
        this.tranformType = transformType;
    }

    @Override
    public boolean isGui3d() {
        return true;
    }

    @Override
    public Matrix4f getTransform(ItemCameraTransforms.TransformType tranformType) {
        this.tranformType = tranformType;
        return null;
    }

    public synchronized void renderTileEntityAt(TileEntity te, double x, double y, double z, float partialTick, int destroyStage) {
        if (te.getBlockType() != te.getWorld().getBlockState(te.getPos()).getBlock()) {
            return;
        }
        this.wr = Tessellator.getInstance().getWorldRenderer();
        this.set(te, partialTick);
        this.prepare(RenderType.TILE_ENTITY, x, y, z);
        this.render();
        this.clean();
    }

    @Override
    public boolean shouldSetViewportPosition() {
        return true;
    }

    @Override
    public boolean shouldRender(RenderWorldLastEvent event, IBlockAccess world) {
        return true;
    }

    @Override
    public void renderWorldLastEvent(RenderWorldLastEvent event, IBlockAccess world) {
        this.set(world);
        this.wr = Tessellator.getInstance().getWorldRenderer();
        this.partialTick = event.partialTicks;
        this.renderGlobal = event.context;
        double x = 0.0;
        double y = 0.0;
        double z = 0.0;
        if (this.shouldSetViewportPosition()) {
            EntityPlayerSP p = Minecraft.getMinecraft().thePlayer;
            x = -(p.lastTickPosX + (p.posX - p.lastTickPosX) * (double)this.partialTick);
            y = -(p.lastTickPosY + (p.posY - p.lastTickPosY) * (double)this.partialTick);
            z = -(p.lastTickPosZ + (p.posZ - p.lastTickPosZ) * (double)this.partialTick);
        }
        this.prepare(RenderType.WORLD_LAST, x, y, z);
        this.render();
        this.clean();
    }

    public void prepare(RenderType renderType, double ... data) {
        this._initialize();
        this.vertexDrawn = false;
        this.renderType = renderType;
        if (renderType == RenderType.BLOCK) {
            this.wr.setVertexFormat(DefaultVertexFormats.BLOCK);
        } else if (renderType == RenderType.ITEM) {
            this.startDrawing();
        } else if (renderType == RenderType.TILE_ENTITY) {
            GlStateManager.pushAttrib();
            GlStateManager.pushMatrix();
            GlStateManager.disableLighting();
            GlStateManager.translate((double)data[0], (double)data[1], (double)data[2]);
            this.bindTexture(TextureMap.locationBlocksTexture);
            this.startDrawing();
        } else if (renderType == RenderType.WORLD_LAST) {
            GlStateManager.pushAttrib();
            GlStateManager.pushMatrix();
            GlStateManager.translate((double)data[0], (double)data[1], (double)data[2]);
            this.bindTexture(TextureMap.locationBlocksTexture);
            this.startDrawing();
        }
    }

    public void clean() {
        if (this.renderType == RenderType.ITEM) {
            this.draw();
        } else if (this.renderType == RenderType.TILE_ENTITY) {
            this.draw();
            this.disableBlending();
            GlStateManager.enableLighting();
            GlStateManager.popMatrix();
            GlStateManager.popAttrib();
        } else if (this.renderType == RenderType.WORLD_LAST) {
            this.draw();
            GlStateManager.popMatrix();
            GlStateManager.popAttrib();
        }
        this.reset();
    }

    public void startDrawing() {
        this.startDrawing(7);
    }

    public void startDrawing(int drawMode) {
        if (this.isDrawing()) {
            this.draw();
        }
        this.wr.startDrawing(drawMode);
        this.wr.setVertexFormat(vertexFormat);
        this.drawMode = drawMode;
    }

    public boolean isDrawing() {
        if (isDrawingField == null) {
            isDrawingField = AsmUtils.changeFieldAccess(WorldRenderer.class, "isDrawing", "field_179010_r");
        }
        try {
            if (this.wr == null) {
                throw new NullPointerException("[MalisisRenderer] WorldRenderer not set for " + (Object)((Object)this.renderType));
            }
            return isDrawingField.getBoolean(this.wr);
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            MalisisCore.log.error("[MalisisRenderer] Failed to get Tessellator.isDrawing value", (Throwable)e);
            return false;
        }
    }

    public void next() {
        this.next(this.drawMode);
    }

    public void next(int drawMode) {
        this.draw();
        this.startDrawing(drawMode);
    }

    public void draw() {
        if (this.isDrawing()) {
            Tessellator.getInstance().draw();
        }
    }

    public void enableBlending() {
        if (this.renderType == RenderType.BLOCK) {
            return;
        }
        GlStateManager.enableBlend();
        GlStateManager.tryBlendFuncSeparate((int)770, (int)771, (int)1, (int)0);
        GlStateManager.alphaFunc((int)516, (float)0.0f);
        GlStateManager.shadeModel((int)7425);
        GlStateManager.enableColorMaterial();
    }

    public void disableBlending() {
        if (this.renderType == RenderType.BLOCK) {
            return;
        }
        GlStateManager.disableColorMaterial();
        GlStateManager.shadeModel((int)7424);
        GlStateManager.disableBlend();
    }

    public void enableTextures() {
        GL11.glEnable((int)3553);
    }

    public void disableTextures() {
        GL11.glDisable((int)3553);
    }

    protected void bindTexture(ResourceLocation resourceLocaltion) {
        Minecraft.getMinecraft().getTextureManager().bindTexture(resourceLocaltion);
    }

    public void setBillboard(float x, float y, float z) {
        EntityPlayerSP player = Minecraft.getMinecraft().thePlayer;
        GlStateManager.pushMatrix();
        GlStateManager.translate((float)x, (float)y, (float)z);
        GlStateManager.rotate((float)(180.0f - player.rotationYaw), (float)0.0f, (float)1.0f, (float)0.0f);
    }

    public void endBillboard() {
        GlStateManager.popMatrix();
    }

    protected final void _initialize() {
        if (this.initialized) {
            return;
        }
        this.initialize();
        this.initialized = true;
    }

    protected void initialize() {
    }

    public void renderStandard() {
        Minecraft.getMinecraft().getBlockRendererDispatcher().renderBlock(this.blockState, this.pos, this.world, this.wr);
    }

    public void render() {
        this.drawShape(new Cube());
    }

    protected void drawModel(MalisisModel model, RenderParameters params) {
        for (Shape s : model) {
            this.drawShape(s, params);
        }
    }

    public void drawShape(Shape shape) {
        this.drawShape(shape, null);
    }

    public void drawShape(Shape s, RenderParameters params) {
        if (s == null) {
            return;
        }
        s.applyMatrix();
        for (Face f : s.getFaces()) {
            this.drawFace(f, params);
        }
    }

    protected void drawFace(Face face) {
        this.drawFace(face, null);
    }

    protected void drawFace(Face face, RenderParameters params) {
        if (face == null) {
            return;
        }
        int vertexCount = face.getVertexes().length;
        if (vertexCount != 4 && this.renderType == RenderType.BLOCK) {
            MalisisCore.log.error("[MalisisRenderer] Attempting to render a face containing {} vertexes in BLOCK for {}. Ignored", new Object[]{vertexCount, this.block});
            return;
        }
        if (!this.shouldRenderFace(face, params = RenderParameters.merge(params, face.getParameters()))) {
            return;
        }
        if (params.applyTexture.get().booleanValue()) {
            this.applyTexture(face, params);
        }
        if ((this.renderType == RenderType.ITEM || params.useNormals.get().booleanValue()) && params.direction.get() != null) {
            this.wr.setNormal((float)params.direction.get().getFrontOffsetX(), (float)params.direction.get().getFrontOffsetY(), (float)params.direction.get().getFrontOffsetZ());
        }
        this.baseBrightness = this.getBaseBrightness(params);
        for (int i = 0; i < face.getVertexes().length; ++i) {
            this.drawVertex(face.getVertexes()[i], i, params);
        }
        if (this.drawMode == 9 || this.drawMode == 6913 || this.drawMode == 3 || this.drawMode == 2) {
            this.next();
        }
    }

    protected void drawVertex(Vertex vertex, int number, RenderParameters params) {
        if (vertex == null) {
            vertex = new Vertex(0.0, 0.0, 0.0);
        }
        int brightness = this.calcVertexBrightness(vertex, number, params);
        vertex.setBrightness(brightness);
        int color = this.calcVertexColor(vertex, number, params);
        vertex.setColor(color);
        if (params != null && !params.usePerVertexAlpha.get().booleanValue()) {
            vertex.setAlpha(params.alpha.get());
        }
        if (params != null && this.renderType == RenderType.ITEM) {
            vertex.setNormal(params.direction.get());
        }
        this.wr.addVertexData(this.getVertexData(vertex));
        this.vertexDrawn = true;
    }

    private int[] getVertexData(Vertex vertex) {
        float x = (float)vertex.getX();
        float y = (float)vertex.getY();
        float z = (float)vertex.getZ();
        int size = vertexFormat.getNextOffset();
        if (this.renderType == RenderType.BLOCK) {
            size = DefaultVertexFormats.BLOCK.getNextOffset();
            BlockPos chunkPos = BlockPosUtils.chunkPosition(this.pos);
            x += (float)chunkPos.getX();
            y += (float)chunkPos.getY();
            z += (float)chunkPos.getZ();
        }
        int[] data = new int[size / 4];
        data[0] = Float.floatToRawIntBits(x);
        data[1] = Float.floatToRawIntBits(y);
        data[2] = Float.floatToRawIntBits(z);
        data[3] = vertex.getRGBA();
        data[4] = Float.floatToRawIntBits((float)vertex.getU());
        data[5] = Float.floatToRawIntBits((float)vertex.getV());
        data[6] = vertex.getBrightness();
        if (this.renderType != RenderType.BLOCK) {
            data[7] = vertex.getNormal();
        }
        return data;
    }

    public void drawText(MalisisFont font, String text, float x, float y, float z, FontRenderOptions fro) {
        if (font == null) {
            font = MalisisFont.minecraftFont;
        }
        if (fro == null) {
            fro = new FontRenderOptions();
        }
        font.render(this, text, x, y, z, fro);
    }

    protected boolean shouldRenderFace(Face face, RenderParameters params) {
        if (this.renderType != RenderType.BLOCK || this.world == null || this.block == null) {
            return true;
        }
        if (params != null && params.renderAllFaces.get().booleanValue()) {
            return true;
        }
        RenderParameters p = face.getParameters();
        if (p.direction.get() == null || p.renderAllFaces.get().booleanValue()) {
            return true;
        }
        if (ISmartCull.shouldSmartCull(this.block)) {
            return this.smartCull(face, params);
        }
        boolean b = this.block.shouldSideBeRendered(this.world, this.pos.offset(p.direction.get()), p.direction.get());
        return b;
    }

    protected boolean smartCull(Face face, RenderParameters params) {
        EnumFacing side = params.direction.get();
        AxisAlignedBB bounds = this.getRenderBounds(params);
        if (side == EnumFacing.DOWN && bounds.minY > 0.0) {
            return true;
        }
        if (side == EnumFacing.UP && bounds.maxY < 1.0) {
            return true;
        }
        if (side == EnumFacing.NORTH && bounds.minZ > 0.0) {
            return true;
        }
        if (side == EnumFacing.SOUTH && bounds.maxZ < 1.0) {
            return true;
        }
        if (side == EnumFacing.WEST && bounds.minX > 0.0) {
            return true;
        }
        if (side == EnumFacing.EAST && bounds.maxX < 1.0) {
            return true;
        }
        return !this.world.getBlockState(this.pos.offset(side)).getBlock().isOpaqueCube();
    }

    public void applyTexture(Shape shape) {
        this.applyTexture(shape, null);
    }

    public void applyTexture(Shape shape, RenderParameters params) {
        for (Face f : shape.getFaces()) {
            RenderParameters rp = RenderParameters.merge(params, f.getParameters());
            this.applyTexture(f, rp);
        }
    }

    public void applyTexture(Face face, RenderParameters params) {
        MalisisIcon icon = this.getIcon(face, params);
        if (this.blockState == null || params.textureSide.get() != EnumFacing.UP && params.textureSide.get() != EnumFacing.DOWN) {
            icon.setRotation(0);
        } else {
            icon.setRotation(EnumFacingUtils.getRotationCount(this.blockState));
        }
        boolean flipU = params.flipU.get();
        if (params.direction.get() == EnumFacing.NORTH || params.direction.get() == EnumFacing.EAST) {
            flipU = !flipU;
        }
        face.setTexture(icon, flipU, params.flipV.get(), params.interpolateUV.get());
    }

    protected MalisisIcon getIcon(Face face, RenderParameters params) {
        if (params.icon.get() != null) {
            return params.icon.get();
        }
        IIconProvider iconProvider = this.getIconProvider(params);
        if (iconProvider instanceof IItemIconProvider && this.itemStack != null) {
            return ((IItemIconProvider)iconProvider).getIcon(this.itemStack);
        }
        if (iconProvider instanceof IBlockIconProvider && this.block != null) {
            EnumFacing side = EnumFacingUtils.getRealSide(this.blockState, params.textureSide.get());
            IBlockIconProvider iblockp = (IBlockIconProvider)iconProvider;
            if (this.renderType == RenderType.BLOCK || this.renderType == RenderType.TILE_ENTITY) {
                return iblockp.getIcon(this.world, this.pos, this.blockState, side);
            }
            if (this.renderType == RenderType.ITEM) {
                return iblockp.getIcon(this.itemStack, side);
            }
        }
        return iconProvider != null ? iconProvider.getIcon() : MalisisIcon.missing;
    }

    protected IIconProvider getIconProvider(RenderParameters params) {
        if (params.iconProvider.get() != null) {
            return params.iconProvider.get();
        }
        if (this.item instanceof IMetaIconProvider && ((IMetaIconProvider)this.item).getIconProvider() != null) {
            return ((IMetaIconProvider)this.item).getIconProvider();
        }
        if (this.block instanceof IMetaIconProvider && ((IMetaIconProvider)this.block).getIconProvider() != null) {
            return ((IMetaIconProvider)this.block).getIconProvider();
        }
        return null;
    }

    protected int calcVertexColor(Vertex vertex, int number, RenderParameters params) {
        int color = 0xFFFFFF;
        if (params == null) {
            return color;
        }
        if (params.usePerVertexColor.get().booleanValue()) {
            color = vertex.getColor();
        } else if (params.colorMultiplier.get() != null) {
            color = params.colorMultiplier.get();
        } else if (this.block != null) {
            int n = color = this.world != null ? this.block.colorMultiplier(this.world, this.pos, 0) : this.block.getRenderColor(this.blockState);
        }
        if (this.drawMode == 1) {
            return color;
        }
        if (this.renderType != RenderType.BLOCK && this.renderType != RenderType.TILE_ENTITY) {
            return color;
        }
        int[][] aoMatrix = (int[][])params.aoMatrix.get(number);
        float factor = 1.0f;
        if (params.calculateAOColor.get().booleanValue() && aoMatrix != null && Minecraft.isAmbientOcclusionEnabled() && this.block.getLightValue(this.world, this.pos) == 0 && params.direction.get() != null) {
            factor = this.getBlockAmbientOcclusion(this.world, this.pos.offset(params.direction.get()));
            for (int i = 0; i < aoMatrix.length; ++i) {
                factor += this.getBlockAmbientOcclusion(this.world, this.pos.add(aoMatrix[i][0], aoMatrix[i][1], aoMatrix[i][2]));
            }
            factor /= (float)(aoMatrix.length + 1);
        }
        int r = (int)((float)(color >> 16 & 0xFF) * (factor *= params.colorFactor.get().floatValue()));
        int g = (int)((float)(color >> 8 & 0xFF) * factor);
        int b = (int)((float)(color & 0xFF) * factor);
        color = r << 16 | g << 8 | b;
        return color;
    }

    protected int getBaseBrightness(RenderParameters params) {
        if (!params.useEnvironmentBrightness.get().booleanValue()) {
            return params.brightness.get();
        }
        if (this.block != null) {
            if (this.world != null && this.block.getLightValue(this.world, this.pos) != 0) {
                return this.block.getLightValue(this.world, this.pos) << 4;
            }
            if (this.block.getLightValue() != 0) {
                return this.block.getLightValue() << 4;
            }
        }
        if (this.renderType == RenderType.ITEM) {
            return Minecraft.getMinecraft().thePlayer.getBrightnessForRender(MalisisRenderer.getPartialTick());
        }
        if (this.world == null || this.block == null) {
            return params.brightness.get();
        }
        if (params.direction.get() == null && this.block != null) {
            return this.block.getMixedBrightnessForBlock(this.world, this.pos);
        }
        AxisAlignedBB bounds = this.getRenderBounds(params);
        EnumFacing dir = params.direction.get();
        BlockPos p = this.pos;
        if (dir != null) {
            p = p.offset(dir);
        }
        if (bounds != null) {
            if (dir == EnumFacing.WEST && bounds.minX > 0.0) {
                p = p.east();
            } else if (dir == EnumFacing.EAST && bounds.maxX < 1.0) {
                p = p.west();
            } else if (dir == EnumFacing.NORTH && bounds.minZ > 0.0) {
                p = p.south();
            } else if (dir == EnumFacing.SOUTH && bounds.maxZ < 1.0) {
                p = p.north();
            } else if (dir == EnumFacing.DOWN && bounds.minY > 0.0) {
                p = p.up();
            } else if (dir == EnumFacing.UP && bounds.maxY < 1.0) {
                p = p.down();
            }
        }
        return this.getMixedBrightnessForBlock(this.world, p);
    }

    protected int calcVertexBrightness(Vertex vertex, int number, RenderParameters params) {
        if (params == null) {
            return this.baseBrightness;
        }
        if (params.usePerVertexBrightness.get().booleanValue()) {
            return vertex.getBrightness();
        }
        if (this.drawMode == 6913) {
            return this.baseBrightness;
        }
        if (this.renderType != RenderType.BLOCK && this.renderType != RenderType.TILE_ENTITY) {
            return this.baseBrightness;
        }
        int[][] aoMatrix = (int[][])params.aoMatrix.get(number);
        if (!params.calculateBrightness.get().booleanValue() || aoMatrix == null) {
            return this.baseBrightness;
        }
        if (!Minecraft.isAmbientOcclusionEnabled() || this.block.getLightValue(this.world, this.pos) != 0) {
            return this.baseBrightness;
        }
        int[] b = new int[Math.max(3, aoMatrix.length)];
        for (int i = 0; i < b.length; ++i) {
            int n = i;
            b[n] = b[n] + this.getMixedBrightnessForBlock(this.world, this.pos.add(aoMatrix[i][0], aoMatrix[i][1], aoMatrix[i][2]));
        }
        int brightness = this.getAoBrightness(b[0], b[1], b[2], this.baseBrightness);
        return brightness;
    }

    protected int getAoBrightness(int b1, int b2, int b3, int base) {
        if (b1 == 0) {
            b1 = base;
        }
        if (b2 == 0) {
            b2 = base;
        }
        if (b3 == 0) {
            b3 = base;
        }
        return b1 + b2 + b3 + base >> 2 & 0xFF00FF;
    }

    protected float getBlockAmbientOcclusion(IBlockAccess world, BlockPos pos) {
        Block block = world.getBlockState(pos).getBlock();
        if (block == null) {
            return 1.0f;
        }
        return block.getAmbientOcclusionLightValue();
    }

    protected int getMixedBrightnessForBlock(IBlockAccess world, BlockPos pos) {
        return world.getBlockState(pos).getBlock().getMixedBrightnessForBlock(world, pos);
    }

    protected AxisAlignedBB getRenderBounds(RenderParameters params) {
        if (this.block == null || !params.useBlockBounds.get().booleanValue()) {
            return params.renderBounds.get();
        }
        if (this.block instanceof IBoundingBox) {
            return ((IBoundingBox)this.block).getBoundingBox(this.world, this.pos, BoundingBoxType.RENDER);
        }
        if (this.world != null) {
            this.block.setBlockBoundsBasedOnState(this.world, this.pos);
        }
        return new AxisAlignedBB(this.block.getBlockBoundsMinX(), this.block.getBlockBoundsMinY(), this.block.getBlockBoundsMinZ(), this.block.getBlockBoundsMaxX(), this.block.getBlockBoundsMaxY(), this.block.getBlockBoundsMaxZ());
    }

    public static float getPartialTick() {
        if (timer == null) {
            Field f = AsmUtils.changeFieldAccess(Minecraft.class, "timer", "field_71428_T");
            try {
                timer = (Timer)f.get(Minecraft.getMinecraft());
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                MalisisCore.log.info("[MalisisRenderer] Failed to acces Minecraft timer.");
                timer = new Timer(20.0f);
            }
        }
        return MalisisRenderer.timer.elapsedPartialTicks;
    }

    public static EnumWorldBlockLayer getRenderLayer() {
        return MinecraftForgeClient.getRenderLayer();
    }

    public void registerFor(Block block) {
        MalisisRegistry.registerBlockRenderer(block, this);
    }

    public void registerFor(Item item) {
        MalisisRegistry.registerItemRenderer(item, this);
    }

    public void registerFor(Class<? extends TileEntity> clazz) {
        ClientRegistry.bindTileEntitySpecialRenderer(clazz, (TileEntitySpecialRenderer)this);
    }

    public void registerForRenderWorldLast() {
        MalisisRegistry.registerRenderWorldLast(this);
    }

    static {
        vertexFormat = new VertexFormat(){
            {
                this.setElement(new VertexFormatElement(0, VertexFormatElement.EnumType.FLOAT, VertexFormatElement.EnumUsage.POSITION, 3));
                this.setElement(new VertexFormatElement(0, VertexFormatElement.EnumType.UBYTE, VertexFormatElement.EnumUsage.COLOR, 4));
                this.setElement(new VertexFormatElement(0, VertexFormatElement.EnumType.FLOAT, VertexFormatElement.EnumUsage.UV, 2));
                this.setElement(new VertexFormatElement(1, VertexFormatElement.EnumType.SHORT, VertexFormatElement.EnumUsage.UV, 2));
                this.setElement(new VertexFormatElement(0, VertexFormatElement.EnumType.BYTE, VertexFormatElement.EnumUsage.NORMAL, 3));
                this.setElement(new VertexFormatElement(0, VertexFormatElement.EnumType.BYTE, VertexFormatElement.EnumUsage.PADDING, 1));
            }
        };
        timer = null;
    }
}

