/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.core.renderer;

import com.google.common.collect.ImmutableList;
import java.util.List;
import javax.vecmath.Matrix4f;
import net.malisis.core.MalisisRegistry;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.IBakedModel;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.client.model.IPerspectiveAwareModel;
import org.apache.commons.lang3.tuple.Pair;

public interface IItemRenderer {
    public boolean renderItem(ItemStack var1, float var2);

    public void setTransformType(ItemCameraTransforms.TransformType var1);

    public Matrix4f getTransform(ItemCameraTransforms.TransformType var1);

    public boolean isGui3d();

    public static class DummyModel
    implements IPerspectiveAwareModel {
        private Item item;
        private ModelResourceLocation rl;

        public DummyModel(Item item, String name) {
            this.item = item;
            this.rl = new ModelResourceLocation(name, "inventory");
        }

        public ModelResourceLocation getResourceLocation() {
            return this.rl;
        }

        public Pair<IBakedModel, Matrix4f> handlePerspective(ItemCameraTransforms.TransformType transformType) {
            IItemRenderer itemRenderer = MalisisRegistry.getItemRenderer(this.item);
            if (itemRenderer == null) {
                return Pair.of((Object)this, null);
            }
            itemRenderer.setTransformType(transformType);
            return Pair.of((Object)this, (Object)itemRenderer.getTransform(transformType));
        }

        public boolean isGui3d() {
            IItemRenderer itemRenderer = MalisisRegistry.getItemRenderer(this.item);
            return itemRenderer != null && itemRenderer.isGui3d();
        }

        public boolean isAmbientOcclusion() {
            return false;
        }

        public boolean isBuiltInRenderer() {
            return false;
        }

        public TextureAtlasSprite getTexture() {
            return null;
        }

        public ItemCameraTransforms getItemCameraTransforms() {
            return null;
        }

        public List<BakedQuad> getFaceQuads(EnumFacing side) {
            return ImmutableList.of();
        }

        public List<BakedQuad> getGeneralQuads() {
            return ImmutableList.of();
        }

        public String toString() {
            return this.item.getUnlocalizedName() + "[" + this.rl + "]";
        }
    }
}

