/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.core.renderer;

import java.util.HashMap;
import java.util.Map;
import javax.vecmath.Matrix4f;
import javax.vecmath.Vector3f;
import net.malisis.core.block.MalisisBlock;
import net.malisis.core.renderer.MalisisRenderer;
import net.malisis.core.renderer.RenderParameters;
import net.malisis.core.renderer.element.Shape;
import net.malisis.core.renderer.element.face.SouthFace;
import net.malisis.core.renderer.element.shape.Cube;
import net.malisis.core.renderer.icon.MalisisIcon;
import net.malisis.core.renderer.model.MalisisModel;
import net.malisis.core.renderer.model.loader.TextureModelLoader;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.util.AxisAlignedBB;
import net.minecraftforge.client.model.TRSRTransformation;

public class DefaultRenderer {
    public static MalisisRenderer nullRender = new Null();
    public static Block block = new Block();
    public static Item item = new Item();

    public static class Item
    extends MalisisRenderer {
        private Matrix4f thirdPerson = new TRSRTransformation(new Vector3f(0.01f, 0.065f, -0.195f), TRSRTransformation.quatFromYXZDegrees((Vector3f)new Vector3f(-90.0f, 0.0f, 0.0f)), new Vector3f(0.55f, 0.55f, 0.55f), null).getMatrix();
        private Matrix4f firstPerson = new TRSRTransformation(new Vector3f(0.0f, 0.28f, 0.14f), TRSRTransformation.quatFromYXZDegrees((Vector3f)new Vector3f(0.0f, -135.0f, 25.0f)), new Vector3f(1.7f, 1.7f, 1.7f), null).getMatrix();
        private Shape gui;
        private Map<MalisisIcon, MalisisModel> itemModels = new HashMap<MalisisIcon, MalisisModel>();

        @Override
        public void initialize() {
            this.gui = new Shape(new SouthFace());
        }

        @Override
        public boolean isGui3d() {
            return false;
        }

        @Override
        public Matrix4f getTransform(ItemCameraTransforms.TransformType tranformType) {
            if (tranformType == ItemCameraTransforms.TransformType.THIRD_PERSON) {
                return this.thirdPerson;
            }
            if (tranformType == ItemCameraTransforms.TransformType.FIRST_PERSON) {
                return this.firstPerson;
            }
            return null;
        }

        @Override
        public void render() {
            RenderParameters rp = new RenderParameters();
            rp.applyTexture.set(false);
            if (this.tranformType == ItemCameraTransforms.TransformType.GUI) {
                this.drawShape(this.gui);
            } else {
                this.drawShape(this.getModelShape(), rp);
            }
        }

        protected Shape getModelShape() {
            MalisisIcon icon = this.getIcon(null, new RenderParameters());
            MalisisModel model = this.itemModels.get((Object)icon);
            if (model == null) {
                model = new MalisisModel(new TextureModelLoader(icon));
                this.itemModels.put(icon, model);
            }
            return model.getShape("shape");
        }

        public void clearModels() {
            this.itemModels.clear();
        }
    }

    public static class Block
    extends MalisisRenderer {
        private Matrix4f defaultTransform = new TRSRTransformation(null, TRSRTransformation.quatFromYXZDegrees((Vector3f)new Vector3f(0.0f, 180.0f, 0.0f)), null, null).getMatrix();
        private Matrix4f thirdPerson = new TRSRTransformation(new Vector3f(0.0f, 0.09375f, -0.171875f), TRSRTransformation.quatFromYXZDegrees((Vector3f)new Vector3f(10.0f, -45.0f, 170.0f)), new Vector3f(0.375f, 0.375f, 0.375f), TRSRTransformation.quatFromYXZDegrees((Vector3f)new Vector3f(0.0f, 180.0f, 0.0f))).getMatrix();
        private Shape shape = new Cube();
        private RenderParameters rp = new RenderParameters();

        @Override
        protected void initialize() {
            this.rp.useBlockBounds.set(false);
        }

        @Override
        public boolean isGui3d() {
            return true;
        }

        @Override
        public Matrix4f getTransform(ItemCameraTransforms.TransformType tranformType) {
            return tranformType == ItemCameraTransforms.TransformType.THIRD_PERSON ? this.thirdPerson : this.defaultTransform;
        }

        @Override
        public void render() {
            AxisAlignedBB[] aabbs;
            for (AxisAlignedBB aabb : aabbs = ((MalisisBlock)this.block).getRenderBoundingBox(this.world, this.pos, this.blockState)) {
                if (aabb == null) continue;
                this.shape.resetState().limit(aabb);
                this.rp.renderBounds.set(aabb);
                this.drawShape(this.shape, this.rp);
            }
        }
    }

    public static class Null
    extends MalisisRenderer {
        @Override
        public void render() {
        }
    }
}

