/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.core.item;

import net.malisis.core.block.IBlockComponent;
import net.malisis.core.block.IMergedBlock;
import net.malisis.core.block.IRegisterable;
import net.malisis.core.block.MalisisBlock;
import net.malisis.core.renderer.icon.IIconProvider;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.World;

public class MalisisItemBlock
extends ItemBlock
implements IRegisterable {
    protected String name;
    protected IIconProvider iconProvider;

    public MalisisItemBlock(Block block) {
        super(block);
    }

    public MalisisItemBlock setName(String name) {
        this.name = name;
        super.setUnlocalizedName(name);
        return this;
    }

    public String getUnlocalizedName(ItemStack itemStack) {
        if (this.block instanceof MalisisBlock) {
            IBlockState state = ((MalisisBlock)this.block).getStateFromItemStack(itemStack);
            return ((MalisisBlock)this.block).getUnlocalizedName(state);
        }
        return super.getUnlocalizedName(itemStack);
    }

    @Override
    public String getRegistryName() {
        return this.name;
    }

    public int getMetadata(int damage) {
        return damage;
    }

    public boolean onItemUse(ItemStack itemStack, EntityPlayer player, World world, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (itemStack.stackSize == 0) {
            return false;
        }
        if (!player.canPlayerEdit(pos.offset(side), side, itemStack)) {
            return false;
        }
        IBlockState placedState = this.checkMerge(itemStack, player, world, pos, side, hitX, hitY, hitZ, false);
        BlockPos p = pos;
        if (placedState == null) {
            p = pos.offset(side);
            float x = hitX - (float)side.getFrontOffsetX();
            float y = hitY - (float)side.getFrontOffsetY();
            float z = hitZ - (float)side.getFrontOffsetZ();
            placedState = this.checkMerge(itemStack, player, world, p, side, x, y, z, true);
        }
        if (placedState == null) {
            return super.onItemUse(itemStack, player, world, pos, side, hitX, hitY, hitZ);
        }
        Block block = placedState.getBlock();
        if (world.checkNoEntityCollision(block.getCollisionBoundingBox(world, p, placedState)) && world.setBlockState(p, placedState, 3)) {
            world.playSoundEffect((double)((float)p.getX() + 0.5f), (double)((float)p.getY() + 0.5f), (double)((float)p.getZ() + 0.5f), block.stepSound.getPlaceSound(), (block.stepSound.getVolume() + 1.0f) / 2.0f, block.stepSound.getFrequency() * 0.8f);
            --itemStack.stackSize;
        }
        return true;
    }

    public boolean canPlaceBlockOnSide(World world, BlockPos pos, EnumFacing side, EntityPlayer player, ItemStack itemStack) {
        IMergedBlock mergedBlock = this.getMerged(world.getBlockState(pos));
        if (mergedBlock != null && mergedBlock.canMerge(itemStack, player, world, pos, side)) {
            return true;
        }
        mergedBlock = this.getMerged(world.getBlockState(pos = pos.offset(side)));
        if (mergedBlock != null && mergedBlock.canMerge(itemStack, player, world, pos, side)) {
            return true;
        }
        return super.canPlaceBlockOnSide(world, pos, side, player, itemStack);
    }

    private IMergedBlock getMerged(IBlockState state) {
        IMergedBlock mergedBlock = IBlockComponent.getComponent(IMergedBlock.class, state.getBlock());
        if (mergedBlock == null) {
            return null;
        }
        if (mergedBlock.mergeSelfOnly() && state.getBlock() != this.block) {
            return null;
        }
        return mergedBlock;
    }

    private IBlockState checkMerge(ItemStack itemStack, EntityPlayer player, World world, BlockPos pos, EnumFacing side, float hitX, float hitY, float hitZ, boolean offset) {
        IBlockState state = world.getBlockState(pos);
        IMergedBlock mergedBlock = this.getMerged(state);
        if (mergedBlock == null || !mergedBlock.canMerge(itemStack, player, world, pos, side)) {
            return null;
        }
        return mergedBlock.mergeBlock(world, pos, state, itemStack, player, side, hitX, hitY, hitZ);
    }
}

