/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.core.inventory;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import net.malisis.core.MalisisCore;
import net.malisis.core.inventory.IInventoryProvider;
import net.malisis.core.inventory.InventoryState;
import net.malisis.core.inventory.MalisisInventory;
import net.malisis.core.inventory.MalisisSlot;
import net.malisis.core.inventory.message.CloseInventoryMessage;
import net.malisis.core.inventory.message.UpdateInventorySlotsMessage;
import net.malisis.core.inventory.player.PlayerInventory;
import net.malisis.core.inventory.player.PlayerInventorySlot;
import net.malisis.core.util.ItemUtils;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.Container;
import net.minecraft.item.ItemStack;

public class MalisisInventoryContainer
extends Container {
    public static final int DRAG_TYPE_SPREAD = 0;
    public static final int DRAG_TYPE_ONE = 1;
    public static final int DRAG_TYPE_PICKUP = 2;
    protected EntityPlayer owner;
    private int nexInventoryId = 0;
    protected HashMap<Integer, MalisisInventory> inventories = new HashMap();
    protected ItemStack pickedItemStack;
    protected ItemStack pickedItemStackCache;
    protected int draggedAmount = 0;
    protected Set<MalisisSlot> draggedSlots = new HashSet<MalisisSlot>();
    protected int dragType = -1;
    protected ItemStack lastShiftClicked;

    public MalisisInventoryContainer(EntityPlayer player, int windowId) {
        if (player instanceof EntityPlayerMP) {
            EntityPlayerMP p = (EntityPlayerMP)player;
            p.closeContainer();
            p.getNextWindowId();
            windowId = p.currentWindowId;
        }
        this.owner = player;
        this.windowId = windowId;
        this.addInventory(new PlayerInventory(player));
        this.owner.openContainer = this;
    }

    public int addInventory(MalisisInventory inventory) {
        inventory.setInventoryId(this.nexInventoryId);
        this.inventories.put(this.nexInventoryId, inventory);
        if (this.nexInventoryId != 0) {
            inventory.addOpenedContainer(this);
        }
        return this.nexInventoryId++;
    }

    public void removeInventory(MalisisInventory inventory) {
        if (inventory == null || inventory.getInventoryId() == 0) {
            return;
        }
        inventory.removeOpenedContainer(this);
        this.inventories.remove(inventory.getInventoryId());
    }

    public MalisisInventory getInventory(int id) {
        return this.inventories.get(id);
    }

    public MalisisInventory getPlayerInventory() {
        return this.inventories.get(0);
    }

    public void setPickedItemStack(ItemStack itemStack) {
        this.pickedItemStack = itemStack;
        this.owner.inventory.setItemStack(itemStack);
    }

    public ItemStack getPickedItemStack() {
        return this.pickedItemStack;
    }

    public boolean isDraggingItemStack() {
        return this.dragType != -1;
    }

    public boolean shouldEndDrag(int button) {
        if (!this.isDraggingItemStack()) {
            return false;
        }
        if (this.dragType == 1 || this.dragType == 0) {
            return this.dragType == button && this.draggedSlots.size() > 1;
        }
        return this.dragType == 2;
    }

    public boolean shouldResetDrag(int button) {
        if (!this.isDraggingItemStack()) {
            return false;
        }
        if (this.dragType == 0) {
            return button == 1 && this.draggedSlots.size() > 1;
        }
        if (this.dragType == 1) {
            return button == 0 && this.draggedSlots.size() > 1;
        }
        return this.dragType != 2;
    }

    public int getDragType() {
        return this.dragType;
    }

    public void sendInventoryContent() {
        if (!(this.owner instanceof EntityPlayerMP)) {
            MalisisCore.log.error("MalisisInventoryContainer tried to send inventory contents CLIENT side!.");
            return;
        }
        for (MalisisInventory inventory : this.inventories.values()) {
            if (inventory.getInventoryId() == 0) continue;
            ArrayList<MalisisSlot> slots = new ArrayList<MalisisSlot>(Arrays.asList(inventory.getSlots()));
            UpdateInventorySlotsMessage.updateSlots(inventory.getInventoryId(), slots, (EntityPlayerMP)this.owner, this.windowId);
        }
    }

    public void detectAndSendChanges() {
        for (MalisisInventory inventory : this.inventories.values()) {
            this.detectAndSendInventoryChanges(inventory);
        }
        this.detectAndSendPickedItemStack();
    }

    public void detectAndSendInventoryChanges(MalisisInventory inventory) {
        if (!(this.owner instanceof EntityPlayerMP)) {
            MalisisCore.log.error("MalisisInventoryContainer tried to send inventory slots CLIENT side !.");
            return;
        }
        ArrayList<MalisisSlot> changedSlots = new ArrayList<MalisisSlot>();
        for (MalisisSlot slot : inventory.getSlots()) {
            if (!slot.hasChanged(this.owner)) continue;
            changedSlots.add(slot);
            slot.updateCache(this.owner);
        }
        if (changedSlots.size() > 0) {
            UpdateInventorySlotsMessage.updateSlots(inventory.getInventoryId(), changedSlots, (EntityPlayerMP)this.owner, this.windowId);
        }
    }

    public void detectAndSendPickedItemStack() {
        if (!(this.owner instanceof EntityPlayerMP)) {
            MalisisCore.log.error(" MalisisInventoryContainer tried to send picked itemStack CLIENT side !.");
            return;
        }
        if (ItemStack.areItemStacksEqual((ItemStack)this.pickedItemStack, (ItemStack)this.pickedItemStackCache)) {
            return;
        }
        UpdateInventorySlotsMessage.updatePickedItemStack(this.pickedItemStack, (EntityPlayerMP)this.owner, this.windowId);
        this.pickedItemStackCache = this.pickedItemStack != null ? this.pickedItemStack.copy() : null;
    }

    public void close() {
        this.onContainerClosed(this.owner);
        CloseInventoryMessage.send((EntityPlayerMP)this.owner);
    }

    public void onContainerClosed(EntityPlayer owner) {
        super.onContainerClosed(owner);
        for (MalisisInventory inventory : this.inventories.values()) {
            if (inventory.getInventoryId() == 0) continue;
            inventory.removeOpenedContainer(this);
        }
    }

    public ItemStack handleAction(ActionType action, int inventoryId, int slotNumber, int code) {
        MalisisInventory inv = this.inventories.get(inventoryId);
        if (inv == null) {
            MalisisCore.log.error("[MalisisInventoryContainer] Tried to handle an action for a wrong inventory (" + inventoryId + ").");
            return null;
        }
        MalisisSlot slot = inv.getSlot(slotNumber);
        if (slot == null) {
            MalisisCore.log.error("[MalisisInventoryContainer] Tried to handle an action for a wrong slotNumber (" + slotNumber + ").");
            return null;
        }
        if (slot.isState(InventoryState.FROZEN)) {
            return this.pickedItemStack;
        }
        if (slot.getItemStack() != null && slot.getItemStack().getItem() instanceof IInventoryProvider && slot.getItemStack().getTagCompound() != null) {
            if (slot.getItemStack().getTagCompound().getInteger("inventoryId") == 1) {
                this.owner.closeScreen();
                return null;
            }
            if (slot.getItemStack().getTagCompound().hasKey("inventoryId")) {
                slot.getItemStack().getTagCompound().removeTag("inventoryId");
            }
        }
        if (action == ActionType.HOTBAR && code >= 0 && code < 9) {
            return this.handleHotbar(slot, code);
        }
        if (action == ActionType.DROP_SLOT_STACK || action == ActionType.DROP_SLOT_ONE) {
            return this.handleDropSlot(slot, action == ActionType.DROP_SLOT_STACK);
        }
        if (action.isDragAction()) {
            return this.handleDrag(action, inventoryId, slot);
        }
        this.resetDrag();
        if (action == ActionType.DROP_ONE || action == ActionType.DROP_STACK) {
            return this.handleDropPickedStack(action == ActionType.DROP_STACK);
        }
        if (action == ActionType.PICKBLOCK && this.owner.capabilities.isCreativeMode) {
            return this.handlePickBlock(slot);
        }
        if (action == ActionType.LEFT_CLICK || action == ActionType.RIGHT_CLICK) {
            return this.handleNormalClick(slot, action == ActionType.LEFT_CLICK);
        }
        if (action == ActionType.SHIFT_LEFT_CLICK) {
            this.lastShiftClicked = slot.getItemStack();
            ItemStack itemStack = this.handleShiftClick(inventoryId, slot);
            if (itemStack != null) {
                this.lastShiftClicked = null;
            }
            return itemStack;
        }
        if (action == ActionType.DOUBLE_LEFT_CLICK || action == ActionType.DOUBLE_SHIFT_LEFT_CLICK) {
            return this.handleDoubleClick(inventoryId, slot, action == ActionType.DOUBLE_SHIFT_LEFT_CLICK);
        }
        return null;
    }

    private ItemStack handleDropPickedStack(boolean fullStack) {
        ItemUtils.ItemStackSplitter iss = new ItemUtils.ItemStackSplitter(this.pickedItemStack);
        iss.split(fullStack ? -1 : 1);
        this.owner.dropPlayerItemWithRandomChoice(iss.split, true);
        this.setPickedItemStack(iss.source);
        return iss.source;
    }

    private ItemStack handleNormalClick(MalisisSlot slot, boolean fullStack) {
        if (this.pickedItemStack != null && !slot.isItemValid(this.pickedItemStack)) {
            return null;
        }
        if (this.pickedItemStack != null) {
            if (slot.isState(InventoryState.PLAYER_INSERT | InventoryState.PLAYER_EXTRACT)) {
                this.setPickedItemStack(slot.insert(this.pickedItemStack, fullStack ? -1 : 1, true));
            }
        } else if (slot.isState(InventoryState.PLAYER_EXTRACT)) {
            this.setPickedItemStack(slot.extract(fullStack ? -1 : -2));
        }
        return this.getPickedItemStack();
    }

    private ItemStack handleShiftClick(int inventoryId, MalisisSlot slot) {
        MalisisInventory targetInventory;
        if (slot.getItemStack() == null) {
            return null;
        }
        ItemStack itemStack = slot.getItemStack();
        if (inventoryId != 0) {
            if (!slot.isState(InventoryState.PLAYER_EXTRACT)) {
                return null;
            }
            if (!this.inventories.get((Object)Integer.valueOf((int)0)).state.is(InventoryState.PLAYER_INSERT)) {
                return null;
            }
            itemStack = this.inventories.get(0).transferInto(itemStack);
            slot.setItemStack(itemStack);
            slot.onSlotChanged();
            return itemStack;
        }
        if (!this.inventories.get((Object)Integer.valueOf((int)0)).state.is(InventoryState.PLAYER_EXTRACT)) {
            return null;
        }
        int i = 1;
        while (itemStack != null && (targetInventory = this.inventories.get(i++)) != null) {
            if (!targetInventory.state.is(InventoryState.PLAYER_INSERT)) continue;
            itemStack = targetInventory.transferInto(itemStack);
            slot.setItemStack(itemStack);
            slot.onSlotChanged();
        }
        return itemStack;
    }

    private ItemStack handleHotbar(MalisisSlot slot, int num) {
        boolean fromPlayerInv = slot instanceof PlayerInventorySlot;
        MalisisSlot hotbarSlot = this.inventories.get(0).getSlot(num);
        if (fromPlayerInv || slot.getItemStack() == null) {
            if (slot.isState(InventoryState.PLAYER_INSERT)) {
                ItemStack dest = hotbarSlot.extract(-1);
                ItemStack src = slot.extract(-1);
                if ((dest = slot.insert(dest)) != null) {
                    hotbarSlot.insert(dest);
                    this.inventories.get(0).transferInto(src);
                } else {
                    src = hotbarSlot.insert(src);
                }
            }
        } else if (slot.isState(InventoryState.PLAYER_EXTRACT)) {
            ItemStack dest = slot.extract(-1);
            ItemStack left = hotbarSlot.insert(dest, -1, true);
            this.inventories.get(0).transferInto(left, false);
        }
        return hotbarSlot.getItemStack();
    }

    private ItemStack handleDropSlot(MalisisSlot slot, boolean fullStack) {
        if (slot.getItemStack() == null) {
            return null;
        }
        if (!slot.isState(InventoryState.PLAYER_EXTRACT)) {
            return null;
        }
        ItemUtils.ItemStackSplitter iss = new ItemUtils.ItemStackSplitter(slot.getItemStack());
        iss.split(fullStack ? -1 : 1);
        slot.setItemStack(iss.source);
        slot.onSlotChanged();
        this.owner.dropPlayerItemWithRandomChoice(iss.split, true);
        if (iss.amount != 0) {
            slot.onPickupFromSlot(this.owner, iss.split);
        }
        return iss.split;
    }

    private ItemStack handleDoubleClick(int inventoryId, MalisisSlot slot, boolean shiftClick) {
        MalisisInventory inventory = this.inventories.get(inventoryId);
        if (!inventory.state.is(InventoryState.PLAYER_EXTRACT)) {
            return null;
        }
        if (!shiftClick && this.pickedItemStack != null) {
            for (int i = 0; this.pickedItemStack.stackSize < this.pickedItemStack.getMaxStackSize() && i < inventory.size; ++i) {
                MalisisSlot s;
                if (!slot.isState(InventoryState.PLAYER_EXTRACT) || (s = inventory.getSlot(i)).getItemStack() == null || s.getItemStack().stackSize == s.getItemStack().getMaxStackSize()) continue;
                ItemUtils.ItemStacksMerger ism = new ItemUtils.ItemStacksMerger(s.getItemStack(), this.pickedItemStack);
                ism.merge();
                s.setItemStack(ism.merge);
                s.onSlotChanged();
                this.pickedItemStack = ism.into;
            }
            this.setPickedItemStack(this.pickedItemStack);
        } else if (this.lastShiftClicked != null) {
            for (MalisisSlot s : inventory.getSlots()) {
                ItemStack itemStack = s.getItemStack();
                if (!slot.isState(InventoryState.PLAYER_EXTRACT) || !ItemUtils.areItemStacksStackable(itemStack, this.lastShiftClicked)) continue;
                if (inventoryId != 0) {
                    itemStack = this.inventories.get(0).transferInto(itemStack);
                    s.setItemStack(itemStack);
                    s.onSlotChanged();
                } else {
                    MalisisInventory targetInventory;
                    int i = 1;
                    while (itemStack != null && (targetInventory = this.inventories.get(i++)) != null) {
                        if (!targetInventory.state.is(InventoryState.PLAYER_INSERT)) continue;
                        itemStack = targetInventory.transferInto(itemStack);
                        s.setItemStack(itemStack);
                        s.onSlotChanged();
                    }
                }
                if (itemStack == null) continue;
                return this.pickedItemStack;
            }
        }
        this.lastShiftClicked = null;
        return this.pickedItemStack;
    }

    private ItemStack handlePickBlock(MalisisSlot slot) {
        if (slot.getItemStack() == null || this.pickedItemStack != null) {
            return null;
        }
        ItemStack itemStack = slot.getItemStack().copy();
        itemStack.stackSize = itemStack.getMaxStackSize();
        this.setPickedItemStack(itemStack);
        return itemStack;
    }

    private ItemStack handleDrag(ActionType action, int inventoryId, MalisisSlot slot) {
        if (this.pickedItemStack == null) {
            return null;
        }
        if ((action == ActionType.DRAG_START_LEFT_CLICK || action == ActionType.DRAG_START_RIGHT_CLICK) && this.isDraggingItemStack()) {
            return null;
        }
        if (action == ActionType.DRAG_RESET) {
            this.resetDrag();
            return this.pickedItemStack;
        }
        if (action == ActionType.DRAG_END && this.dragType == 2) {
            int size = this.pickedItemStack.stackSize;
            this.resetDrag();
            this.pickedItemStack.stackSize = size;
            return this.pickedItemStack;
        }
        if (action == ActionType.DRAG_END) {
            int amountMerged = 0;
            for (MalisisSlot s : this.draggedSlots) {
                if (!s.isItemValid(this.pickedItemStack) || !s.isState(InventoryState.PLAYER_INSERT) || s.getDraggedItemStack() == null) continue;
                amountMerged += s.getDraggedItemStack().stackSize;
                s.insert(s.getDraggedItemStack());
                s.setDraggedItemStack(null);
            }
            if (this.pickedItemStack.stackSize == 0) {
                this.setPickedItemStack(null);
            }
            this.resetDrag();
            if (this.pickedItemStack != null) {
                this.pickedItemStack.stackSize -= amountMerged;
            }
            return this.pickedItemStack;
        }
        if (action == ActionType.DRAG_START_PICKUP) {
            if (slot.isState(InventoryState.PLAYER_EXTRACT)) {
                this.dragType = 2;
            }
            return this.pickedItemStack;
        }
        if (action == ActionType.DRAG_ADD_SLOT && this.dragType == 2) {
            if (this.pickedItemStack.stackSize >= this.pickedItemStack.getMaxStackSize()) {
                return this.pickedItemStack;
            }
            if (!slot.isState(InventoryState.PLAYER_EXTRACT)) {
                return this.pickedItemStack;
            }
            ItemUtils.ItemStacksMerger ism = new ItemUtils.ItemStacksMerger(slot.getItemStack(), this.pickedItemStack);
            ism.merge();
            this.setPickedItemStack(ism.into);
            slot.setItemStack(ism.merge);
            slot.onSlotChanged();
            return this.pickedItemStack;
        }
        if (!slot.isState(InventoryState.PLAYER_INSERT)) {
            return this.pickedItemStack;
        }
        this.draggedSlots.add(slot);
        if (action == ActionType.DRAG_START_LEFT_CLICK || action == ActionType.DRAG_START_RIGHT_CLICK) {
            this.draggedAmount = this.pickedItemStack.stackSize;
            this.dragType = action == ActionType.DRAG_START_LEFT_CLICK ? 0 : 1;
            return this.pickedItemStack;
        }
        if (this.draggedSlots.size() > this.draggedAmount) {
            return null;
        }
        if (this.draggedSlots.size() <= 1) {
            return this.pickedItemStack;
        }
        int amountPerSlot = this.dragType == 0 ? Math.max(this.draggedAmount / this.draggedSlots.size(), 1) : 1;
        int amountTotal = 0;
        for (MalisisSlot s : this.draggedSlots) {
            if (!s.isItemValid(this.pickedItemStack)) continue;
            ItemStack itemStack = this.pickedItemStack.copy();
            itemStack.stackSize = this.draggedAmount;
            ItemStack slotStack = s.getItemStack();
            if (slotStack != null) {
                slotStack = slotStack.copy();
            }
            ItemUtils.ItemStacksMerger ism = new ItemUtils.ItemStacksMerger(itemStack, slotStack);
            ism.merge(amountPerSlot, s.getSlotStackLimit());
            if (s.getItemStack() != null) {
                ism.into.stackSize -= s.getItemStack().stackSize;
            }
            s.setDraggedItemStack(ism.into);
            amountTotal += ism.nbMerged;
        }
        this.pickedItemStack.stackSize = this.draggedAmount - amountTotal;
        return this.pickedItemStack;
    }

    protected void resetDrag() {
        if (!this.isDraggingItemStack()) {
            return;
        }
        if (this.pickedItemStack != null) {
            this.pickedItemStack.stackSize = this.draggedAmount;
        }
        for (MalisisSlot s : this.draggedSlots) {
            s.setDraggedItemStack(null);
        }
        this.draggedSlots.clear();
        this.draggedAmount = 0;
        this.dragType = -1;
    }

    public boolean canInteractWith(EntityPlayer var1) {
        return true;
    }

    public static enum ActionType {
        LEFT_CLICK,
        RIGHT_CLICK,
        PICKBLOCK,
        SHIFT_LEFT_CLICK,
        SHIFT_RIGHT_CLICK,
        DOUBLE_LEFT_CLICK,
        DOUBLE_SHIFT_LEFT_CLICK,
        DRAG_START_LEFT_CLICK,
        DRAG_START_RIGHT_CLICK,
        DRAG_START_PICKUP,
        DRAG_ADD_SLOT,
        DRAG_END,
        DRAG_RESET,
        HOTBAR,
        DROP_ONE,
        DROP_STACK,
        DROP_SLOT_ONE,
        DROP_SLOT_STACK;


        public boolean isDragAction() {
            return this == DRAG_START_LEFT_CLICK || this == DRAG_START_RIGHT_CLICK || this == DRAG_START_PICKUP || this == DRAG_ADD_SLOT || this == DRAG_END || this == DRAG_RESET;
        }
    }
}

