/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.core.inventory;

import net.malisis.core.client.gui.MalisisGui;
import net.malisis.core.inventory.MalisisInventory;
import net.malisis.core.inventory.MalisisInventoryContainer;
import net.malisis.core.inventory.MalisisSlot;
import net.malisis.core.util.ItemUtils;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockPos;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.IChatComponent;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public interface IInventoryProvider {

    public static interface IDeferredInventoryProvider<T>
    extends IInventoryProvider {
        public MalisisInventory getInventory(T var1);

        @SideOnly(value=Side.CLIENT)
        public MalisisGui getGui(T var1, MalisisInventoryContainer var2);

        default public MalisisInventory[] getInventories(T data) {
            return new MalisisInventory[]{this.getInventory(data)};
        }

        default public void clear(T data) {
            for (MalisisInventory inventory : this.getInventories(data)) {
                inventory.emptyInventory();
            }
        }

        default public void breakInventories(T data, World world, BlockPos pos) {
            for (MalisisInventory inventory : this.getInventories(data)) {
                inventory.breakInventory(world, pos);
            }
        }
    }

    public static interface IDirectInventoryProvider
    extends IInventoryProvider,
    IInventory {
        public MalisisInventory getInventory();

        default public MalisisInventory[] getInventories() {
            return new MalisisInventory[]{this.getInventory()};
        }

        @SideOnly(value=Side.CLIENT)
        public MalisisGui getGui(MalisisInventoryContainer var1);

        default public void clear() {
            for (MalisisInventory inventory : this.getInventories()) {
                inventory.emptyInventory();
            }
        }

        default public void breakInventories(World world, BlockPos pos) {
            for (MalisisInventory inventory : this.getInventories()) {
                inventory.breakInventory(world, pos);
            }
        }

        default public boolean hasCustomName() {
            return this.getInventory() != null && this.getInventory().hasCustomName();
        }

        default public String getCommandSenderName() {
            return this.getInventory() != null ? this.getInventory().getName() : null;
        }

        default public IChatComponent getDisplayName() {
            return this.hasCustomName() ? new ChatComponentText(this.getCommandSenderName()) : new ChatComponentTranslation(this.getCommandSenderName(), new Object[0]);
        }

        default public int getSizeInventory() {
            return this.getInventory() != null ? this.getInventory().size : 0;
        }

        default public ItemStack getStackInSlot(int index) {
            return this.getInventory() != null ? this.getInventory().getItemStack(index) : null;
        }

        default public ItemStack decrStackSize(int index, int count) {
            return this.getInventory() != null ? new ItemUtils.ItemStackSplitter(this.getInventory().getItemStack(index)).split(count) : null;
        }

        default public ItemStack getStackInSlotOnClosing(int index) {
            return this.getStackInSlot(index);
        }

        default public void setInventorySlotContents(int index, ItemStack stack) {
            MalisisInventory inventory = this.getInventory();
            if (inventory != null) {
                inventory.setItemStack(index, stack);
            }
        }

        default public int getInventoryStackLimit() {
            return this.getInventory() != null ? this.getInventory().getInventoryStackLimit() : 0;
        }

        default public void markDirty() {
        }

        default public boolean isUseableByPlayer(EntityPlayer player) {
            return true;
        }

        default public void openInventory(EntityPlayer player) {
        }

        default public void closeInventory(EntityPlayer player) {
        }

        default public boolean isItemValidForSlot(int index, ItemStack stack) {
            MalisisInventory inventory = this.getInventory();
            if (inventory == null) {
                return false;
            }
            MalisisSlot slot = inventory.getSlot(index);
            return slot != null && slot.isItemValid(stack);
        }

        default public int getField(int id) {
            return 0;
        }

        default public void setField(int id, int value) {
        }

        default public int getFieldCount() {
            return 0;
        }
    }
}

