/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.core.configuration.setting;

import com.google.common.base.Preconditions;
import net.malisis.core.client.gui.MalisisGui;
import net.malisis.core.client.gui.component.UIComponent;
import net.minecraft.util.StatCollector;
import net.minecraftforge.common.config.Configuration;
import net.minecraftforge.common.config.Property;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class Setting<T> {
    protected Property property;
    protected Property.Type type;
    protected String category = "General";
    protected String key;
    protected String[] comments = new String[0];
    protected T defaultValue;
    protected T value;

    public Setting(String key, T defaultValue) {
        this.type = Property.Type.STRING;
        this.key = key;
        this.defaultValue = Preconditions.checkNotNull(defaultValue);
    }

    public void setCategory(String category) {
        this.category = category;
    }

    public void setComment(String ... comment) {
        this.comments = comment;
    }

    public void set(T value) {
        this.value = Preconditions.checkNotNull(value);
    }

    public T get() {
        return this.value;
    }

    public void load(Configuration config) {
        String comment = null;
        for (String c : this.comments) {
            comment = comment + StatCollector.translateToLocal((String)c) + " ";
        }
        this.property = config.get(this.category, this.key, this.writeValue(this.defaultValue), comment, this.type);
        this.value = this.readValue(this.property.getString());
        if (this.value == null) {
            throw new NullPointerException("readPropertyValue should not return null!");
        }
    }

    public void save() {
        this.property.set(this.writeValue(this.value));
    }

    public String[] getComments() {
        return this.comments;
    }

    public abstract T readValue(String var1);

    public abstract String writeValue(T var1);

    @SideOnly(value=Side.CLIENT)
    public abstract UIComponent getComponent(MalisisGui var1);

    @SideOnly(value=Side.CLIENT)
    public abstract T getValueFromComponent();
}

