/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.core.client.gui.component.interaction;

import net.malisis.core.client.gui.MalisisGui;
import net.malisis.core.client.gui.component.interaction.UITextField;
import net.malisis.core.client.gui.event.ComponentEvent;
import net.minecraft.client.gui.GuiScreen;

public class UIPasswordField
extends UITextField {
    private char passwordChar = (char)42;
    private StringBuilder password = new StringBuilder();

    public UIPasswordField(MalisisGui gui) {
        super(gui, null, false);
    }

    public UIPasswordField(MalisisGui gui, char passwordChar) {
        this(gui);
        this.passwordChar = passwordChar;
    }

    public char getPasswordCharacter() {
        return this.passwordChar;
    }

    public void setPasswordCharacter(char passwordChar) {
        this.passwordChar = passwordChar;
    }

    @Override
    public String getText() {
        return this.password.toString();
    }

    protected void updateText() {
        this.text.setLength(0);
        this.text.append(this.password.toString().replaceAll("(?s).", String.valueOf(this.passwordChar)));
    }

    @Override
    public void addText(String text) {
        if (this.selectingText) {
            this.deleteSelectedText();
        }
        int position = this.cursorPosition.textPosition;
        String oldValue = this.password.toString();
        String newValue = new StringBuilder(oldValue).insert(position, text).toString();
        if (!this.validateText(newValue)) {
            return;
        }
        if (!this.fireEvent(new ComponentEvent.ValueChange<UIPasswordField, String>(this, oldValue, newValue))) {
            return;
        }
        this.password.insert(position, text);
        this.cursorPosition.jumpBy(text.length());
        this.updateText();
    }

    @Override
    public void setText(String text) {
        if (!this.validateText(text)) {
            return;
        }
        this.password.setLength(0);
        this.password.append(text);
        this.selectingText = false;
        if (this.focused) {
            this.cursorPosition.jumpToEnd();
        }
        this.updateText();
    }

    @Override
    public void deleteSelectedText() {
        if (!this.selectingText) {
            return;
        }
        int start = Math.min(this.selectionPosition.textPosition, this.cursorPosition.textPosition);
        int end = Math.max(this.selectionPosition.textPosition, this.cursorPosition.textPosition);
        this.password.delete(start, end);
        this.selectingText = false;
        this.cursorPosition.jumpTo(start);
        this.updateText();
    }

    @Override
    protected boolean handleCtrlKeyDown(int keyCode) {
        return GuiScreen.isCtrlKeyDown() && keyCode != 46 && keyCode != 45 && super.handleCtrlKeyDown(keyCode);
    }
}

