/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.core.client.gui.component.decoration;

import net.malisis.core.client.gui.GuiRenderer;
import net.malisis.core.client.gui.MalisisGui;
import net.malisis.core.client.gui.component.UIComponent;
import net.malisis.core.client.gui.element.SimpleGuiShape;
import net.malisis.core.renderer.icon.provider.GuiIconProvider;

public class UIProgressBar
extends UIComponent<UIProgressBar> {
    protected float progress = 0.0f;
    protected boolean reversed = false;
    protected GuiIconProvider filledIconProvider;

    public UIProgressBar(MalisisGui gui) {
        super(gui);
        this.setSize(22, 16);
        this.shape = new SimpleGuiShape();
        this.iconProvider = new GuiIconProvider(gui.getGuiTexture().getIcon(246, 0, 22, 16));
        this.filledIconProvider = new GuiIconProvider(gui.getGuiTexture().getIcon(246, 16, 22, 16));
    }

    public float getProgress() {
        return this.progress;
    }

    public UIProgressBar setReversed() {
        this.reversed = true;
        return this;
    }

    public void setProgress(float progress) {
        if (progress < 0.0f) {
            progress = 0.0f;
        }
        if (progress > 1.0f) {
            progress = 1.0f;
        }
        this.progress = progress;
    }

    @Override
    public void drawBackground(GuiRenderer renderer, int mouseX, int mouseY, float partialTick) {
        this.shape.resetState();
        this.shape.setSize(this.width, this.height);
        renderer.drawShape(this.shape, this.rp);
    }

    @Override
    public void drawForeground(GuiRenderer renderer, int mouseX, int mouseY, float partialTick) {
        int width = (int)((float)this.width * this.progress);
        this.shape.resetState();
        this.shape.setSize(width, 16);
        this.shape.translate(this.reversed ? this.width - width : 0, 0);
        renderer.drawShape(this.shape, this.rp);
    }
}

