/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.core.client.gui.component.container;

import java.util.LinkedHashMap;
import java.util.Map;
import net.malisis.core.client.gui.Anchor;
import net.malisis.core.client.gui.ComponentPosition;
import net.malisis.core.client.gui.MalisisGui;
import net.malisis.core.client.gui.component.UIComponent;
import net.malisis.core.client.gui.component.container.UIContainer;
import net.malisis.core.client.gui.component.container.UIWindow;
import net.malisis.core.client.gui.component.interaction.UITab;
import net.malisis.core.client.gui.event.ComponentEvent;
import net.malisis.core.renderer.animation.transformation.ITransformable;
import net.malisis.core.renderer.icon.GuiIcon;

public class UITabGroup
extends UIContainer<UITabGroup> {
    protected Map<UITab, UIContainer> listTabs = new LinkedHashMap<UITab, UIContainer>();
    protected UITab activeTab;
    protected ComponentPosition tabPosition = ComponentPosition.TOP;
    protected UIContainer attachedContainer;
    protected int offset = 3;
    protected int spacing = 0;
    protected GuiIcon[] windowIcons;
    protected GuiIcon[] panelIcons;

    public UITabGroup(MalisisGui gui, ComponentPosition tabPosition) {
        super(gui);
        this.tabPosition = tabPosition;
        this.clipContent = false;
        this.setSize(0, 0);
        this.windowIcons = new GuiIcon[]{gui.getGuiTexture().getXYResizableIcon(0, 60, 15, 15, 5), gui.getGuiTexture().getXYResizableIcon(15, 60, 15, 15, 5), gui.getGuiTexture().getXYResizableIcon(0, 75, 15, 15, 5), gui.getGuiTexture().getXYResizableIcon(15, 75, 15, 15, 5)};
        this.panelIcons = new GuiIcon[]{gui.getGuiTexture().getXYResizableIcon(30, 60, 15, 15, 5), gui.getGuiTexture().getXYResizableIcon(45, 60, 15, 15, 5), gui.getGuiTexture().getXYResizableIcon(30, 75, 15, 15, 5), gui.getGuiTexture().getXYResizableIcon(45, 75, 15, 15, 5)};
    }

    public UITabGroup(MalisisGui gui) {
        this(gui, ComponentPosition.TOP);
    }

    public ComponentPosition getTabPosition() {
        return this.tabPosition;
    }

    public GuiIcon getIcons() {
        if (this.attachedContainer instanceof UIWindow) {
            return this.windowIcons[this.tabPosition.ordinal()];
        }
        return this.panelIcons[this.tabPosition.ordinal()];
    }

    public UIContainer getAttachedContainer() {
        return this.attachedContainer;
    }

    public int getOffset() {
        return this.offset;
    }

    public UITabGroup setOffset(int offset) {
        this.offset = offset;
        return this;
    }

    public int getSpacing() {
        return this.spacing;
    }

    public UITabGroup setSpacing(int spacing) {
        this.spacing = spacing;
        return this;
    }

    public UITab addTab(UITab tab, UIContainer container) {
        if (tab.isActive()) {
            this.activeTab = tab;
        }
        this.add(tab);
        tab.setContainer(container);
        tab.setActive(false);
        this.listTabs.put(tab, container);
        this.calculateTabPosition();
        return tab;
    }

    protected void calculateTabPosition() {
        int w = 0;
        int h = 0;
        int s = 0;
        for (UITab tab : this.listTabs.keySet()) {
            int sa;
            int n = sa = tab.isActive() ? 2 : 0;
            if (this.tabPosition == ComponentPosition.TOP || this.tabPosition == ComponentPosition.BOTTOM) {
                tab.setPosition(w + this.offset + s, 1);
                w += tab.getWidth() + s;
                h = Math.max(h, tab.getHeight() - sa);
            } else {
                tab.setPosition(1, h + this.offset + s);
                w = Math.max(w, tab.getWidth() - sa);
                h += tab.getHeight() + s;
            }
            s = this.spacing;
        }
        boolean isHorizontal = this.tabPosition == ComponentPosition.TOP || this.tabPosition == ComponentPosition.BOTTOM;
        for (UITab tab : this.listTabs.keySet()) {
            tab.setSize(isHorizontal ? 0 : w, isHorizontal ? h : 0);
        }
        if (isHorizontal) {
            w += this.offset * 2;
        } else {
            h += this.offset * 2;
        }
        this.setSize(w + 2, h + 2);
    }

    public void setActiveTab(String tabName) {
        UIComponent comp = this.getComponent(tabName);
        if (comp instanceof UITab) {
            this.setActiveTab((UITab)comp);
        }
    }

    public void setActiveTab(UITab tab) {
        if (this.attachedContainer == null) {
            this.activeTab = tab;
            return;
        }
        if (this.activeTab == tab) {
            return;
        }
        if (this.activeTab != null) {
            this.activeTab.setActive(false);
        }
        this.activeTab = tab;
        if (tab != null) {
            tab.setActive(true);
        }
        if (this.attachedContainer instanceof ITransformable.Color) {
            ((ITransformable.Color)((Object)this.attachedContainer)).setColor(tab.getBgColor());
        }
    }

    public UITabGroup attachTo(UIContainer container, boolean displace) {
        this.attachedContainer = container;
        if (this.activeTab != null && this.attachedContainer instanceof ITransformable.Color) {
            ((ITransformable.Color)((Object)this.attachedContainer)).setColor(this.activeTab.getBgColor());
        }
        if (!displace) {
            if (this.activeTab != null) {
                UITab tab = this.activeTab;
                this.activeTab = null;
                this.setActiveTab(tab);
            }
            return this;
        }
        int cx = container.getX();
        int cy = container.getY();
        int cw = container.getRawWidth();
        int ch = container.getRawHeight();
        int av = Anchor.vertical(container.getAnchor());
        int ah = Anchor.horizontal(container.getAnchor());
        if (this.tabPosition == ComponentPosition.TOP) {
            if (av == Anchor.TOP || av == Anchor.NONE) {
                cy += this.getHeight() - 1;
            }
            ch = container.getRawHeight() - this.getHeight();
        } else if (this.tabPosition == ComponentPosition.BOTTOM) {
            if (av == Anchor.BOTTOM) {
                cy -= this.getHeight() - 1;
            }
            ch = container.getRawHeight() - this.getHeight() + 1;
        } else if (this.tabPosition == ComponentPosition.LEFT) {
            if (ah == Anchor.LEFT || ah == Anchor.NONE) {
                cx += this.getWidth() - 1;
            }
            cw = container.getRawWidth() - this.getWidth();
        } else if (this.tabPosition == ComponentPosition.RIGHT) {
            if (ah == Anchor.RIGHT) {
                cx -= this.getWidth() - 1;
            }
            cw = container.getRawWidth() - this.getWidth() + 1;
        }
        container.setSize(cw, ch);
        container.setPosition(cx, cy);
        if (this.activeTab != null) {
            UITab tab = this.activeTab;
            this.activeTab = null;
            this.setActiveTab(tab);
        }
        return this;
    }

    @Override
    public int screenX() {
        if (this.attachedContainer == null) {
            return super.screenX();
        }
        int x = this.x + this.attachedContainer.screenX();
        switch (this.tabPosition) {
            case LEFT: {
                x += this.offset - this.getWidth();
                break;
            }
            case RIGHT: {
                x += this.attachedContainer.getWidth() - this.offset;
                break;
            }
        }
        return x;
    }

    @Override
    public int screenY() {
        if (this.attachedContainer == null) {
            return super.screenY();
        }
        int y = this.y + this.attachedContainer.screenY();
        switch (this.tabPosition) {
            case TOP: {
                y += this.offset - this.getHeight();
                break;
            }
            case BOTTOM: {
                y += this.attachedContainer.getHeight() - this.offset;
                break;
            }
        }
        return y;
    }

    public static class TabChangeEvent
    extends ComponentEvent<UITabGroup> {
        private UITab newTab;

        public TabChangeEvent(UITabGroup component, UITab newTab) {
            super(component);
            this.newTab = newTab;
        }

        public UITab getOldTab() {
            return ((UITabGroup)this.component).activeTab;
        }

        public UITab getNewTab() {
            return this.newTab;
        }
    }
}

