/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.core.client.gui.component.container;

import java.util.Collection;
import net.malisis.core.client.gui.ClipArea;
import net.malisis.core.client.gui.GuiRenderer;
import net.malisis.core.client.gui.MalisisGui;
import net.malisis.core.client.gui.component.IClipable;
import net.malisis.core.client.gui.component.UIComponent;
import net.malisis.core.client.gui.component.control.IScrollable;
import net.malisis.core.client.gui.component.control.UIScrollBar;
import net.malisis.core.client.gui.event.ComponentEvent;
import net.malisis.core.client.gui.event.component.ContentUpdateEvent;
import net.minecraft.client.gui.GuiScreen;

public abstract class UIListContainer<T extends UIListContainer, S>
extends UIComponent<T>
implements IScrollable,
IClipable {
    protected int elementSpacing = 0;
    protected boolean unselect = true;
    protected Collection<S> elements;
    protected S selected;
    protected int lastSize = 0;
    protected UIScrollBar scrollbar;
    protected int yOffset;

    public UIListContainer(MalisisGui gui) {
        super(gui);
        this.scrollbar = new UIScrollBar(gui, this, UIScrollBar.Type.VERTICAL);
        this.scrollbar.setAutoHide(true);
    }

    public UIListContainer(MalisisGui gui, int width, int height) {
        this(gui);
        this.setSize(width, height);
    }

    public void setElements(Collection<S> elements) {
        this.elements = elements;
        this.fireEvent(new ContentUpdateEvent<UIListContainer>(this));
    }

    public Iterable<S> getElements() {
        return this.elements;
    }

    public void setElementSpacing(int elementSpacing) {
        this.elementSpacing = elementSpacing;
    }

    public boolean canUnselect() {
        return this.unselect;
    }

    public void setUnselect(boolean unselect) {
        this.unselect = unselect;
    }

    public void setSelected(S comp) {
        this.selected = comp;
    }

    public S getSelected() {
        return this.selected;
    }

    public boolean isSelected(S element) {
        return element == this.selected;
    }

    public S select(S element) {
        if (!this.fireEvent(new SelectEvent<S>(this, element))) {
            return this.getSelected();
        }
        this.setSelected(element);
        return element;
    }

    @Override
    public ClipArea getClipArea() {
        return new ClipArea(this);
    }

    @Override
    public void setClipContent(boolean clipContent) {
    }

    @Override
    public boolean shouldClipContent() {
        return true;
    }

    @Override
    public int getContentWidth() {
        return this.getWidth();
    }

    @Override
    public int getContentHeight() {
        if (this.elements == null || this.elements.size() == 0) {
            return 0;
        }
        int height = 0;
        for (S element : this.elements) {
            height += this.getElementHeight(element) + this.elementSpacing;
        }
        return height;
    }

    @Override
    public float getOffsetX() {
        return 0.0f;
    }

    @Override
    public void setOffsetX(float offsetX, int delta) {
    }

    @Override
    public float getOffsetY() {
        return (float)this.yOffset / (float)(this.getContentHeight() - this.getHeight());
    }

    @Override
    public void setOffsetY(float offsetY, int delta) {
        float newOffset = (float)(this.getContentHeight() - this.getHeight() + delta) * offsetY;
        this.yOffset = (int)((float)this.yOffset - newOffset > 0.0f ? Math.floor(newOffset) : Math.ceil(newOffset));
    }

    @Override
    public float getScrollStep() {
        return GuiScreen.isCtrlKeyDown() ? 0.125f : 0.025f;
    }

    @Override
    public int getHorizontalPadding() {
        return 0;
    }

    @Override
    public int getVerticalPadding() {
        return 0;
    }

    public S getElementAt(int x, int y) {
        if (!this.isHovered()) {
            return null;
        }
        int ey = 0;
        int cy = this.relativeY(y) + this.yOffset;
        for (S element : this.elements) {
            int h = this.getElementHeight(element) + this.elementSpacing;
            if (ey + h > cy) {
                return element;
            }
            ey += h;
        }
        return null;
    }

    @Override
    public boolean onClick(int x, int y) {
        S element = this.getElementAt(x, y);
        if (!this.canUnselect() && (element == null || this.isSelected(element))) {
            return super.onClick(x, y);
        }
        this.select(this.isSelected(element) ? null : (S)element);
        return true;
    }

    @Override
    public void draw(GuiRenderer renderer, int mouseX, int mouseY, float partialTick) {
        if (this.lastSize != this.elements.size()) {
            this.scrollbar.updateScrollbar();
            this.lastSize = this.elements.size();
        }
        super.draw(renderer, mouseX, mouseY, partialTick);
        this.getGui().addDebug("Pos", this.relativeX(mouseX), this.relativeY(mouseY));
    }

    @Override
    public void drawBackground(GuiRenderer renderer, int mouseX, int mouseY, float partialTick) {
    }

    @Override
    public void drawForeground(GuiRenderer renderer, int mouseX, int mouseY, float partialTick) {
        this.drawElements(renderer, mouseX, mouseY, partialTick);
    }

    public void drawElements(GuiRenderer renderer, int mouseX, int mouseY, float partialTick) {
        if (this.elements == null || this.elements.size() == 0) {
            this.drawEmtpy(renderer, mouseX, mouseY, partialTick);
            return;
        }
        S hoveredElement = this.getElementAt(mouseX, mouseY);
        int bk = this.y;
        this.y -= this.yOffset;
        for (S element : this.elements) {
            this.drawElementBackground(renderer, mouseX, mouseY, partialTick, element, hoveredElement == element);
            this.drawElementForeground(renderer, mouseX, mouseY, partialTick, element, hoveredElement == element);
            this.y += this.getElementHeight(element) + this.elementSpacing;
        }
        this.y = bk;
    }

    public void drawEmtpy(GuiRenderer renderer, int mouseX, int mouseY, float partialTick) {
        renderer.drawText("No element");
    }

    public abstract int getElementHeight(S var1);

    public abstract void drawElementBackground(GuiRenderer var1, int var2, int var3, float var4, S var5, boolean var6);

    public abstract void drawElementForeground(GuiRenderer var1, int var2, int var3, float var4, S var5, boolean var6);

    public static class SelectEvent<T>
    extends ComponentEvent.ValueChange<UIListContainer, T> {
        public SelectEvent(UIListContainer component, T selected) {
            super(component, component.getSelected(), selected);
        }

        public T getSelected() {
            return (T)this.newValue;
        }
    }
}

