/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.core.block.component;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import net.malisis.core.block.BoundingBoxType;
import net.malisis.core.block.IBlockComponent;
import net.malisis.core.block.ISmartCull;
import net.malisis.core.block.component.DirectionalComponent;
import net.minecraft.block.Block;
import net.minecraft.block.BlockStairs;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class StairComponent
implements IBlockComponent,
ISmartCull {
    public static PropertyBool TOP = PropertyBool.create((String)"top");

    public PropertyBool getProperty() {
        return TOP;
    }

    @Override
    public IBlockState setDefaultState(Block block, IBlockState state) {
        return state.withProperty((IProperty)this.getProperty(), (Comparable)Boolean.valueOf(false));
    }

    @Override
    public List<IBlockComponent> getDependencies() {
        return Lists.newArrayList((Object[])new IBlockComponent[]{new DirectionalComponent()});
    }

    @Override
    public IBlockState onBlockPlaced(Block block, World world, BlockPos pos, IBlockState state, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        boolean top = facing == EnumFacing.DOWN || facing != EnumFacing.UP && hitY > 0.5f;
        return state.withProperty((IProperty)this.getProperty(), (Comparable)Boolean.valueOf(top));
    }

    @Override
    public AxisAlignedBB[] getBoundingBoxes(Block block, IBlockAccess world, BlockPos pos, BoundingBoxType type) {
        IBlockState state = world != null ? world.getBlockState(pos) : block.getDefaultState();
        return this.getBounds((IBlockAccess)(state.getBlock() == block ? world : null), pos, state).toArray(new AxisAlignedBB[0]);
    }

    public List<AxisAlignedBB> getBounds(IBlockAccess world, BlockPos pos, IBlockState state) {
        ArrayList<AxisAlignedBB> list = new ArrayList<AxisAlignedBB>();
        list.add(this.getBaseBounds(world, pos, state));
        list.addAll(this.getStepBounds(world, pos, state));
        return list;
    }

    private AxisAlignedBB getBaseBounds(IBlockAccess world, BlockPos pos, IBlockState state) {
        AxisAlignedBB aabb = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.5, 1.0);
        return StairComponent.isTop(state) ? aabb.offset(0.0, 0.5, 0.0) : aabb;
    }

    private boolean hasSameStairs(IBlockState state1, IBlockState state2) {
        return StairComponent.isStairs(state2.getBlock()) && StairComponent.getStairDirection(state1) == StairComponent.getStairDirection(state2) && StairComponent.isTop(state1) == StairComponent.isTop(state2);
    }

    private boolean shouldConnect(IBlockState state1, IBlockState state2, boolean hasLeftStairs, boolean hasRightStairs) {
        if (!StairComponent.isStairs(state2.getBlock())) {
            return false;
        }
        if (hasLeftStairs && hasRightStairs) {
            return false;
        }
        EnumFacing dir1 = StairComponent.getStairDirection(state1);
        EnumFacing dir2 = StairComponent.getStairDirection(state2);
        if (dir1.getAxis() == dir2.getAxis() || StairComponent.isTop(state1) != StairComponent.isTop(state2)) {
            return false;
        }
        if (dir1 == dir2.rotateY() && hasRightStairs) {
            return false;
        }
        return dir1 != dir2.rotateYCCW() || !hasLeftStairs;
    }

    private List<AxisAlignedBB> getStepBounds(IBlockAccess world, BlockPos pos, IBlockState state) {
        if (world == null) {
            return Lists.newArrayList((Object[])new AxisAlignedBB[]{new AxisAlignedBB(0.5, 0.5, 0.0, 1.0, 1.0, 1.0)});
        }
        EnumFacing dir = StairComponent.getStairDirection(state);
        boolean isTop = StairComponent.isTop(state);
        AxisAlignedBB aabb = new AxisAlignedBB(0.0, 0.5, 0.0, 0.5, 1.0, 0.5);
        if (isTop) {
            aabb = aabb.offset(0.0, -0.5, 0.0);
        }
        boolean hasLeftStairs = this.hasSameStairs(state, world.getBlockState(pos.offset(dir.rotateY())));
        boolean hasRightStairs = this.hasSameStairs(state, world.getBlockState(pos.offset(dir.rotateYCCW())));
        IBlockState stateOther = world.getBlockState(pos.offset(dir.getOpposite()));
        EnumFacing dirOther = StairComponent.getStairDirection(stateOther);
        if (this.shouldConnect(state, stateOther, hasLeftStairs, hasRightStairs)) {
            if (dirOther == dir.rotateY()) {
                return Lists.newArrayList((Object[])new AxisAlignedBB[]{aabb.offset(0.5, 0.0, 0.0)});
            }
            return Lists.newArrayList((Object[])new AxisAlignedBB[]{aabb});
        }
        ArrayList list = Lists.newArrayList((Object[])new AxisAlignedBB[]{aabb.addCoord(0.5, 0.0, 0.0)});
        stateOther = world.getBlockState(pos.offset(dir));
        dirOther = StairComponent.getStairDirection(stateOther);
        if (this.shouldConnect(state, stateOther, hasRightStairs, hasLeftStairs)) {
            aabb = aabb.offset(0.0, 0.0, 0.5);
            if (dirOther == dir.rotateY()) {
                list.add(aabb.offset(0.5, 0.0, 0.0));
            } else {
                list.add(aabb);
            }
        }
        return list;
    }

    @Override
    public IBlockState getStateFromMeta(Block block, IBlockState state, int meta) {
        return state.withProperty((IProperty)this.getProperty(), (Comparable)Boolean.valueOf((meta & 8) != 0));
    }

    @Override
    public int getMetaFromState(Block block, IBlockState state) {
        return StairComponent.isTop(state) ? 8 : 0;
    }

    @Override
    public Boolean isOpaqueCube(Block block) {
        return false;
    }

    @Override
    public Boolean isFullCube(Block block) {
        return false;
    }

    public static boolean isStairs(Block block) {
        if (block instanceof BlockStairs) {
            return true;
        }
        return IBlockComponent.getComponent(StairComponent.class, block) != null;
    }

    public static boolean isTop(IBlockAccess world, BlockPos pos) {
        return world != null ? StairComponent.isTop(world.getBlockState(pos)) : false;
    }

    public static boolean isTop(IBlockState state) {
        StairComponent sc = IBlockComponent.getComponent(StairComponent.class, state.getBlock());
        if (sc == null) {
            return false;
        }
        PropertyBool property = sc.getProperty();
        if (property == null || !state.getProperties().containsKey((Object)property)) {
            return false;
        }
        return (Boolean)state.getValue((IProperty)property);
    }

    public static EnumFacing getStairDirection(IBlockState state) {
        if (!StairComponent.isStairs(state.getBlock())) {
            return null;
        }
        if (state.getBlock() instanceof BlockStairs) {
            return ((EnumFacing)state.getValue((IProperty)BlockStairs.FACING)).getOpposite();
        }
        return DirectionalComponent.getDirection(state);
    }
}

