/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.core.block;

import com.google.common.collect.Lists;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Random;
import net.malisis.core.MalisisCore;
import net.malisis.core.asm.AsmUtils;
import net.malisis.core.block.BoundingBoxType;
import net.malisis.core.block.IBlockComponent;
import net.malisis.core.block.IBoundingBox;
import net.malisis.core.block.IComponentProvider;
import net.malisis.core.block.IRegisterable;
import net.malisis.core.block.component.LadderComponent;
import net.malisis.core.item.MalisisItemBlock;
import net.malisis.core.renderer.DefaultRenderer;
import net.malisis.core.renderer.MalisisRendered;
import net.malisis.core.renderer.icon.IIconProvider;
import net.malisis.core.renderer.icon.IMetaIconProvider;
import net.malisis.core.renderer.icon.provider.DefaultIconProvider;
import net.minecraft.block.Block;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockState;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.BlockPos;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.util.Vec3;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@MalisisRendered(value=DefaultRenderer.Block.class)
public class MalisisBlock
extends Block
implements IBoundingBox,
IMetaIconProvider,
IRegisterable,
IComponentProvider {
    private static Field blockStateField = AsmUtils.changeFieldAccess(Block.class, "blockState", "field_176227_L");
    protected String name;
    protected AxisAlignedBB boundingBox;
    protected final List<IBlockComponent> components = Lists.newArrayList();
    @SideOnly(value=Side.CLIENT)
    protected IIconProvider iconProvider;

    protected MalisisBlock(Material material) {
        super(material);
    }

    protected List<IProperty> getProperties() {
        return Lists.newArrayList();
    }

    protected void buildBlockState() {
        List<IProperty> properties = this.getProperties();
        for (IBlockComponent component : this.getComponents()) {
            properties.addAll(Arrays.asList(component.getProperties()));
        }
        try {
            blockStateField.set(this, new BlockState((Block)this, properties.toArray(new IProperty[0])));
        }
        catch (ReflectiveOperationException e) {
            MalisisCore.log.error("[MalisisBlock] Failed to set the new BlockState for {}.", new Object[]{this.getClass().getSimpleName(), e});
        }
    }

    private void buildDefaultState() {
        IBlockState state = this.blockState.getBaseState();
        for (IBlockComponent component : this.getComponents()) {
            state = component.setDefaultState(this, state);
        }
        this.setDefaultState(state);
    }

    @Override
    public List<IBlockComponent> getComponents() {
        return this.components;
    }

    @Override
    public void addComponent(IBlockComponent component) {
        this.components.add(component);
        for (IBlockComponent dep : component.getDependencies()) {
            this.components.add(dep);
        }
        this.buildBlockState();
        this.buildDefaultState();
        this.lightOpacity = this.isOpaqueCube() ? 255 : 0;
    }

    @Override
    public <T> T getComponent(Class<T> type) {
        for (IBlockComponent component : this.components) {
            if (!type.isAssignableFrom(component.getClass())) continue;
            return (T)component;
        }
        return null;
    }

    public Block setName(String name) {
        this.name = name;
        super.setUnlocalizedName(name);
        return this;
    }

    public String getUnlocalizedName(IBlockState state) {
        for (IBlockComponent component : this.components) {
            String name = component.getUnlocalizedName(this, state);
            if (name == null) continue;
            return name;
        }
        return this.getUnlocalizedName();
    }

    @Override
    public Item getItem(Block block) {
        for (IBlockComponent component : this.components) {
            Item item = component.getItem(this);
            if (item != null && item.getClass() == MalisisItemBlock.class) continue;
            return item;
        }
        return IRegisterable.super.getItem(this);
    }

    @Override
    public String getRegistryName() {
        return this.name;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void createIconProvider(Object object) {
        if (object != null) {
            this.iconProvider = DefaultIconProvider.from(object);
        }
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public IIconProvider getIconProvider() {
        return this.iconProvider;
    }

    public IBlockState getStateFromItemStack(ItemStack itemStack) {
        return this.getStateFromMeta(itemStack.getItem().getMetadata(itemStack.getMetadata()));
    }

    public IBlockState onBlockPlaced(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer) {
        IBlockState state = super.onBlockPlaced(world, pos, facing, hitX, hitY, hitZ, meta, placer);
        for (IBlockComponent component : this.getComponents()) {
            state = component.onBlockPlaced(this, world, pos, state, facing, hitX, hitY, hitZ, meta, placer);
        }
        return state;
    }

    public void onBlockPlacedBy(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        for (IBlockComponent component : this.getComponents()) {
            component.onBlockPlacedBy(this, world, pos, state, placer, stack);
        }
    }

    public boolean onBlockActivated(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumFacing side, float hitX, float hitY, float hitZ) {
        boolean b = false;
        for (IBlockComponent component : this.getComponents()) {
            b |= component.onBlockActivated(this, world, pos, state, player, side, hitX, hitY, hitZ);
        }
        return b;
    }

    public void onNeighborBlockChange(World world, BlockPos pos, IBlockState state, Block neighborBlock) {
        for (IBlockComponent component : this.getComponents()) {
            component.onNeighborBlockChange(this, world, pos, state, neighborBlock);
        }
    }

    public void breakBlock(World world, BlockPos pos, IBlockState state) {
        for (IBlockComponent component : this.getComponents()) {
            component.breakBlock(this, world, pos, state);
        }
        super.breakBlock(world, pos, state);
    }

    @Override
    public AxisAlignedBB getBoundingBox(IBlockAccess world, BlockPos pos, BoundingBoxType type) {
        for (IBlockComponent component : this.getComponents()) {
            AxisAlignedBB aabb = component.getBoundingBox(this, world, pos, type);
            if (aabb == null) continue;
            return aabb;
        }
        return new AxisAlignedBB(this.minX, this.minY, this.minZ, this.maxX, this.maxY, this.maxZ);
    }

    @Override
    public AxisAlignedBB[] getBoundingBoxes(IBlockAccess world, BlockPos pos, BoundingBoxType type) {
        ArrayList list = Lists.newArrayList();
        for (IBlockComponent component : this.getComponents()) {
            AxisAlignedBB[] aabbs = component.getBoundingBoxes(this, world, pos, type);
            if (aabbs == null) continue;
            list.addAll(Arrays.asList(aabbs));
        }
        return list.size() != 0 ? list.toArray(new AxisAlignedBB[0]) : IBoundingBox.super.getBoundingBoxes(world, pos, type);
    }

    @Override
    public void addCollisionBoxesToList(World world, BlockPos pos, IBlockState state, AxisAlignedBB mask, List list, Entity collidingEntity) {
        IBoundingBox.super.addCollisionBoxesToList(world, pos, state, mask, list, collidingEntity);
    }

    @Override
    public AxisAlignedBB getSelectedBoundingBox(World world, BlockPos pos) {
        return IBoundingBox.super.getSelectedBoundingBox(world, pos);
    }

    @Override
    public MovingObjectPosition collisionRayTrace(World world, BlockPos pos, Vec3 src, Vec3 dest) {
        return IBoundingBox.super.collisionRayTrace(world, pos, src, dest);
    }

    public boolean canPlaceBlockOnSide(World world, BlockPos pos, EnumFacing side) {
        for (IBlockComponent component : this.getComponents()) {
            if (component.canPlaceBlockOnSide(this, world, pos, side)) continue;
            return false;
        }
        return super.canPlaceBlockOnSide(world, pos, side);
    }

    public boolean canPlaceBlockAt(World world, BlockPos pos) {
        for (IBlockComponent component : this.getComponents()) {
            if (component.canPlaceBlockAt(this, world, pos)) continue;
            return false;
        }
        return super.canPlaceBlockAt(world, pos);
    }

    public int damageDropped(IBlockState state) {
        for (IBlockComponent component : this.getComponents()) {
            int damage = component.damageDropped(this, state);
            if (damage == 0) continue;
            return damage;
        }
        return super.damageDropped(state);
    }

    public void getSubBlocks(Item item, CreativeTabs tab, List list) {
        ArrayList l = Lists.newArrayList();
        for (IBlockComponent component : this.getComponents()) {
            component.getSubBlocks(this, item, tab, l);
        }
        if (l.isEmpty()) {
            super.getSubBlocks(item, tab, list);
        } else {
            list.addAll(l);
        }
    }

    public int colorMultiplier(IBlockAccess world, BlockPos pos, int renderPass) {
        for (IBlockComponent component : this.components) {
            int color = component.colorMultiplier(this, world, pos, renderPass);
            if (color == 0xFFFFFF) continue;
            return color;
        }
        return super.colorMultiplier(world, pos, renderPass);
    }

    public MapColor getMapColor(IBlockState state) {
        for (IBlockComponent component : this.getComponents()) {
            MapColor color = component.getMapColor(this, state);
            if (color == null) continue;
            return color;
        }
        return super.getMapColor(state);
    }

    public int getRenderColor(IBlockState state) {
        for (IBlockComponent component : this.getComponents()) {
            int color = component.getRenderColor(this, state);
            if (color == 0xFFFFFF) continue;
            return color;
        }
        return super.getRenderColor(state);
    }

    public IBlockState getStateFromMeta(int meta) {
        IBlockState state = this.getDefaultState();
        for (IBlockComponent component : this.getComponents()) {
            state = component.getStateFromMeta(this, state, meta);
        }
        return state;
    }

    public int getMetaFromState(IBlockState state) {
        int meta = 0;
        for (IBlockComponent component : this.getComponents()) {
            meta += component.getMetaFromState(this, state);
        }
        return meta;
    }

    public boolean shouldSideBeRendered(IBlockAccess world, BlockPos pos, EnumFacing side) {
        for (IBlockComponent component : this.getComponents()) {
            Boolean render = component.shouldSideBeRendered(this, world, pos, side);
            if (render == null) continue;
            return render;
        }
        return super.shouldSideBeRendered(world, pos, side);
    }

    public boolean isFullBlock() {
        for (IBlockComponent component : this.getComponents()) {
            Boolean full = component.isFullCube(this);
            if (full == null) continue;
            return full;
        }
        return super.isFullCube();
    }

    public boolean isFullCube() {
        for (IBlockComponent component : this.getComponents()) {
            Boolean full = component.isFullCube(this);
            if (full == null) continue;
            return full;
        }
        return super.isFullCube();
    }

    public boolean isOpaqueCube() {
        if (this.getComponents() == null) {
            return super.isOpaqueCube();
        }
        for (IBlockComponent component : this.getComponents()) {
            Boolean opaque = component.isOpaqueCube(this);
            if (opaque == null) continue;
            return opaque;
        }
        return super.isOpaqueCube();
    }

    @SideOnly(value=Side.CLIENT)
    public int getMixedBrightnessForBlock(IBlockAccess world, BlockPos pos) {
        for (IBlockComponent component : this.getComponents()) {
            Integer light = component.getMixedBrightnessForBlock(this, world, pos);
            if (light == null) continue;
            return light;
        }
        return super.getMixedBrightnessForBlock(world, pos);
    }

    public Item getItemDropped(IBlockState state, Random rand, int fortune) {
        for (IBlockComponent component : this.getComponents()) {
            Item item = component.getItemDropped(this, state, rand, fortune);
            if (item == null) continue;
            return item;
        }
        return super.getItemDropped(state, rand, fortune);
    }

    public int quantityDropped(IBlockState state, int fortune, Random random) {
        for (IBlockComponent component : this.getComponents()) {
            Integer quantity = component.quantityDropped(this, state, fortune, random);
            if (quantity == null) continue;
            return quantity;
        }
        return super.quantityDropped(state, fortune, random);
    }

    public int getLightOpacity(IBlockAccess world, BlockPos pos) {
        for (IBlockComponent component : this.getComponents()) {
            Integer quantity = component.getLightOpacity(this, world, pos);
            if (quantity == null) continue;
            return quantity;
        }
        return super.getLightOpacity(world, pos);
    }

    public boolean isLadder(IBlockAccess world, BlockPos pos, EntityLivingBase entity) {
        return IBlockComponent.getComponent(LadderComponent.class, this) != null;
    }

    public int getRenderType() {
        return 4;
    }
}

