/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.core;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.malisis.core.MalisisCore;
import net.malisis.core.block.IRegisterable;
import net.malisis.core.renderer.DefaultRenderer;
import net.malisis.core.renderer.IBlockRenderer;
import net.malisis.core.renderer.IItemRenderer;
import net.malisis.core.renderer.IRenderWorldLast;
import net.malisis.core.renderer.MalisisRendered;
import net.malisis.core.renderer.MalisisRenderer;
import net.malisis.core.renderer.icon.IIconProvider;
import net.malisis.core.renderer.icon.IIconRegister;
import net.malisis.core.renderer.icon.IMetaIconProvider;
import net.malisis.core.renderer.icon.MalisisIcon;
import net.malisis.core.renderer.icon.provider.IBlockIconProvider;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.WorldRenderer;
import net.minecraft.client.renderer.block.statemap.IStateMapper;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.ModelResourceLocation;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.client.event.TextureStitchEvent;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.GameData;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;

public class MalisisRegistry {
    @SideOnly(value=Side.CLIENT)
    private static ClientRegistry instance;
    private static List<BlockRendererOverride> blockRendererOverrides;
    private static List<ItemRendererOverride> itemRendererOverrides;

    public static void register(IRegisterable registerable) {
        String name = registerable.getRegistryName();
        if (StringUtils.isEmpty((CharSequence)name)) {
            throw new IllegalArgumentException("No name specified for registration for " + registerable.getClass().getName());
        }
        if (!(registerable instanceof Block) && !(registerable instanceof Item)) {
            throw new IllegalArgumentException("Cannot register " + registerable.getClass().getName() + " (" + name + ") because it's neither a block or an item.");
        }
        if (registerable instanceof Block) {
            Block block = (Block)registerable;
            Item item = registerable.getItem(block);
            GameRegistry.registerBlock((Block)block, null, (String)name);
            if (item != null) {
                GameRegistry.registerItem((Item)item, (String)name);
                GameData.getBlockItemMap().put(block, item);
            }
            if (MalisisCore.isClient()) {
                ModelLoader.setCustomStateMapper((Block)block, (IStateMapper)ClientRegistry.emptyMapper);
                if (item != null) {
                    MalisisRegistry.registerItemModel(item, name);
                }
            }
        } else if (registerable instanceof Item) {
            Item item = (Item)registerable;
            GameRegistry.registerItem((Item)item, (String)name);
            if (MalisisCore.isClient()) {
                MalisisRegistry.registerItemModel(item, name);
            }
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static void registerBlockRenderer(Block block, IBlockRenderer renderer) {
        if (block == null || renderer == null) {
            return;
        }
        instance.blockRenderers.put(block, renderer);
        instance.itemRenderers.put(Item.getItemFromBlock((Block)block), renderer);
    }

    @SideOnly(value=Side.CLIENT)
    public static IBlockRenderer getBlockRenderer(Block block) {
        return (IBlockRenderer)instance.blockRenderers.get(block);
    }

    public static boolean shouldRenderBlock(IBlockAccess world, BlockPos pos, IBlockState state) {
        IBlockRenderer renderer = MalisisRegistry.getBlockRendererOverride(world, pos, state);
        if (renderer == null) {
            renderer = MalisisRegistry.getBlockRenderer(state.getBlock());
        }
        return renderer != null;
    }

    @SideOnly(value=Side.CLIENT)
    public static boolean renderBlock(WorldRenderer wr, IBlockAccess world, BlockPos pos, IBlockState state) {
        IBlockRenderer renderer = MalisisRegistry.getBlockRendererOverride(world, pos, state);
        if (renderer == null) {
            renderer = MalisisRegistry.getBlockRenderer(state.getBlock());
        }
        if (renderer == null) {
            return false;
        }
        return renderer.renderBlock(wr, world, pos, state);
    }

    @SideOnly(value=Side.CLIENT)
    public static TextureAtlasSprite getParticleIcon(IBlockState state) {
        Block block = state.getBlock();
        MalisisIcon icon = null;
        if (block instanceof IMetaIconProvider) {
            IIconProvider provider = ((IMetaIconProvider)block).getIconProvider();
            if (provider instanceof IBlockIconProvider) {
                icon = ((IBlockIconProvider)provider).getParticleIcon(state);
            } else if (provider != null) {
                icon = provider.getIcon();
            }
        }
        return icon != null ? icon : MalisisIcon.missing;
    }

    @SideOnly(value=Side.CLIENT)
    public static void registerItemRenderer(Item item, IItemRenderer renderer) {
        if (item == null || renderer == null) {
            return;
        }
        instance.itemRenderers.put(item, renderer);
    }

    @SideOnly(value=Side.CLIENT)
    public static IItemRenderer getItemRenderer(Item item) {
        return (IItemRenderer)instance.itemRenderers.get(item);
    }

    @SideOnly(value=Side.CLIENT)
    public static boolean renderItem(ItemStack itemStack) {
        if (itemStack == null) {
            return false;
        }
        IItemRenderer renderer = MalisisRegistry.getItemRendererOverride(itemStack);
        if (renderer == null) {
            renderer = MalisisRegistry.getItemRenderer(itemStack.getItem());
        }
        if (renderer == null) {
            return false;
        }
        renderer.renderItem(itemStack, MalisisRenderer.getPartialTick());
        return true;
    }

    @SideOnly(value=Side.CLIENT)
    public static void registerIconRegister(IIconRegister iconRegister) {
        if (iconRegister != null) {
            instance.iconRegisters.add(iconRegister);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static void registerRenderWorldLast(IRenderWorldLast renderer) {
        instance.renderWorldLastRenderers.add(renderer);
    }

    @SideOnly(value=Side.CLIENT)
    public static void unregisterRenderWorldLast(IRenderWorldLast renderer) {
        instance.renderWorldLastRenderers.remove(renderer);
    }

    @SideOnly(value=Side.CLIENT)
    public static void registerItemModel(Item item, String name) {
        MalisisRegistry.registerItemModel(item, Loader.instance().activeModContainer().getModId(), name);
    }

    @SideOnly(value=Side.CLIENT)
    public static void registerItemModel(Item item, String modid, String name) {
        IItemRenderer.DummyModel model = new IItemRenderer.DummyModel(item, modid + ":" + name);
        ModelLoader.setCustomModelResourceLocation((Item)item, (int)0, (ModelResourceLocation)model.getResourceLocation());
        instance.itemModels.add(model);
    }

    @SideOnly(value=Side.CLIENT)
    public static void registerBlockRendererOverride(BlockRendererOverride override) {
        if (override != null) {
            blockRendererOverrides.add(override);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static void registerItemRendererOverride(ItemRendererOverride override) {
        if (override != null) {
            itemRendererOverrides.add(override);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public static IBlockRenderer getBlockRendererOverride(IBlockAccess world, BlockPos pos, IBlockState state) {
        for (BlockRendererOverride overrides : blockRendererOverrides) {
            IBlockRenderer renderer = overrides.get(world, pos, state);
            if (renderer == null) continue;
            return renderer;
        }
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    public static IItemRenderer getItemRendererOverride(ItemStack itemStack) {
        for (ItemRendererOverride overrides : itemRendererOverrides) {
            IItemRenderer renderer = overrides.get(itemStack);
            if (renderer == null) continue;
            return renderer;
        }
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    public static void registerRenderers() {
        GameData.getBlockRegistry().forEach(x$0 -> MalisisRegistry.instance.registerRenderer(x$0));
        GameData.getItemRegistry().forEach(x$0 -> MalisisRegistry.instance.registerRenderer(x$0));
    }

    @SideOnly(value=Side.CLIENT)
    public static void registerIconRegisters() {
        GameData.getBlockRegistry().forEach(instance::registerIconRegister);
        GameData.getItemRegistry().forEach(instance::registerIconRegister);
    }

    @SideOnly(value=Side.CLIENT)
    public static void clearIconRegisters() {
        instance.iconRegisters.clear();
    }

    static {
        if (MalisisCore.isClient()) {
            instance = new ClientRegistry();
            MinecraftForge.EVENT_BUS.register((Object)instance);
        }
        blockRendererOverrides = Lists.newArrayList();
        itemRendererOverrides = Lists.newArrayList();
    }

    public static interface ItemRendererOverride {
        public IItemRenderer get(ItemStack var1);
    }

    public static interface BlockRendererOverride {
        public IBlockRenderer get(IBlockAccess var1, BlockPos var2, IBlockState var3);
    }

    @SideOnly(value=Side.CLIENT)
    private static class ClientRegistry {
        private Map<Block, IBlockRenderer> blockRenderers = new HashMap<Block, IBlockRenderer>();
        private Map<Item, IItemRenderer> itemRenderers = new HashMap<Item, IItemRenderer>();
        private List<IRenderWorldLast> renderWorldLastRenderers = new ArrayList<IRenderWorldLast>();
        private Set<IIconRegister> iconRegisters = new HashSet<IIconRegister>();
        private Set<IItemRenderer.DummyModel> itemModels = new HashSet<IItemRenderer.DummyModel>();
        private Map<Class<? extends MalisisRenderer>, MalisisRenderer> registeredRenderers = new HashMap<Class<? extends MalisisRenderer>, MalisisRenderer>();
        private static final IStateMapper emptyMapper = new IStateMapper(){

            public Map putStateModelLocations(Block block) {
                return ImmutableMap.of();
            }
        };

        private ClientRegistry() {
        }

        @SubscribeEvent
        public void onRenderLast(RenderWorldLastEvent event) {
            for (IRenderWorldLast renderer : this.renderWorldLastRenderers) {
                if (!renderer.shouldRender(event, (IBlockAccess)Minecraft.getMinecraft().theWorld)) continue;
                renderer.renderWorldLastEvent(event, (IBlockAccess)Minecraft.getMinecraft().theWorld);
            }
        }

        @SubscribeEvent
        public void onModelBakeEvent(ModelBakeEvent event) {
            DefaultRenderer.item.clearModels();
            for (IItemRenderer.DummyModel model : this.itemModels) {
                event.modelRegistry.putObject((Object)model.getResourceLocation(), (Object)model);
            }
        }

        @SideOnly(value=Side.CLIENT)
        @SubscribeEvent
        public void onTextureStitchEvent(TextureStitchEvent.Pre event) {
            for (IIconRegister iconRegister : this.iconRegisters) {
                iconRegister.registerIcons(event.map);
            }
        }

        public void registerIconRegister(Object object) {
            if (object instanceof IMetaIconProvider) {
                ((IMetaIconProvider)object).createIconProvider(null);
                MalisisRegistry.registerIconRegister(((IMetaIconProvider)object).getIconProvider());
            }
        }

        private void registerRenderer(Object object) {
            Pair<Class<? extends MalisisRenderer>, Class<? extends MalisisRenderer>> rendererClasses = this.getRendererClasses(object);
            if (rendererClasses == null) {
                return;
            }
            MalisisRenderer renderer = null;
            try {
                renderer = this.getRenderer((Class)rendererClasses.getLeft());
            }
            catch (IllegalAccessException | InstantiationException e) {
                MalisisCore.log.error("[MalisisRegistry] Failed to load {} renderer for {}", new Object[]{((Class)rendererClasses.getLeft()).getSimpleName(), object.getClass().getSimpleName(), e});
                return;
            }
            if (object instanceof Block && renderer != null) {
                MalisisRegistry.registerBlockRenderer((Block)object, renderer);
                object = Item.getItemFromBlock((Block)((Block)object));
            }
            try {
                renderer = this.getRenderer((Class)rendererClasses.getRight());
            }
            catch (IllegalAccessException | InstantiationException e) {
                MalisisCore.log.error("[MalisisRegistry] Failed to load {} renderer for {}", new Object[]{((Class)rendererClasses.getLeft()).getSimpleName(), object.getClass().getSimpleName()});
                return;
            }
            if (object instanceof Item && renderer != null) {
                MalisisRegistry.registerItemRenderer((Item)object, renderer);
            }
        }

        private Pair<Class<? extends MalisisRenderer>, Class<? extends MalisisRenderer>> getRendererClasses(Object object) {
            Class<?> objClass = object.getClass();
            MalisisRendered annotation = objClass.getAnnotation(MalisisRendered.class);
            if (annotation == null) {
                return null;
            }
            if (annotation.value() != DefaultRenderer.Null.class) {
                return Pair.of(annotation.value(), annotation.value());
            }
            return Pair.of(annotation.block(), annotation.item());
        }

        private MalisisRenderer getRenderer(Class<? extends MalisisRenderer> clazz) throws InstantiationException, IllegalAccessException {
            if (clazz == DefaultRenderer.Block.class) {
                return DefaultRenderer.block;
            }
            if (clazz == DefaultRenderer.Block.class) {
                return DefaultRenderer.item;
            }
            if (clazz == DefaultRenderer.Null.class) {
                return DefaultRenderer.nullRender;
            }
            MalisisRenderer renderer = this.registeredRenderers.get(clazz);
            if (renderer == null) {
                renderer = clazz.newInstance();
                this.registeredRenderers.put(clazz, renderer);
            }
            return renderer;
        }
    }
}

