/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.core.util.parser;

import java.util.Arrays;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import net.malisis.core.util.parser.token.Token;
import org.apache.commons.lang3.mutable.Mutable;

public abstract class Parser<T> {
    protected String text;
    protected Token<?> token = Token.None;
    protected boolean cached = false;
    protected int index = 0;
    protected String matched = "";
    protected Set<Token<?>> listTokens = new LinkedHashSet();
    protected Set<Token<?>> ignoreTokens = new HashSet();

    public Parser(String s) {
        this.text = s;
    }

    protected void withTokens(Token<?> ... tokens) {
        this.listTokens.addAll(Arrays.asList(tokens));
    }

    protected void ignoreTokens(Token<?> ... tokens) {
        this.withTokens(tokens);
        this.ignoreTokens.addAll(Arrays.asList(tokens));
    }

    private Token<?> getToken() {
        this.cached = true;
        if (this.isEnd()) {
            this.token = Token.EndOfInput;
            return this.token;
        }
        for (Token<?> t : this.listTokens) {
            if (!t.matches(this.text, this.index)) continue;
            if (this.ignoreTokens.contains(t)) {
                this.index += t.size();
                this.token = this.getToken();
                return this.token;
            }
            this.token = t;
            return this.token;
        }
        this.token = Token.None;
        return this.token;
    }

    public Token<?> peekToken() {
        if (!this.cached) {
            this.getToken();
        }
        return this.token;
    }

    public Token<?> readToken() {
        this.forward();
        this.peekToken();
        return this.token;
    }

    private void forward() {
        if (!this.cached) {
            this.peekToken();
        }
        this.cached = false;
        this.index += this.token.size();
    }

    public boolean isEnd() {
        return this.index >= this.text.length();
    }

    public char read() {
        return this.text.charAt(this.index++);
    }

    public char peek() {
        return this.text.charAt(this.index);
    }

    public <S> boolean match(Token<S> token) {
        return this.match(token, null);
    }

    public <S> boolean match(Token<S> t, Mutable<S> obj) {
        if (!this.listTokens.contains(t)) {
            throw new IllegalArgumentException("Tried to match Token " + t + " not present is parser list tokens");
        }
        if (obj != null) {
            obj.setValue(null);
        }
        this.peekToken();
        if (this.token != t) {
            return false;
        }
        if (obj != null) {
            obj.setValue(t.getValue());
        }
        this.matched = this.matched + this.token.getValue();
        this.forward();
        return true;
    }

    public String readUntil(Token<?> ... tokens) {
        int s = this.index;
        int e = this.index;
        while (!this.isEnd() && !this.peekToken().isOneOf(tokens)) {
            this.forward();
            e = this.index;
        }
        String txt = this.text.substring(s, e);
        return txt;
    }

    public abstract T parse();

    public void error(Token<?> expected) {
        throw new ParserException("Expecting '" + expected + "' at " + this.index + " but found " + this.token);
    }

    public static class ParserException
    extends RuntimeException {
        private static final long serialVersionUID = -3913680544137921678L;

        public ParserException(String message) {
            super(message);
        }
    }
}

