/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.core.renderer.icon;

import com.google.common.collect.Maps;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.malisis.core.registry.AutoLoad;
import net.malisis.core.registry.MalisisRegistry;
import net.malisis.core.renderer.icon.ProxyIcon;
import net.malisis.core.renderer.icon.VanillaIcon;
import net.malisis.core.util.callback.CallbackResult;
import net.malisis.core.util.callback.ICallback;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.item.Item;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@AutoLoad
@SideOnly(value=Side.CLIENT)
public class Icon
extends TextureAtlasSprite {
    protected static final Map<String, Icon> registeredIcons = Maps.newHashMap();
    protected static final Map<String, VanillaIcon> vanillaIcons = Maps.newHashMap();
    public static Icon missing;
    public static int BLOCK_TEXTURE_WIDTH;
    public static int BLOCK_TEXTURE_HEIGHT;
    protected int sheetWidth;
    protected int sheetHeight;
    protected boolean flippedU = false;
    protected boolean flippedV = false;
    protected int rotation = 0;
    protected Set<Icon> dependants = new HashSet<Icon>();

    public Icon(String name) {
        super(name);
        this.field_110980_m = 1.0f;
        this.field_110978_o = 1.0f;
    }

    public Icon() {
        this("");
    }

    public Icon(String name, float u, float v, float U, float V) {
        this(name);
        this.field_110979_l = u;
        this.field_110977_n = v;
        this.field_110980_m = U;
        this.field_110978_o = V;
    }

    public Icon(TextureAtlasSprite icon) {
        this(icon.func_94215_i());
        this.func_94217_a(icon);
    }

    public void setSize(int width, int height) {
        this.field_130223_c = width;
        this.field_130224_d = height;
    }

    public void setUVs(float u, float v, float U, float V) {
        this.field_110979_l = u;
        this.field_110977_n = v;
        this.field_110980_m = U;
        this.field_110978_o = V;
    }

    public float func_94209_e() {
        return this.flippedU ? this.field_110980_m : this.field_110979_l;
    }

    public float func_94212_f() {
        return this.flippedU ? this.field_110979_l : this.field_110980_m;
    }

    public float func_94206_g() {
        return this.flippedV ? this.field_110978_o : this.field_110977_n;
    }

    public float func_94210_h() {
        return this.flippedV ? this.field_110977_n : this.field_110978_o;
    }

    public Icon flip(boolean horizontal, boolean vertical) {
        this.flippedU = horizontal;
        this.flippedV = vertical;
        return this;
    }

    public boolean isFlippedU() {
        return this.flippedU;
    }

    public boolean isFlippedV() {
        return this.flippedV;
    }

    public boolean isRotated() {
        return this.rotation != 0;
    }

    public void setRotation(int rotation) {
        this.rotation = rotation;
    }

    public int getRotation() {
        return this.rotation;
    }

    protected void initIcon(Icon baseIcon, int width, int height, int x, int y, boolean rotated) {
        this.func_94217_a(baseIcon);
    }

    public Icon offset(int offsetX, int offsetY) {
        this.func_110971_a(this.sheetWidth, this.sheetHeight, this.func_130010_a() + offsetX, this.func_110967_i() + offsetY, this.isRotated());
        return this;
    }

    public Icon clip(int offsetX, int offsetY, int width, int height) {
        this.field_130223_c = width;
        this.field_130224_d = height;
        this.offset(offsetX, offsetY);
        return this;
    }

    public Icon clip(float offsetXFactor, float offsetYFactor, float widthFactor, float heightFactor) {
        int offsetX = Math.round((float)this.field_130223_c * offsetXFactor);
        int offsetY = Math.round((float)this.field_130224_d * offsetYFactor);
        this.field_130223_c = Math.round((float)this.field_130223_c * widthFactor);
        this.field_130224_d = Math.round((float)this.field_130224_d * heightFactor);
        this.offset(offsetX, offsetY);
        return this;
    }

    public void func_110971_a(int width, int height, int x, int y, boolean rotated) {
        if (width == 0 || height == 0) {
            width = BLOCK_TEXTURE_WIDTH;
            height = BLOCK_TEXTURE_HEIGHT;
        }
        this.sheetWidth = width;
        this.sheetHeight = height;
        super.func_110971_a(width, height, x, y, rotated);
        for (TextureAtlasSprite textureAtlasSprite : this.dependants) {
            if (textureAtlasSprite instanceof Icon) {
                ((Icon)textureAtlasSprite).initIcon(this, width, height, x, y, rotated);
                continue;
            }
            textureAtlasSprite.func_94217_a((TextureAtlasSprite)this);
        }
    }

    public void func_94217_a(TextureAtlasSprite base) {
        this.field_110975_c = base.func_130010_a();
        this.field_110974_d = base.func_110967_i();
        this.field_130223_c = base.func_94211_a();
        this.field_130224_d = base.func_94216_b();
        this.field_110979_l = base.func_94209_e();
        this.field_110980_m = base.func_94212_f();
        this.field_110977_n = base.func_94206_g();
        this.field_110978_o = base.func_94210_h();
        for (int i = 0; i < base.func_110970_k(); ++i) {
            this.field_110976_a.add(base.func_147965_a(i));
        }
        if (base instanceof Icon) {
            Icon mbase = (Icon)base;
            this.sheetWidth = mbase.sheetWidth;
            this.sheetHeight = mbase.sheetHeight;
            this.flippedU = mbase.flippedU;
            this.flippedV = mbase.flippedV;
        }
    }

    public Icon copy() {
        return new Icon(this);
    }

    public void register(TextureMap map) {
        map.setTextureEntry((TextureAtlasSprite)this);
    }

    public static CallbackResult<Void> registerIcons(TextureMap map) {
        registeredIcons.values().forEach(icon -> icon.register(map));
        return CallbackResult.noResult();
    }

    public static Icon from(String name) {
        if (registeredIcons.get(name) != null) {
            return registeredIcons.get(name);
        }
        Icon icon = null;
        icon = name.indexOf("minecraft:") == 0 ? new VanillaIcon(name) : new Icon(name);
        registeredIcons.put(name, icon);
        return icon;
    }

    public static Icon from(Block block) {
        return Icon.from(block.func_176223_P());
    }

    public static Icon from(IBlockState state) {
        String name = state.func_177230_c().getRegistryName().toString();
        if (vanillaIcons.get(name) != null) {
            return vanillaIcons.get(name);
        }
        VanillaIcon icon = new VanillaIcon(state);
        vanillaIcons.put(name, icon);
        return icon;
    }

    public static Icon from(Item item) {
        return Icon.from(item, 0);
    }

    public static Icon from(Item item, int metadata) {
        String name = item.getRegistryName().toString();
        if (vanillaIcons.get(name) != null) {
            return vanillaIcons.get(name);
        }
        VanillaIcon icon = new VanillaIcon(item, metadata);
        vanillaIcons.put(name, icon);
        return icon;
    }

    public static Icon getRegistered(String name) {
        return registeredIcons.get(name);
    }

    static {
        MalisisRegistry.onTextureStitched(Icon::registerIcons, ICallback.CallbackOption.of());
        missing = new ProxyIcon("MISSINGNO"){

            @Override
            public TextureAtlasSprite getIcon() {
                return Minecraft.func_71410_x().func_147117_R().func_174944_f();
            }

            @Override
            public String toString() {
                return "MISSINGNO";
            }
        };
        BLOCK_TEXTURE_WIDTH = -1;
        BLOCK_TEXTURE_HEIGHT = -1;
    }
}

