/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.core.renderer.font;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.malisis.core.renderer.font.Link;
import net.minecraft.util.text.TextFormatting;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.Pair;

public class FontOptions {
    private static Map<Character, TextFormatting> charFormats = new HashMap<Character, TextFormatting>();
    private static int[] colors = new int[32];
    private float fontScale = 1.0f;
    private int color = 0;
    private boolean shadow = false;
    private boolean bold;
    private boolean italic;
    private boolean underline;
    private boolean strikethrough;
    private boolean formattingDisabled = false;
    private boolean translate = true;
    private FontOptions defaultFro;
    private FontOptions lineOptions;
    private boolean defaultSaved = false;

    private FontOptions(float fontScale, int color, boolean shadow, boolean bold, boolean italic, boolean underline, boolean strikethrough, boolean translate) {
        this.fontScale = fontScale;
        this.color = color;
        this.shadow = shadow;
        this.italic = italic;
        this.underline = underline;
        this.strikethrough = strikethrough;
        this.translate = translate;
        this.defaultFro = new FontOptions();
        this.lineOptions = new FontOptions();
        this.saveDefault();
        this.lineOptions.from(this);
    }

    private FontOptions() {
    }

    public float getFontScale() {
        return this.fontScale;
    }

    public boolean isBold() {
        return this.bold;
    }

    public boolean isItalic() {
        return this.italic;
    }

    public boolean isUnderline() {
        return this.underline;
    }

    public boolean isStrikethrough() {
        return this.strikethrough;
    }

    public boolean hasShadow() {
        return this.shadow;
    }

    public int getColor() {
        return this.color;
    }

    public boolean isFormattingDisabled() {
        return this.formattingDisabled;
    }

    public boolean shouldTranslate() {
        return this.translate;
    }

    public int processStyles(String text) {
        return this.processStyles(text, 0);
    }

    public int processStyles(String text, int index) {
        TextFormatting ecf;
        if (!this.defaultSaved) {
            this.saveDefault();
        }
        if (this.formattingDisabled) {
            return 0;
        }
        int offset = 0;
        while ((ecf = FontOptions.getFormatting(text, index + offset)) != null) {
            offset += 2;
            this.apply(ecf);
        }
        return offset;
    }

    public void apply(TextFormatting ecf) {
        if (!this.defaultSaved) {
            this.saveDefault();
        }
        if (ecf == TextFormatting.RESET) {
            this.resetStyles();
        } else if (ecf.func_96302_c()) {
            this.color = colors[ecf.ordinal()];
        } else {
            switch (ecf) {
                case STRIKETHROUGH: {
                    this.strikethrough = true;
                    break;
                }
                case BOLD: {
                    this.bold = true;
                    break;
                }
                case ITALIC: {
                    this.italic = true;
                    break;
                }
                case UNDERLINE: {
                    this.underline = true;
                    break;
                }
            }
        }
    }

    public void saveDefault() {
        this.defaultSaved = true;
        this.defaultFro.color = this.color;
        this.defaultFro.strikethrough = this.strikethrough;
        this.defaultFro.bold = this.bold;
        this.defaultFro.italic = this.italic;
        this.defaultFro.underline = this.underline;
        this.defaultFro.fontScale = this.fontScale;
    }

    public void resetStyles() {
        if (!this.defaultSaved) {
            this.saveDefault();
            return;
        }
        this.from(this.defaultFro);
    }

    public void setLineOptions(FontOptions options) {
        this.lineOptions.from(options);
    }

    public void resetLineOptions() {
        this.from(this.lineOptions);
    }

    private void from(FontOptions options) {
        this.fontScale = options.fontScale;
        this.color = options.color;
        this.bold = options.bold;
        this.italic = options.italic;
        this.strikethrough = options.strikethrough;
        this.underline = options.underline;
    }

    public int getShadowColor() {
        if (this.color == 0) {
            return 0x222222;
        }
        if (this.color == 0xFFAA00) {
            return 0x2A2A00;
        }
        int r = this.color >> 16 & 0xFF;
        int g = this.color >> 8 & 0xFF;
        int b = this.color & 0xFF;
        return ((r /= 4) & 0xFF) << 16 | ((g /= 4) & 0xFF) << 8 | (b /= 4) & 0xFF;
    }

    public static TextFormatting getFormatting(String text, int index) {
        if (StringUtils.isEmpty((CharSequence)text) || index < 0 || index > text.length() - 2) {
            return null;
        }
        char c = text.charAt(index);
        if (c != '\u00a7') {
            return null;
        }
        return charFormats.get(Character.valueOf(text.charAt(index + 1)));
    }

    public static List<TextFormatting> getFormattings(String text, int index) {
        TextFormatting format;
        ArrayList list = Lists.newArrayList();
        int offset = 0;
        while ((format = FontOptions.getFormatting(text, index + offset)) != null) {
            offset += 2;
            list.add(format);
        }
        return list;
    }

    public static String formattingAsText(List<TextFormatting> list) {
        StringBuilder builder = new StringBuilder();
        list.forEach(f -> builder.append(f));
        return builder.toString();
    }

    public static boolean isFormatting(String text, int index) {
        return FontOptions.getFormatting(text, index) != null;
    }

    public static Pair<String, String> getStartFormat(String text) {
        int offset = 0;
        while (FontOptions.getFormatting(text, offset) != null) {
            offset += 2;
        }
        return Pair.of((Object)text.substring(0, offset), (Object)text.substring(offset, text.length()));
    }

    public static Link getLink(String text, int index) {
        if (StringUtils.isEmpty((CharSequence)text) || index < 0 || index > text.length() - 2) {
            return null;
        }
        if (text.charAt(index) != '[') {
            return null;
        }
        int i = text.indexOf(93);
        if (i < 2) {
            return null;
        }
        Link link = new Link(index, text.substring(index + 1, i));
        return link.isValid() ? link : null;
    }

    public FontOptions notTranslated() {
        return FontOptions.builder().scale(this.fontScale).color(this.color).shadow(this.shadow).bold(this.bold).italic(this.italic).underline(this.underline).strikethrough(this.strikethrough).disableTranslation().build();
    }

    public static FontOptionsBuilder builder() {
        return new FontOptionsBuilder();
    }

    static {
        for (TextFormatting ecf : TextFormatting.values()) {
            charFormats.put(Character.valueOf(ecf.toString().charAt(1)), ecf);
        }
        for (int i = 0; i < 16; ++i) {
            int j = (i >> 3 & 1) * 85;
            int r = (i >> 2 & 1) * 170 + j;
            int g = (i >> 1 & 1) * 170 + j;
            int b = (i >> 0 & 1) * 170 + j;
            if (i == 6) {
                r += 85;
            }
            FontOptions.colors[i] = (r & 0xFF) << 16 | (g & 0xFF) << 8 | b & 0xFF;
        }
    }

    public static class FontOptionsBuilder {
        private float fontScale = 1.0f;
        private int color = 0;
        private boolean shadow = false;
        private boolean bold = false;
        private boolean italic = false;
        private boolean underline = false;
        private boolean strikethrough = false;
        private boolean translate = true;

        public FontOptionsBuilder scale(float scale) {
            this.fontScale = scale;
            return this;
        }

        public FontOptionsBuilder color(int color) {
            this.color = color;
            return this;
        }

        public FontOptionsBuilder bold() {
            return this.bold(true);
        }

        public FontOptionsBuilder bold(boolean bold) {
            this.bold = bold;
            return this;
        }

        public FontOptionsBuilder italic() {
            return this.italic(true);
        }

        public FontOptionsBuilder italic(boolean italic) {
            this.italic = italic;
            return this;
        }

        public FontOptionsBuilder underline() {
            return this.underline(true);
        }

        public FontOptionsBuilder underline(boolean underline) {
            this.underline = underline;
            return this;
        }

        public FontOptionsBuilder strikethrough() {
            return this.strikethrough(true);
        }

        public FontOptionsBuilder strikethrough(boolean strikethrough) {
            this.strikethrough = strikethrough;
            return this;
        }

        public FontOptionsBuilder shadow() {
            return this.shadow(true);
        }

        public FontOptionsBuilder shadow(boolean shadow) {
            this.shadow = shadow;
            return this;
        }

        public FontOptionsBuilder disableTranslation() {
            this.translate = false;
            return this;
        }

        public FontOptionsBuilder styles(String styles) {
            for (TextFormatting format : FontOptions.getFormattings(styles, 0)) {
                this.styles(format);
            }
            return this;
        }

        public FontOptionsBuilder styles(TextFormatting ... formats) {
            block6: for (TextFormatting f : formats) {
                if (f.func_96302_c()) {
                    this.color(colors[f.ordinal()]);
                    continue;
                }
                switch (f) {
                    case BOLD: {
                        this.bold();
                        continue block6;
                    }
                    case UNDERLINE: {
                        this.underline();
                        continue block6;
                    }
                    case ITALIC: {
                        this.italic();
                        continue block6;
                    }
                    case STRIKETHROUGH: {
                        this.strikethrough();
                        continue block6;
                    }
                }
            }
            return this;
        }

        public FontOptions build() {
            return new FontOptions(this.fontScale, this.color, this.shadow, this.bold, this.italic, this.underline, this.strikethrough, this.translate);
        }
    }
}

