/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.core.renderer;

import com.google.common.collect.Sets;
import java.util.Arrays;
import java.util.Set;
import javax.vecmath.Matrix4f;
import net.malisis.core.MalisisCore;
import net.malisis.core.asm.AsmUtils;
import net.malisis.core.block.BoundingBoxType;
import net.malisis.core.block.IBoundingBox;
import net.malisis.core.block.IComponent;
import net.malisis.core.block.ISmartCull;
import net.malisis.core.registry.MalisisRegistry;
import net.malisis.core.renderer.IBlockRenderer;
import net.malisis.core.renderer.IRenderWorldLast;
import net.malisis.core.renderer.RenderParameters;
import net.malisis.core.renderer.RenderType;
import net.malisis.core.renderer.element.Face;
import net.malisis.core.renderer.element.Shape;
import net.malisis.core.renderer.element.Vertex;
import net.malisis.core.renderer.element.shape.Cube;
import net.malisis.core.renderer.font.FontOptions;
import net.malisis.core.renderer.font.MalisisFont;
import net.malisis.core.renderer.icon.Icon;
import net.malisis.core.renderer.icon.provider.IBlockIconProvider;
import net.malisis.core.renderer.icon.provider.IIconProvider;
import net.malisis.core.renderer.icon.provider.IItemIconProvider;
import net.malisis.core.renderer.model.MalisisModel;
import net.malisis.core.util.AABBUtils;
import net.malisis.core.util.BlockPosUtils;
import net.malisis.core.util.EnumFacingUtils;
import net.malisis.core.util.ItemUtils;
import net.malisis.core.util.Silenced;
import net.malisis.core.util.Utils;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.DestroyBlockProgress;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderGlobal;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.VertexBuffer;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.client.renderer.tileentity.TileEntityRendererDispatcher;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.client.renderer.vertex.VertexFormatElement;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.client.MinecraftForgeClient;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import org.lwjgl.opengl.GL11;

public class MalisisRenderer<T extends TileEntity>
extends TileEntitySpecialRenderer<T>
implements IBlockRenderer,
IRenderWorldLast {
    protected static final VertexBuffer batchedBuffer = ((Tessellator)Silenced.get(() -> AsmUtils.changeFieldAccess(TileEntityRendererDispatcher.class, "batchBuffer").get(TileEntityRendererDispatcher.field_147556_a))).func_178180_c();
    public static VertexFormat malisisVertexFormat = new VertexFormat(){
        {
            this.func_181721_a(new VertexFormatElement(0, VertexFormatElement.EnumType.FLOAT, VertexFormatElement.EnumUsage.POSITION, 3));
            this.func_181721_a(new VertexFormatElement(0, VertexFormatElement.EnumType.UBYTE, VertexFormatElement.EnumUsage.COLOR, 4));
            this.func_181721_a(new VertexFormatElement(0, VertexFormatElement.EnumType.FLOAT, VertexFormatElement.EnumUsage.UV, 2));
            this.func_181721_a(new VertexFormatElement(1, VertexFormatElement.EnumType.SHORT, VertexFormatElement.EnumUsage.UV, 2));
            this.func_181721_a(new VertexFormatElement(0, VertexFormatElement.EnumType.BYTE, VertexFormatElement.EnumUsage.NORMAL, 3));
            this.func_181721_a(new VertexFormatElement(0, VertexFormatElement.EnumType.BYTE, VertexFormatElement.EnumUsage.PADDING, 1));
        }
    };
    private boolean initialized = false;
    protected VertexBuffer buffer = null;
    protected VertexFormat vertexFormat = malisisVertexFormat;
    protected IBlockAccess world;
    protected BlockPos pos;
    protected Block block;
    protected IBlockState blockState;
    protected T tileEntity;
    protected float partialTick = 0.0f;
    protected ItemStack itemStack;
    protected Item item;
    protected ItemCameraTransforms.TransformType tranformType;
    protected RenderGlobal renderGlobal;
    protected RenderType renderType;
    protected int drawMode = 7;
    protected int baseBrightness;
    private boolean isBatched = false;
    protected Vec3d posOffset = null;
    private Set<Class<?>> ensureBlocks = Sets.newHashSet();
    protected boolean getBlockDamage = false;
    protected DestroyBlockProgress destroyBlockProgress = null;
    protected boolean vertexDrawn = false;

    public RenderType getRenderType() {
        return this.renderType;
    }

    public IBlockAccess getWorldAccess() {
        return this.world;
    }

    public BlockPos getPos() {
        return this.pos;
    }

    public IBlockState getBlockState() {
        return this.blockState;
    }

    public ItemStack getItemStack() {
        return this.itemStack;
    }

    public T getTileEntity() {
        return this.tileEntity;
    }

    public void reset() {
        this.buffer = null;
        this.renderType = RenderType.UNSET;
        this.drawMode = 0;
        this.world = null;
        this.pos = null;
        this.block = null;
        this.blockState = null;
        this.tileEntity = null;
        this.item = null;
        this.itemStack = null;
        this.destroyBlockProgress = null;
        this.tranformType = null;
        this.posOffset = null;
    }

    public void set(IBlockAccess world, Block block, BlockPos pos, IBlockState blockState) {
        this.world = world;
        this.pos = new BlockPos((Vec3i)pos);
        this.block = block;
        this.blockState = blockState;
        this.tileEntity = world.func_175625_s(pos);
    }

    public void set(IBlockAccess world, BlockPos pos) {
        this.world = world;
        this.pos = pos;
        this.set(world.func_180495_p(pos));
    }

    public void set(IBlockAccess world) {
        this.world = world;
    }

    public void set(Block block) {
        this.block = block;
        this.blockState = block.func_176223_P();
    }

    public void set(IBlockState blockState) {
        this.block = blockState.func_177230_c();
        this.blockState = blockState;
    }

    public void set(BlockPos pos) {
        this.pos = new BlockPos((Vec3i)pos);
    }

    public void set(T te, float partialTick) {
        this.set((IBlockAccess)te.func_145831_w(), te.func_145838_q(), te.func_174877_v(), te.func_145831_w().func_180495_p(te.func_174877_v()));
        this.partialTick = partialTick;
        this.tileEntity = te;
    }

    public void set(ItemStack itemStack) {
        this.itemStack = itemStack;
        this.item = itemStack.func_77973_b();
        IBlockState state = ItemUtils.getStateFromItemStack(itemStack);
        if (state != null) {
            this.set(state);
        }
    }

    protected void ensureBlock(Class<?> ... blockClasses) {
        this.ensureBlocks.clear();
        this.ensureBlocks.addAll(Arrays.asList(blockClasses));
    }

    private boolean checkBlock() {
        if (this.block == Blocks.field_150350_a || this.ensureBlocks.size() == 0) {
            return true;
        }
        return this.ensureBlocks.contains(this.block.getClass());
    }

    protected void setBatched() {
        if (!FMLClientHandler.instance().hasOptifine()) {
            this.isBatched = true;
        }
    }

    protected boolean isBatched() {
        return this.isBatched;
    }

    @Override
    public synchronized boolean renderBlock(VertexBuffer wr, IBlockAccess world, BlockPos pos, IBlockState state) {
        this.buffer = wr;
        this.set(world, state.func_177230_c(), pos, state);
        this.prepare(RenderType.BLOCK, new double[0]);
        if (this.checkBlock()) {
            this.render();
        }
        this.clean();
        return this.vertexDrawn;
    }

    @Override
    public synchronized boolean renderItem(ItemStack itemStack, float partialTick) {
        ItemStack stackInv;
        if ((this.tranformType == ItemCameraTransforms.TransformType.FIRST_PERSON_RIGHT_HAND || this.tranformType == ItemCameraTransforms.TransformType.FIRST_PERSON_LEFT_HAND) && itemStack != (stackInv = Utils.getClientPlayer().func_184586_b(this.tranformType == ItemCameraTransforms.TransformType.FIRST_PERSON_RIGHT_HAND ? EnumHand.MAIN_HAND : EnumHand.OFF_HAND)) && stackInv != null && stackInv.func_77973_b() == itemStack.func_77973_b()) {
            itemStack = stackInv;
        }
        this.buffer = Tessellator.func_178181_a().func_178180_c();
        this.set(itemStack);
        this.prepare(RenderType.ITEM, new double[0]);
        if (this.checkBlock()) {
            this.render();
        }
        this.clean();
        return true;
    }

    @Override
    public void setTransformType(ItemCameraTransforms.TransformType transformType) {
        this.tranformType = transformType;
    }

    @Override
    public boolean isGui3d() {
        return true;
    }

    @Override
    public Matrix4f getTransform(Item item, ItemCameraTransforms.TransformType tranformType) {
        this.tranformType = tranformType;
        return null;
    }

    public synchronized void func_180535_a(T te, double x, double y, double z, float partialTick, int destroyStage) {
        if (te.func_145831_w().func_180495_p(te.func_174877_v()).func_177230_c() == Blocks.field_150350_a) {
            return;
        }
        this.buffer = this.isBatched() ? batchedBuffer : Tessellator.func_178181_a().func_178180_c();
        this.set(te, partialTick);
        this.prepare(RenderType.TILE_ENTITY, x, y, z);
        if (this.checkBlock()) {
            this.render();
        }
        this.clean();
    }

    @Override
    public boolean shouldSetViewportPosition() {
        return true;
    }

    @Override
    public boolean shouldRender(RenderWorldLastEvent event, IBlockAccess world) {
        return true;
    }

    @Override
    public void renderWorldLastEvent(RenderWorldLastEvent event, IBlockAccess world) {
        this.set(world);
        this.buffer = Tessellator.func_178181_a().func_178180_c();
        this.partialTick = event.getPartialTicks();
        this.renderGlobal = event.getContext();
        double x = 0.0;
        double y = 0.0;
        double z = 0.0;
        if (this.shouldSetViewportPosition()) {
            EntityPlayer p = Utils.getClientPlayer();
            x = -(p.field_70142_S + (p.field_70165_t - p.field_70142_S) * (double)this.partialTick);
            y = -(p.field_70137_T + (p.field_70163_u - p.field_70137_T) * (double)this.partialTick);
            z = -(p.field_70136_U + (p.field_70161_v - p.field_70136_U) * (double)this.partialTick);
        }
        this.prepare(RenderType.WORLD_LAST, x, y, z);
        this.render();
        this.clean();
    }

    public void prepare(RenderType renderType, double ... data) {
        this._initialize();
        this.vertexDrawn = false;
        this.renderType = renderType;
        if (renderType == RenderType.BLOCK) {
            this.vertexFormat = DefaultVertexFormats.field_176600_a;
            BlockPos chunkPos = BlockPosUtils.chunkPosition(this.pos);
            this.posOffset = new Vec3d((double)chunkPos.func_177958_n(), (double)chunkPos.func_177956_o(), (double)chunkPos.func_177952_p());
        } else if (renderType == RenderType.ITEM) {
            this.startDrawing(malisisVertexFormat);
        } else if (renderType == RenderType.TILE_ENTITY) {
            if (this.isBatched()) {
                this.posOffset = new Vec3d(data[0], data[1], data[2]);
                this.vertexFormat = FMLClientHandler.instance().hasOptifine() ? DefaultVertexFormats.field_176600_a : malisisVertexFormat;
            } else {
                GL11.glPushAttrib((int)1048575);
                GlStateManager.func_179094_E();
                GlStateManager.func_179140_f();
                GlStateManager.func_179137_b((double)data[0], (double)data[1], (double)data[2]);
                this.func_147499_a(TextureMap.field_110575_b);
                this.startDrawing(FMLClientHandler.instance().hasOptifine() ? DefaultVertexFormats.field_176600_a : malisisVertexFormat);
                this.enableBlending();
            }
        } else if (renderType == RenderType.WORLD_LAST) {
            GL11.glPushAttrib((int)1048575);
            GlStateManager.func_179094_E();
            Minecraft.func_71410_x().field_71460_t.func_180436_i();
            GlStateManager.func_179137_b((double)data[0], (double)data[1], (double)data[2]);
            this.func_147499_a(TextureMap.field_110575_b);
            this.startDrawing(malisisVertexFormat);
            this.enableBlending();
        } else {
            throw new IllegalArgumentException("Unknow renderType to handle for " + this.getClass().getSimpleName() + " : " + (Object)((Object)renderType));
        }
    }

    public void clean() {
        if (this.renderType == RenderType.ITEM) {
            this.draw();
        } else if (this.renderType == RenderType.TILE_ENTITY) {
            if (this.isBatched()) {
                this.buffer.func_178969_c(0.0, 0.0, 0.0);
            } else {
                this.draw();
                this.disableBlending();
                GlStateManager.func_179145_e();
                GlStateManager.func_179121_F();
                GlStateManager.func_179099_b();
            }
        } else if (this.renderType == RenderType.WORLD_LAST) {
            this.draw();
            this.disableBlending();
            Minecraft.func_71410_x().field_71460_t.func_175072_h();
            GlStateManager.func_179121_F();
            GlStateManager.func_179099_b();
        }
        this.reset();
    }

    public void startDrawing() {
        this.startDrawing(7, this.vertexFormat);
    }

    public void startDrawing(int drawMode) {
        this.startDrawing(drawMode, this.vertexFormat);
    }

    public void startDrawing(VertexFormat vertexFormat) {
        this.startDrawing(7, vertexFormat);
    }

    public void startDrawing(int drawMode, VertexFormat vertexFormat) {
        if (!this.canDraw()) {
            return;
        }
        this.draw();
        this.buffer.func_181668_a(drawMode, vertexFormat);
        this.drawMode = drawMode;
        this.vertexFormat = vertexFormat;
    }

    public boolean isDrawing() {
        if (this.buffer == null) {
            throw new NullPointerException("[MalisisRenderer] WorldRenderer not set for " + (Object)((Object)this.renderType));
        }
        return this.buffer.field_179010_r;
    }

    public void next() {
        this.next(this.drawMode);
    }

    public void next(int drawMode) {
        this.next(drawMode, this.vertexFormat);
    }

    public void next(VertexFormat vertexFormat) {
        this.next(7, vertexFormat);
    }

    public void next(int drawMode, VertexFormat vertexFormat) {
        this.draw();
        this.startDrawing(drawMode, vertexFormat);
    }

    public void draw() {
        if (this.canDraw() && this.isDrawing()) {
            Tessellator.func_178181_a().func_78381_a();
        }
    }

    private boolean canDraw() {
        if (this.renderType == RenderType.BLOCK || this.renderType == RenderType.ANIMATED) {
            return false;
        }
        return this.renderType != RenderType.TILE_ENTITY || !this.isBatched();
    }

    public void enableBlending() {
        if (this.renderType == RenderType.BLOCK) {
            return;
        }
        GlStateManager.func_179147_l();
        GlStateManager.func_179120_a((int)770, (int)771, (int)1, (int)0);
        GlStateManager.func_179092_a((int)516, (float)0.0f);
        GlStateManager.func_179103_j((int)7425);
        GlStateManager.func_179142_g();
    }

    public void disableBlending() {
        if (this.renderType == RenderType.BLOCK) {
            return;
        }
        GlStateManager.func_179119_h();
        GlStateManager.func_179103_j((int)7424);
        GlStateManager.func_179084_k();
    }

    public void enableTextures() {
        GL11.glEnable((int)3553);
    }

    public void disableTextures() {
        GL11.glDisable((int)3553);
    }

    protected void func_147499_a(ResourceLocation resourceLocaltion) {
        Minecraft.func_71410_x().func_110434_K().func_110577_a(resourceLocaltion);
    }

    public void setBillboard(float x, float y, float z) {
        EntityPlayer player = Utils.getClientPlayer();
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)x, (float)y, (float)z);
        GlStateManager.func_179114_b((float)(180.0f - player.field_70177_z), (float)0.0f, (float)1.0f, (float)0.0f);
    }

    public void endBillboard() {
        GlStateManager.func_179121_F();
    }

    protected final void _initialize() {
        if (this.initialized) {
            return;
        }
        this.initialize();
        this.initialized = true;
    }

    protected void initialize() {
    }

    public void renderStandard() {
        Minecraft.func_71410_x().func_175602_ab().func_175018_a(this.blockState, this.pos, this.world, this.buffer);
    }

    public void render() {
        this.drawShape(new Cube());
    }

    protected void drawModel(MalisisModel model, RenderParameters params) {
        for (Shape s : model) {
            this.drawShape(s, params);
        }
    }

    public void drawShape(Shape shape) {
        this.drawShape(shape, null);
    }

    public void drawShape(Shape s, RenderParameters params) {
        if (s == null) {
            return;
        }
        s.applyMatrix();
        for (Face f : s.getFaces()) {
            this.drawFace(f, params);
        }
    }

    protected void drawFace(Face face) {
        this.drawFace(face, null);
    }

    protected void drawFace(Face face, RenderParameters params) {
        if (face == null) {
            return;
        }
        int vertexCount = face.getVertexes().length;
        if (vertexCount != 4 && this.renderType == RenderType.BLOCK) {
            MalisisCore.log.error("[MalisisRenderer] Attempting to render a face containing {} vertexes in BLOCK for {}. Ignored", new Object[]{vertexCount, this.block});
            return;
        }
        if (params == null) {
            params = face.getParameters();
        }
        if (params.deductParameters.get().booleanValue()) {
            face.deductParameters();
        }
        if (!this.shouldRenderFace(face, params = RenderParameters.merge(params, face.getParameters()))) {
            return;
        }
        if (params.applyTexture.get().booleanValue()) {
            this.applyTexture(face, params);
        }
        this.baseBrightness = this.getBaseBrightness(params);
        for (int i = 0; i < face.getVertexes().length; ++i) {
            this.drawVertex(face.getVertexes()[i], i, params);
        }
        if (this.drawMode == 9 || this.drawMode == 6913 || this.drawMode == 3 || this.drawMode == 2) {
            this.next();
        }
    }

    protected void drawVertex(Vertex vertex, int number, RenderParameters params) {
        if (vertex == null) {
            vertex = new Vertex(0.0, 0.0, 0.0);
        }
        int brightness = this.calcVertexBrightness(vertex, number, params);
        vertex.setBrightness(brightness);
        int color = this.calcVertexColor(vertex, number, params);
        vertex.setColor(color);
        if (params != null && !params.usePerVertexAlpha.get().booleanValue()) {
            vertex.setAlpha(params.alpha.get());
        }
        if (params != null && this.renderType == RenderType.ITEM) {
            vertex.setNormal(params.direction.get());
        }
        this.buffer.func_178981_a(vertex.getVertexData(this.vertexFormat, this.posOffset));
        this.vertexDrawn = true;
    }

    public void drawText(MalisisFont font, String text, float x, float y, float z, FontOptions options) {
        if (font == null) {
            font = MalisisFont.minecraftFont;
        }
        if (options == null) {
            options = FontOptions.builder().build();
        }
        font.render(this, text, x, y, z, options);
    }

    protected boolean shouldRenderFace(Face face, RenderParameters params) {
        if (this.renderType != RenderType.BLOCK || this.world == null || this.block == null) {
            return true;
        }
        if (params != null && params.renderAllFaces.get().booleanValue()) {
            return true;
        }
        RenderParameters p = face.getParameters();
        if (p.direction.get() == null || p.renderAllFaces.get().booleanValue()) {
            return true;
        }
        if (ISmartCull.shouldSmartCull(this.block)) {
            return this.smartCull(face, params);
        }
        boolean b = this.blockState.func_185894_c(this.world, this.pos, p.direction.get());
        return b;
    }

    protected boolean smartCull(Face face, RenderParameters params) {
        EnumFacing side = params.direction.get();
        AxisAlignedBB bounds = this.getRenderBounds(params);
        if (side == EnumFacing.DOWN && bounds.field_72338_b > 0.0) {
            return true;
        }
        if (side == EnumFacing.UP && bounds.field_72337_e < 1.0) {
            return true;
        }
        if (side == EnumFacing.NORTH && bounds.field_72339_c > 0.0) {
            return true;
        }
        if (side == EnumFacing.SOUTH && bounds.field_72334_f < 1.0) {
            return true;
        }
        if (side == EnumFacing.WEST && bounds.field_72340_a > 0.0) {
            return true;
        }
        if (side == EnumFacing.EAST && bounds.field_72336_d < 1.0) {
            return true;
        }
        return !this.world.func_180495_p(this.pos.func_177972_a(side)).func_185914_p();
    }

    public void applyTexture(Shape shape) {
        this.applyTexture(shape, null);
    }

    public void applyTexture(Shape shape, RenderParameters params) {
        for (Face f : shape.getFaces()) {
            RenderParameters rp = RenderParameters.merge(params, f.getParameters());
            this.applyTexture(f, rp);
        }
    }

    public void applyTexture(Face face, RenderParameters params) {
        Icon icon = this.getIcon(face, params);
        if (icon == null) {
            icon = Icon.missing;
        }
        if (this.shouldRotateIcon(params)) {
            if (params.textureSide.get() != null && params.textureSide.get().func_176740_k() == EnumFacing.Axis.Y) {
                icon.setRotation(EnumFacingUtils.getRotationCount(this.blockState));
            } else {
                icon.setRotation(0);
            }
        }
        boolean flipU = params.flipU.get();
        if (!(params.deductParameters.get().booleanValue() || params.direction.get() != EnumFacing.NORTH && params.direction.get() != EnumFacing.EAST)) {
            flipU = !flipU;
        }
        face.setTexture(icon, flipU, params.flipV.get(), params.interpolateUV.get());
    }

    protected Icon getIcon(Face face, RenderParameters params) {
        if (params != null && params.icon.get() != null) {
            return params.icon.get();
        }
        IIconProvider iconProvider = this.getIconProvider(params);
        if (iconProvider instanceof IItemIconProvider && this.itemStack != null) {
            return ((IItemIconProvider)iconProvider).getIcon(this.itemStack);
        }
        if (iconProvider instanceof IBlockIconProvider && this.block != null) {
            EnumFacing side;
            EnumFacing enumFacing = side = params != null ? params.textureSide.get() : EnumFacing.SOUTH;
            if (params != null && this.shouldRotateIcon(params)) {
                side = EnumFacingUtils.getRealSide(this.blockState, side);
            }
            IBlockIconProvider iblockp = (IBlockIconProvider)iconProvider;
            if (this.renderType == RenderType.BLOCK || this.renderType == RenderType.TILE_ENTITY) {
                return iblockp.getIcon(this.world, this.pos, this.blockState, side);
            }
            if (this.renderType == RenderType.ITEM) {
                return iblockp.getIcon(this.itemStack, side);
            }
        }
        return iconProvider != null ? iconProvider.getIcon() : Icon.missing;
    }

    protected IIconProvider getIconProvider(RenderParameters params) {
        if (params != null && params.iconProvider.get() != null) {
            return params.iconProvider.get();
        }
        IIconProvider provider = IComponent.getComponent(IIconProvider.class, this.item);
        if (provider == null) {
            provider = IComponent.getComponent(IIconProvider.class, this.block);
        }
        return provider;
    }

    protected boolean shouldRotateIcon(RenderParameters params) {
        return this.blockState != null && params.rotateIcon.get() != false;
    }

    protected int calcVertexColor(Vertex vertex, int number, RenderParameters params) {
        int color = 0xFFFFFF;
        if (params == null) {
            return color;
        }
        if (params.usePerVertexColor.get().booleanValue()) {
            color = vertex.getColor();
        } else if (params.colorMultiplier.get() != null) {
            color = params.colorMultiplier.get();
        } else if (this.block != null) {
            color = Minecraft.func_71410_x().func_184125_al().func_186724_a(this.blockState, this.world, this.pos, 0);
        }
        if (this.drawMode == 1) {
            return color;
        }
        if (this.renderType != RenderType.BLOCK && this.renderType != RenderType.TILE_ENTITY) {
            return color;
        }
        int[][] aoMatrix = (int[][])params.aoMatrix.get(number);
        float factor = 1.0f;
        if (params.calculateAOColor.get().booleanValue() && aoMatrix != null && Minecraft.func_71379_u() && this.blockState.getLightValue(this.world, this.pos) == 0 && params.direction.get() != null) {
            factor = this.getBlockAmbientOcclusion(this.world, this.pos.func_177972_a(params.direction.get()));
            for (int i = 0; i < aoMatrix.length; ++i) {
                factor += this.getBlockAmbientOcclusion(this.world, this.pos.func_177982_a(aoMatrix[i][0], aoMatrix[i][1], aoMatrix[i][2]));
            }
            factor /= (float)(aoMatrix.length + 1);
        }
        int r = (int)((float)(color >> 16 & 0xFF) * (factor *= params.colorFactor.get().floatValue()));
        int g = (int)((float)(color >> 8 & 0xFF) * factor);
        int b = (int)((float)(color & 0xFF) * factor);
        color = r << 16 | g << 8 | b;
        return color;
    }

    protected int getBaseBrightness(RenderParameters params) {
        if (!params.useEnvironmentBrightness.get().booleanValue()) {
            return params.brightness.get();
        }
        if (this.block != null) {
            if (this.world != null && this.blockState.getLightValue(this.world, this.pos) != 0) {
                return this.blockState.getLightValue(this.world, this.pos) << 4;
            }
            if (this.blockState.func_185906_d() != 0) {
                return this.blockState.func_185906_d() << 4;
            }
        }
        if (this.renderType == RenderType.ITEM) {
            return Utils.getClientPlayer().func_70070_b(MalisisRenderer.getPartialTick());
        }
        if (this.world == null || this.block == null) {
            return params.brightness.get();
        }
        if (params.direction.get() == null && this.block != null) {
            return this.blockState.func_185889_a(this.world, this.pos);
        }
        AxisAlignedBB bounds = this.getRenderBounds(params);
        EnumFacing dir = params.direction.get();
        BlockPos p = this.pos;
        if (bounds != null) {
            if (dir == EnumFacing.WEST && bounds.field_72340_a <= 0.0) {
                p = p.func_177976_e();
            } else if (dir == EnumFacing.EAST && bounds.field_72336_d >= 1.0) {
                p = p.func_177974_f();
            } else if (dir == EnumFacing.NORTH && bounds.field_72339_c <= 0.0) {
                p = p.func_177978_c();
            } else if (dir == EnumFacing.SOUTH && bounds.field_72334_f >= 1.0) {
                p = p.func_177968_d();
            } else if (dir == EnumFacing.DOWN && bounds.field_72338_b <= 0.0) {
                p = p.func_177977_b();
            } else if (dir == EnumFacing.UP && bounds.field_72337_e >= 1.0) {
                p = p.func_177984_a();
            }
        }
        return this.getMixedBrightnessForBlock(this.world, p);
    }

    protected int calcVertexBrightness(Vertex vertex, int number, RenderParameters params) {
        if (params == null) {
            return this.baseBrightness;
        }
        if (params.usePerVertexBrightness.get().booleanValue()) {
            return vertex.getBrightness();
        }
        if (this.drawMode == 6913) {
            return this.baseBrightness;
        }
        if (this.renderType != RenderType.BLOCK && this.renderType != RenderType.TILE_ENTITY) {
            return this.baseBrightness;
        }
        int[][] aoMatrix = (int[][])params.aoMatrix.get(number);
        if (!params.calculateBrightness.get().booleanValue() || aoMatrix == null) {
            return this.baseBrightness;
        }
        if (!Minecraft.func_71379_u() || this.blockState.getLightValue(this.world, this.pos) != 0) {
            return this.baseBrightness;
        }
        int[] b = new int[Math.max(3, aoMatrix.length)];
        for (int i = 0; i < b.length; ++i) {
            int n = i;
            b[n] = b[n] + this.getMixedBrightnessForBlock(this.world, this.pos.func_177982_a(aoMatrix[i][0], aoMatrix[i][1], aoMatrix[i][2]));
        }
        int brightness = this.getAoBrightness(b[0], b[1], b[2], this.baseBrightness);
        return brightness;
    }

    protected int getAoBrightness(int b1, int b2, int b3, int base) {
        if (b1 == 0) {
            b1 = base;
        }
        if (b2 == 0) {
            b2 = base;
        }
        if (b3 == 0) {
            b3 = base;
        }
        return b1 + b2 + b3 + base >> 2 & 0xFF00FF;
    }

    protected float getBlockAmbientOcclusion(IBlockAccess world, BlockPos pos) {
        return world.func_180495_p(pos).func_185892_j();
    }

    protected int getMixedBrightnessForBlock(IBlockAccess world, BlockPos pos) {
        return world.func_180495_p(pos).func_185889_a(world, pos);
    }

    protected AxisAlignedBB getRenderBounds(RenderParameters params) {
        if (params != null && !params.useBlockBounds.get().booleanValue()) {
            return params.renderBounds.get();
        }
        if (this.block instanceof IBoundingBox) {
            return ((IBoundingBox)this.block).getBoundingBox(this.world, this.pos, this.blockState, BoundingBoxType.RENDER);
        }
        if (this.blockState != null && this.world != null) {
            return this.blockState.func_185900_c(this.world, this.pos);
        }
        return AABBUtils.identity();
    }

    public static float getPartialTick() {
        return Minecraft.func_71410_x().field_71428_T.field_74279_e;
    }

    public static BlockRenderLayer getRenderLayer() {
        return MinecraftForgeClient.getRenderLayer();
    }

    public void registerFor(Block block) {
        MalisisRegistry.registerBlockRenderer(block, this);
    }

    public void registerFor(Item item) {
        MalisisRegistry.registerItemRenderer(item, this);
    }

    public void registerFor(Class<? extends T> clazz) {
        ClientRegistry.bindTileEntitySpecialRenderer(clazz, (TileEntitySpecialRenderer)this);
    }

    public void registerForRenderWorldLast() {
        MalisisRegistry.registerRenderWorldLast(this);
    }

    public static int colorMultiplier(IBlockAccess world, BlockPos pos, IBlockState state) {
        return Minecraft.func_71410_x().func_184125_al().func_186724_a(state, world, pos, 0);
    }
}

