/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.core.inventory;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.malisis.core.MalisisCore;
import net.malisis.core.inventory.IInventoryProvider;
import net.malisis.core.inventory.InventoryState;
import net.malisis.core.inventory.MalisisInventory;
import net.malisis.core.inventory.MalisisSlot;
import net.malisis.core.inventory.cache.CachedItemStack;
import net.malisis.core.inventory.cache.InventoryCache;
import net.malisis.core.inventory.message.CloseInventoryMessage;
import net.malisis.core.inventory.message.UpdateInventorySlotsMessage;
import net.malisis.core.inventory.player.PlayerInventory;
import net.malisis.core.util.ItemUtils;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class MalisisInventoryContainer
extends Container {
    public static final int DRAG_TYPE_SPREAD = 0;
    public static final int DRAG_TYPE_ONE = 1;
    public static final int DRAG_TYPE_PICKUP = 2;
    protected EntityPlayer owner;
    private int nexInventoryId = 0;
    protected PlayerInventory playerInventory;
    protected InventoryCache playerInventoryCache;
    protected Map<Integer, MalisisInventory> inventories = Maps.newHashMap();
    protected Map<MalisisInventory, InventoryCache> inventoryCaches = Maps.newHashMap();
    protected ItemStack pickedItemStack = ItemStack.field_190927_a;
    protected CachedItemStack pickedItemStackCache = new CachedItemStack(() -> this.pickedItemStack);
    protected int draggedAmount = 0;
    protected Set<MalisisSlot> draggedSlots = new HashSet<MalisisSlot>();
    protected int dragType = -1;
    protected ItemStack lastShiftClicked = ItemStack.field_190927_a;

    public MalisisInventoryContainer(EntityPlayer player, int windowId) {
        this.owner = player;
        this.playerInventory = new PlayerInventory(player);
        this.field_75152_c = windowId;
        if (this.isServer()) {
            EntityPlayerMP p = (EntityPlayerMP)player;
            p.func_71128_l();
            p.func_71117_bO();
            this.field_75152_c = p.field_71139_cq;
            this.playerInventoryCache = new InventoryCache(player, this.playerInventory, windowId);
        }
        this.owner.field_71070_bA = this;
    }

    private boolean isServer() {
        return this.owner instanceof EntityPlayerMP;
    }

    public int addInventory(MalisisInventory inventory) {
        this.inventories.put(this.nexInventoryId, inventory);
        inventory.setInventoryId(this.nexInventoryId);
        inventory.addOpenedContainer(this);
        if (this.isServer()) {
            this.inventoryCaches.put(inventory, new InventoryCache(this.owner, inventory, this.field_75152_c));
        }
        return this.nexInventoryId++;
    }

    public void removeInventory(MalisisInventory inventory) {
        Preconditions.checkNotNull((Object)inventory);
        inventory.removeOpenedContainer(this);
        this.inventories.remove(inventory.getInventoryId());
        if (this.isServer()) {
            this.inventoryCaches.remove(inventory);
        }
    }

    public MalisisInventory getInventory(int id) {
        return id == -1 ? this.playerInventory : this.inventories.get(id);
    }

    public MalisisInventory getPlayerInventory() {
        return this.playerInventory;
    }

    public Collection<MalisisInventory> getInventories() {
        return this.inventories.values();
    }

    public void setPickedItemStack(ItemStack itemStack) {
        this.pickedItemStack = (ItemStack)Preconditions.checkNotNull((Object)itemStack);
        this.owner.field_71071_by.func_70437_b(itemStack);
    }

    public ItemStack getPickedItemStack() {
        return this.pickedItemStack;
    }

    public boolean isDraggingItemStack() {
        return this.dragType != -1;
    }

    public boolean shouldEndDrag(int button) {
        if (!this.isDraggingItemStack()) {
            return false;
        }
        if (this.dragType == 1 || this.dragType == 0) {
            return this.dragType == button && this.draggedSlots.size() > 1;
        }
        return this.dragType == 2;
    }

    public boolean shouldResetDrag(int button) {
        if (!this.isDraggingItemStack()) {
            return false;
        }
        if (this.dragType == 0) {
            return button == 1 && this.draggedSlots.size() > 1;
        }
        if (this.dragType == 1) {
            return button == 0 && this.draggedSlots.size() > 1;
        }
        return this.dragType != 2;
    }

    public int getDragType() {
        return this.dragType;
    }

    public void sendInventoryContent() {
        this.inventoryCaches.values().forEach(InventoryCache::sendAll);
    }

    public void func_75142_b() {
        this.playerInventoryCache.sendChanges();
        this.inventoryCaches.values().forEach(InventoryCache::sendChanges);
        this.pickedItemStackCache.update();
        if (this.pickedItemStackCache.hasChanged()) {
            UpdateInventorySlotsMessage.updatePickedItemStack((ItemStack)this.pickedItemStackCache.get(), (EntityPlayerMP)this.owner, this.field_75152_c);
        }
    }

    public void close() {
        this.func_75134_a(this.owner);
        CloseInventoryMessage.send((EntityPlayerMP)this.owner);
    }

    public void func_75134_a(EntityPlayer owner) {
        super.func_75134_a(owner);
        this.getInventories().forEach(i -> i.removeOpenedContainer(this));
    }

    public ItemStack handleAction(ActionType action, int inventoryId, int slotNumber, int code) {
        NBTTagCompound nbt;
        MalisisInventory inventory = this.getInventory(inventoryId);
        if (inventory == null) {
            MalisisCore.log.error("[MalisisInventoryContainer] Tried to handle an action for a wrong inventory (" + inventoryId + ").");
            return null;
        }
        MalisisSlot slot = inventory.getSlot(slotNumber);
        if (slot == null) {
            MalisisCore.log.error("[MalisisInventoryContainer] Tried to handle an action for a wrong slotNumber (" + slotNumber + ").");
            return null;
        }
        if (slot.isState(InventoryState.FROZEN)) {
            return this.pickedItemStack;
        }
        if (slot.getItemStack().func_77973_b() instanceof IInventoryProvider && slot.getItemStack().func_77978_p() != null && (nbt = slot.getItemStack().func_77978_p()).func_74764_b("inventoryId")) {
            if (nbt.func_74762_e("inventoryId") == 0) {
                this.owner.func_71053_j();
                nbt.func_82580_o("inventoryId");
                return null;
            }
            nbt.func_82580_o("inventoryId");
        }
        if (action == ActionType.HOTBAR && code >= 0 && code < 9) {
            return this.handleHotbar(inventory, slot, code);
        }
        if (action == ActionType.DROP_SLOT_STACK || action == ActionType.DROP_SLOT_ONE) {
            return this.handleDropSlot(slot, action == ActionType.DROP_SLOT_STACK);
        }
        if (action.isDragAction()) {
            return this.handleDrag(action, slot);
        }
        this.func_94533_d();
        if (action == ActionType.DROP_ONE || action == ActionType.DROP_STACK) {
            return this.handleDropPickedStack(action == ActionType.DROP_STACK);
        }
        if (action == ActionType.PICKBLOCK && this.owner.field_71075_bZ.field_75098_d) {
            return this.handlePickBlock(slot);
        }
        if (action == ActionType.LEFT_CLICK || action == ActionType.RIGHT_CLICK) {
            return this.handleNormalClick(slot, action == ActionType.LEFT_CLICK);
        }
        if (action == ActionType.SHIFT_LEFT_CLICK) {
            this.lastShiftClicked = slot.getItemStack();
            ItemStack itemStack = this.handleShiftClick(inventory, slot);
            if (itemStack.func_190926_b()) {
                this.lastShiftClicked = ItemStack.field_190927_a;
            }
            return itemStack;
        }
        if (action == ActionType.DOUBLE_LEFT_CLICK || action == ActionType.DOUBLE_SHIFT_LEFT_CLICK) {
            return this.handleDoubleClick(inventory, slot, action == ActionType.DOUBLE_SHIFT_LEFT_CLICK);
        }
        return null;
    }

    private ItemStack handleDropPickedStack(boolean fullStack) {
        ItemUtils.ItemStackSplitter iss = new ItemUtils.ItemStackSplitter(this.pickedItemStack);
        iss.split(fullStack ? -1 : 1);
        this.owner.func_71019_a(iss.split, true);
        this.setPickedItemStack(iss.source);
        return iss.source;
    }

    private ItemStack handleNormalClick(MalisisSlot slot, boolean fullStack) {
        if (!this.getPickedItemStack().func_190926_b() && !slot.isItemValid(this.pickedItemStack)) {
            return this.getPickedItemStack();
        }
        if (!this.getPickedItemStack().func_190926_b()) {
            if (slot.isState(InventoryState.PLAYER_INSERT | InventoryState.PLAYER_EXTRACT)) {
                this.setPickedItemStack(slot.insert(this.pickedItemStack, fullStack ? -1 : 1, true));
            }
        } else if (slot.isState(InventoryState.PLAYER_EXTRACT)) {
            this.setPickedItemStack(slot.extract(fullStack ? -1 : -2));
        }
        return this.getPickedItemStack();
    }

    private ItemStack handleShiftClick(MalisisInventory inventory, MalisisSlot slot) {
        ItemStack itemStack = this.transferSlotOutOfInventory(inventory, slot);
        slot.setItemStack(itemStack);
        slot.onSlotChanged();
        return itemStack;
    }

    private ItemStack transferSlotOutOfInventory(MalisisInventory inventory, MalisisSlot slot) {
        ItemStack itemStack = slot.getItemStack();
        if (itemStack.func_190926_b() || !inventory.state.is(InventoryState.PLAYER_EXTRACT) || !slot.state.is(InventoryState.PLAYER_INSERT)) {
            return itemStack;
        }
        if (inventory == this.getPlayerInventory()) {
            for (MalisisInventory inv : this.getInventories()) {
                if (!inv.state.is(InventoryState.PLAYER_INSERT) || !(itemStack = inv.transferInto(itemStack)).func_190926_b()) continue;
                break;
            }
        } else if (this.getPlayerInventory().state.is(InventoryState.PLAYER_INSERT)) {
            itemStack = this.getPlayerInventory().transferInto(itemStack);
        }
        return itemStack;
    }

    private ItemStack handleHotbar(MalisisInventory inventory, MalisisSlot hoveredSlot, int num) {
        MalisisSlot hotbarSlot = this.getPlayerInventory().getSlot(num);
        if (inventory == this.getPlayerInventory() || hoveredSlot.getItemStack().func_190926_b()) {
            if (hoveredSlot.isState(InventoryState.PLAYER_INSERT)) {
                ItemStack dest = hotbarSlot.extract(-1);
                ItemStack src = hoveredSlot.extract(-1);
                if (!(dest = hoveredSlot.insert(dest)).func_190926_b()) {
                    hotbarSlot.insert(dest);
                    inventory.transferInto(src);
                } else {
                    src = hotbarSlot.insert(src);
                }
            }
        } else if (hoveredSlot.isState(InventoryState.PLAYER_EXTRACT)) {
            ItemStack dest = hoveredSlot.extract(-1);
            ItemStack left = hotbarSlot.insert(dest, -1, true);
            this.getPlayerInventory().transferInto(left, false);
        }
        return hotbarSlot.getItemStack();
    }

    private ItemStack handleDropSlot(MalisisSlot hoveredSlot, boolean fullStack) {
        ItemStack itemStack = hoveredSlot.getItemStack();
        if (itemStack.func_190926_b() || !hoveredSlot.isState(InventoryState.PLAYER_EXTRACT)) {
            return itemStack;
        }
        ItemUtils.ItemStackSplitter iss = new ItemUtils.ItemStackSplitter(hoveredSlot.getItemStack());
        iss.split(fullStack ? -1 : 1);
        hoveredSlot.setItemStack(iss.source);
        hoveredSlot.onSlotChanged();
        this.owner.func_71019_a(iss.split, true);
        if (iss.amount != 0) {
            hoveredSlot.onPickupFromSlot(this.owner, iss.split);
        }
        return iss.split;
    }

    private ItemStack handleDoubleClick(MalisisInventory inventory, MalisisSlot slot, boolean shiftClick) {
        if (!inventory.state.is(InventoryState.PLAYER_EXTRACT)) {
            return ItemStack.field_190927_a;
        }
        if (!shiftClick && !this.pickedItemStack.func_190926_b()) {
            for (int i = 0; i < 2; ++i) {
                for (MalisisInventory inv : this.getInventories()) {
                    if (inv.pullItemStacks(this.pickedItemStack, i == 0)) break;
                }
                if (this.pickedItemStack.func_190916_E() >= this.pickedItemStack.func_77976_d()) continue;
                this.getPlayerInventory().pullItemStacks(this.pickedItemStack, i == 0);
            }
            this.setPickedItemStack(this.pickedItemStack);
        } else if (!this.lastShiftClicked.func_190926_b()) {
            if (inventory == this.getPlayerInventory()) {
                // empty if block
            }
            for (MalisisSlot s : inventory.getNonEmptySlots()) {
                ItemStack itemStack = s.getItemStack();
                if (!s.isState(InventoryState.PLAYER_EXTRACT) || !ItemUtils.areItemStacksStackable(itemStack, this.lastShiftClicked)) continue;
                itemStack = this.transferSlotOutOfInventory(inventory, s);
                slot.setItemStack(itemStack);
                slot.onSlotChanged();
                if (itemStack.func_190926_b()) continue;
                return itemStack;
            }
        }
        this.lastShiftClicked = ItemStack.field_190927_a;
        return ItemStack.field_190927_a;
    }

    private ItemStack handlePickBlock(MalisisSlot slot) {
        if (slot.getItemStack().func_190926_b() || !this.pickedItemStack.func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        ItemStack itemStack = ItemUtils.copy(slot.getItemStack());
        itemStack.func_190920_e(itemStack.func_77976_d());
        this.setPickedItemStack(itemStack);
        return itemStack;
    }

    private ItemStack handleDrag(ActionType action, MalisisSlot slot) {
        if (this.pickedItemStack == ItemStack.field_190927_a) {
            return ItemStack.field_190927_a;
        }
        if ((action == ActionType.DRAG_START_LEFT_CLICK || action == ActionType.DRAG_START_RIGHT_CLICK) && this.isDraggingItemStack()) {
            return ItemStack.field_190927_a;
        }
        if (action == ActionType.DRAG_RESET) {
            this.func_94533_d();
            return this.pickedItemStack;
        }
        if (action == ActionType.DRAG_END && this.dragType == 2) {
            int size = this.pickedItemStack.func_190916_E();
            this.func_94533_d();
            this.pickedItemStack.func_190920_e(size);
            return this.pickedItemStack;
        }
        if (action == ActionType.DRAG_END) {
            int amountMerged = 0;
            for (MalisisSlot s : this.draggedSlots) {
                if (!s.isItemValid(this.pickedItemStack) || !s.isState(InventoryState.PLAYER_INSERT) || s.getDraggedItemStack().func_190926_b()) continue;
                amountMerged += s.getDraggedItemStack().func_190916_E();
                s.insert(s.getDraggedItemStack());
                s.setDraggedItemStack(ItemStack.field_190927_a);
            }
            if (this.pickedItemStack.func_190926_b()) {
                this.setPickedItemStack(ItemStack.field_190927_a);
            }
            this.func_94533_d();
            if (!this.pickedItemStack.func_190926_b()) {
                this.pickedItemStack.func_190918_g(amountMerged);
            }
            return this.pickedItemStack;
        }
        if (action == ActionType.DRAG_START_PICKUP) {
            if (slot.isState(InventoryState.PLAYER_EXTRACT)) {
                this.dragType = 2;
            }
            return this.pickedItemStack;
        }
        if (action == ActionType.DRAG_ADD_SLOT && this.dragType == 2) {
            if (this.pickedItemStack.func_190916_E() >= this.pickedItemStack.func_77976_d()) {
                return this.pickedItemStack;
            }
            if (!slot.isState(InventoryState.PLAYER_EXTRACT)) {
                return this.pickedItemStack;
            }
            ItemUtils.ItemStacksMerger ism = new ItemUtils.ItemStacksMerger(slot.getItemStack(), this.pickedItemStack);
            ism.merge();
            this.setPickedItemStack(ism.into);
            slot.setItemStack(ism.merge);
            slot.onSlotChanged();
            return this.pickedItemStack;
        }
        if (!slot.isState(InventoryState.PLAYER_INSERT)) {
            return this.pickedItemStack;
        }
        this.draggedSlots.add(slot);
        if (action == ActionType.DRAG_START_LEFT_CLICK || action == ActionType.DRAG_START_RIGHT_CLICK) {
            this.draggedAmount = this.pickedItemStack.func_190916_E();
            this.dragType = action == ActionType.DRAG_START_LEFT_CLICK ? 0 : 1;
            return this.pickedItemStack;
        }
        if (this.draggedSlots.size() > this.draggedAmount) {
            return ItemStack.field_190927_a;
        }
        if (this.draggedSlots.size() <= 1) {
            return this.pickedItemStack;
        }
        int amountPerSlot = this.dragType == 0 ? Math.max(this.draggedAmount / this.draggedSlots.size(), 1) : 1;
        int amountTotal = 0;
        for (MalisisSlot s : this.draggedSlots) {
            if (!s.isItemValid(this.pickedItemStack)) continue;
            ItemStack itemStack = ItemUtils.copy(this.pickedItemStack);
            itemStack.func_190920_e(this.draggedAmount);
            ItemStack slotStack = s.getItemStack();
            if (!slotStack.func_190926_b()) {
                slotStack = slotStack.func_77946_l();
            }
            ItemUtils.ItemStacksMerger ism = new ItemUtils.ItemStacksMerger(itemStack, slotStack);
            ism.merge(amountPerSlot, s.getSlotStackLimit());
            ism.merge.func_190918_g(s.getItemStack().func_190916_E());
            s.setDraggedItemStack(ism.into);
            amountTotal += ism.nbMerged;
        }
        this.pickedItemStack.func_190920_e(this.draggedAmount - amountTotal);
        return this.pickedItemStack;
    }

    protected void func_94533_d() {
        if (!this.isDraggingItemStack()) {
            return;
        }
        if (!this.pickedItemStack.func_190926_b()) {
            this.pickedItemStack.func_190920_e(this.draggedAmount);
        }
        this.draggedSlots.forEach(s -> s.setDraggedItemStack(ItemStack.field_190927_a));
        this.draggedSlots.clear();
        this.draggedAmount = 0;
        this.dragType = -1;
    }

    public boolean func_75145_c(EntityPlayer var1) {
        return true;
    }

    public Slot func_75139_a(int slotId) {
        return null;
    }

    public static enum ActionType {
        LEFT_CLICK,
        RIGHT_CLICK,
        PICKBLOCK,
        SHIFT_LEFT_CLICK,
        SHIFT_RIGHT_CLICK,
        DOUBLE_LEFT_CLICK,
        DOUBLE_SHIFT_LEFT_CLICK,
        DRAG_START_LEFT_CLICK,
        DRAG_START_RIGHT_CLICK,
        DRAG_START_PICKUP,
        DRAG_ADD_SLOT,
        DRAG_END,
        DRAG_RESET,
        HOTBAR,
        DROP_ONE,
        DROP_STACK,
        DROP_SLOT_ONE,
        DROP_SLOT_STACK;


        public boolean isDragAction() {
            return this == DRAG_START_LEFT_CLICK || this == DRAG_START_RIGHT_CLICK || this == DRAG_START_PICKUP || this == DRAG_ADD_SLOT || this == DRAG_END || this == DRAG_RESET;
        }
    }
}

