/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.core.client.gui.component.interaction;

import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.base.Predicates;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.Iterables;
import java.util.Collections;
import java.util.Iterator;
import java.util.Objects;
import net.malisis.core.client.gui.GuiRenderer;
import net.malisis.core.client.gui.MalisisGui;
import net.malisis.core.client.gui.component.IGuiText;
import net.malisis.core.client.gui.component.UIComponent;
import net.malisis.core.client.gui.component.control.IScrollable;
import net.malisis.core.client.gui.component.control.UIScrollBar;
import net.malisis.core.client.gui.component.control.UISlimScrollbar;
import net.malisis.core.client.gui.element.GuiShape;
import net.malisis.core.client.gui.element.SimpleGuiShape;
import net.malisis.core.client.gui.element.XResizableGuiShape;
import net.malisis.core.client.gui.element.XYResizableGuiShape;
import net.malisis.core.client.gui.event.ComponentEvent;
import net.malisis.core.renderer.font.FontOptions;
import net.malisis.core.renderer.font.MalisisFont;
import net.malisis.core.renderer.icon.provider.GuiIconProvider;
import org.apache.commons.lang3.StringUtils;

public class UISelect<T>
extends UIComponent<UISelect<T>>
implements Iterable<Option<T>>,
IGuiText<UISelect<T>> {
    protected MalisisFont font = MalisisFont.minecraftFont;
    protected FontOptions fontOptions = FontOptions.builder().color(0xFFFFFF).shadow().build();
    protected FontOptions hoveredFontOptions = FontOptions.builder().color(16701599).shadow().build();
    protected FontOptions selectedFontOptions = FontOptions.builder().color(10397919).shadow().build();
    protected FontOptions disabledFontOptions = FontOptions.builder().color(0x444444).build();
    protected FluentIterable<Option<T>> options;
    protected Option<T> selectedOption = null;
    protected int maxExpandedWidth = -1;
    protected int maxDisplayedOptions = Integer.MAX_VALUE;
    protected boolean expanded = false;
    protected OptionsContainer optionsContainer;
    protected int optionsWidth = 0;
    protected int optionsHeight = 0;
    protected String labelPattern;
    protected Function<T, ? extends Option<T>> optionFunction;
    protected Function<T, String> labelFunction;
    protected Predicate<T> disablePredicate = Predicates.alwaysFalse();
    private Function<T, Option<T>> toOption = new Function<T, Option<T>>(){

        public Option<T> apply(T input) {
            Option option = UISelect.this.optionFunction != null ? (Option)UISelect.this.optionFunction.apply(input) : new Option(input);
            option.setLabel(UISelect.this.labelFunction != null ? (String)UISelect.this.labelFunction.apply(input) : Objects.toString(input));
            option.setDisabled(UISelect.this.disablePredicate.apply(input));
            return option;
        }
    };
    protected int bgColor = 0xFFFFFF;
    protected int hoverBgColor = 6191263;
    protected GuiShape arrowShape;
    protected GuiIconProvider arrowIcon;

    public UISelect(MalisisGui gui, int width, Iterable<T> values) {
        super(gui);
        this.setSize(width, 12);
        this.setOptions(values);
        this.shape = new XResizableGuiShape(3);
        this.arrowShape = new SimpleGuiShape();
        this.arrowShape.setSize(7, 4);
        this.arrowShape.storeState();
        this.iconProvider = new GuiIconProvider(gui.getGuiTexture().getXResizableIcon(200, 30, 9, 12, 3), null, gui.getGuiTexture().getXResizableIcon(200, 42, 9, 12, 3));
        this.arrowIcon = new GuiIconProvider(gui.getGuiTexture().getIcon(209, 48, 7, 4));
        this.optionsContainer = new OptionsContainer(gui);
    }

    public UISelect(MalisisGui gui, int width) {
        this(gui, width, null);
    }

    @Override
    public MalisisFont getFont() {
        return this.font;
    }

    @Override
    public UISelect<T> setFont(MalisisFont font) {
        this.font = font;
        this.calcOptionsSize();
        return this;
    }

    @Override
    public FontOptions getFontOptions() {
        return this.fontOptions;
    }

    @Override
    public UISelect<T> setFontOptions(FontOptions options) {
        this.fontOptions = options;
        this.calcOptionsSize();
        return this;
    }

    public FontOptions getHoveredFontOptions() {
        return this.hoveredFontOptions;
    }

    public UISelect<T> setSelectedFontOptions(FontOptions options) {
        this.selectedFontOptions = options;
        return this;
    }

    public FontOptions getSelectedFontOptions() {
        return this.selectedFontOptions;
    }

    public UISelect<T> setDisabledFontOptions(FontOptions options) {
        this.disabledFontOptions = options;
        return this;
    }

    public FontOptions getDisabledFontOptions() {
        return this.disabledFontOptions;
    }

    public UISelect<T> setHoveredFontOptions(FontOptions options) {
        this.hoveredFontOptions = options;
        return this;
    }

    public int getBgColor() {
        return this.bgColor;
    }

    public UISelect<T> setBgColor(int bgColor) {
        this.bgColor = bgColor;
        return this;
    }

    public int getHoverBgColor() {
        return this.hoverBgColor;
    }

    public UISelect<T> setHoverBgColor(int hoverBgColor) {
        this.hoverBgColor = hoverBgColor;
        return this;
    }

    public UISelect<T> setColors(int bgColor, int hoverBgColor) {
        this.bgColor = bgColor;
        this.hoverBgColor = hoverBgColor;
        return this;
    }

    public UISelect<T> setOptionFunction(Function<T, ? extends Option<T>> func) {
        this.optionFunction = func;
        return this;
    }

    public UISelect<T> setLabelFunction(Function<T, String> func) {
        this.labelFunction = func;
        this.calcOptionsSize();
        return this;
    }

    public UISelect<T> setDisablePredicate(Predicate<T> predicate) {
        if (predicate == null) {
            predicate = Predicates.alwaysFalse();
        }
        this.disablePredicate = predicate;
        return this;
    }

    public UISelect<T> setLabelPattern(String labelPattern) {
        this.labelPattern = labelPattern;
        this.calcOptionsSize();
        return this;
    }

    public UISelect<T> setMaxExpandedWidth(int width) {
        this.maxExpandedWidth = width;
        this.calcOptionsSize();
        return this;
    }

    private void calcOptionsSize() {
        this.optionsWidth = this.getWidth() - 4;
        for (Option<T> option : this) {
            this.optionsWidth = Math.max(this.optionsWidth, (int)MalisisFont.minecraftFont.getStringWidth(option.getLabel(this.labelPattern), this.fontOptions));
        }
        this.optionsWidth += 4;
        if (this.maxExpandedWidth > 0) {
            this.optionsWidth = Math.min(this.maxExpandedWidth, this.optionsWidth);
        }
    }

    public UISelect<T> maxDisplayedOptions(int amount) {
        this.maxDisplayedOptions = amount;
        this.calcOptionsSize();
        return this;
    }

    public UISelect<T> setOptions(Iterable<T> values) {
        if (values == null) {
            values = Collections.emptyList();
        }
        this.options = FluentIterable.from(values).transform(this.toOption);
        this.calcOptionsSize();
        return this;
    }

    public Option<T> getOption(T obj) {
        if (obj == null) {
            return null;
        }
        for (Option<T> opt : this) {
            if (!obj.equals(opt.getKey())) continue;
            return opt;
        }
        return null;
    }

    public void setSelectedOption(T obj) {
        this.setSelectedOption(this.getOption(obj));
    }

    public void setSelectedOption(Option<T> option) {
        this.selectedOption = option;
    }

    public Option<T> getSelectedOption() {
        return this.selectedOption;
    }

    public T getSelectedValue() {
        Option<T> opt = this.getSelectedOption();
        if (opt == null) {
            return null;
        }
        return opt.getKey();
    }

    public T select(Option<T> option) {
        Object value;
        Object t = value = option != null ? (Object)option.getKey() : null;
        if (Objects.equals(option, this.selectedOption)) {
            return value;
        }
        if (this.fireEvent(new SelectEvent<Object>(this, value))) {
            this.setSelectedOption(option);
        }
        if (this.expanded && this.maxDisplayedOptions < this.options.size()) {
            this.optionsContainer.updateOptionOffset();
        }
        return this.getSelectedValue();
    }

    public T select(T obj) {
        return (T)this.select((T)this.getOption(obj));
    }

    public T selectFirst() {
        return (T)this.select((T)((Option)Iterables.getFirst(this.options, null)));
    }

    public T selectLast() {
        return (T)this.select((T)((Option)Iterables.getLast(this.options, null)));
    }

    public T selectPrevious() {
        if (this.selectedOption == null) {
            return this.selectFirst();
        }
        Option<T> option = (Option<T>)Iterables.getFirst(this.options, null);
        for (Option<T> opt : this) {
            if (opt.isDisabled()) continue;
            if (opt.equals(this.selectedOption)) {
                return (T)this.select((T)option);
            }
            option = opt;
        }
        return null;
    }

    public T selectNext() {
        if (this.selectedOption == null) {
            return this.selectFirst();
        }
        Option<T> option = null;
        for (Option<T> opt : this) {
            if (opt.isDisabled()) continue;
            if (this.selectedOption.equals(option)) {
                return (T)this.select((T)opt);
            }
            option = opt;
        }
        return null;
    }

    protected int getSelectedIndex() {
        if (this.selectedOption == null) {
            return 0;
        }
        for (int i = 0; i < this.options.size(); ++i) {
            if (!((Option)this.options.get(i)).equals(this.selectedOption)) continue;
            return i;
        }
        return 0;
    }

    @Override
    public boolean isInsideBounds(int x, int y) {
        if (super.isInsideBounds(x, y)) {
            return true;
        }
        if (!this.expanded || !this.isVisible()) {
            return false;
        }
        return x >= this.screenX() && x <= this.screenX() + this.optionsWidth && y >= this.screenY() + 12 && y <= this.screenY() + 12 + this.optionsHeight;
    }

    @Override
    public void drawBackground(GuiRenderer renderer, int mouseX, int mouseY, float partialTick) {
        this.rp.colorMultiplier.set(this.bgColor);
        renderer.drawShape(this.shape, this.rp);
    }

    @Override
    public void drawForeground(GuiRenderer renderer, int mouseX, int mouseY, float partialTick) {
        if (this.selectedOption != null) {
            this.select(this.selectedOption.getKey());
        }
        this.arrowShape.resetState();
        this.arrowShape.setPosition(this.getWidth() - 9, 4);
        if (this.isHovered() || this.expanded) {
            this.rp.colorMultiplier.set(12503295);
        } else {
            this.rp.colorMultiplier.reset();
        }
        this.rp.iconProvider.set(this.arrowIcon);
        renderer.drawShape(this.arrowShape, this.rp);
        if (this.selectedOption != null) {
            this.selectedOption.draw(this, renderer, 2, 2, 2, partialTick, false, true);
        }
    }

    @Override
    public boolean onClick(int x, int y) {
        if (!this.expanded) {
            this.optionsContainer.display();
        } else {
            this.optionsContainer.hide();
        }
        return true;
    }

    @Override
    public boolean onScrollWheel(int x, int y, int delta) {
        if (!this.isFocused()) {
            return true;
        }
        if (delta < 0) {
            this.selectNext();
        } else {
            this.selectPrevious();
        }
        return true;
    }

    @Override
    public boolean onKeyTyped(char keyChar, int keyCode) {
        if (!this.isFocused() && !this.optionsContainer.isFocused()) {
            return super.onKeyTyped(keyChar, keyCode);
        }
        switch (keyCode) {
            case 200: {
                this.selectPrevious();
                break;
            }
            case 208: {
                this.selectNext();
                break;
            }
            case 199: {
                this.selectFirst();
                break;
            }
            case 207: {
                this.selectLast();
                break;
            }
            default: {
                return super.onKeyTyped(keyChar, keyCode);
            }
        }
        return true;
    }

    @Override
    public Iterator<Option<T>> iterator() {
        return this.options.iterator();
    }

    public static class SelectEvent<T>
    extends ComponentEvent.ValueChange<UISelect<T>, T> {
        public SelectEvent(UISelect<T> component, T newValue) {
            super(component, component.getSelectedValue(), newValue);
        }
    }

    public static class Option<T> {
        private T key;
        private String label;
        private boolean disabled;

        public Option(T key) {
            this.key = key;
        }

        public Option(T key, String label) {
            this.key = key;
            this.label = label;
        }

        public T getKey() {
            return this.key;
        }

        public String getLabel(String pattern) {
            if (pattern == null) {
                return this.label;
            }
            return String.format(pattern, this.label);
        }

        public String getLabel() {
            return this.label;
        }

        public void setLabel(String label) {
            this.label = label;
        }

        public boolean isDisabled() {
            return this.disabled;
        }

        public void setDisabled(boolean disabled) {
            this.disabled = disabled;
        }

        public int getHeight(UISelect<T> select) {
            return (int)(select.font.getStringHeight(select.fontOptions) + 1.0f);
        }

        public void draw(UISelect<T> select, GuiRenderer renderer, int x, int y, int z, float partialTick, boolean hovered, boolean isTop) {
            String text = this.getLabel(select.labelPattern);
            if (StringUtils.isEmpty((CharSequence)text)) {
                return;
            }
            if (hovered && !this.disabled) {
                renderer.drawRectangle(x + 1, y - 1, z + 2, select.optionsWidth - 2, this.getHeight(select), select.getHoverBgColor(), 255);
            }
            if (isTop) {
                text = MalisisFont.minecraftFont.clipString(text, select.getWidth() - 15, select.fontOptions);
            }
            FontOptions options = select.getFontOptions();
            if (this.equals(select.getSelectedOption()) && !isTop) {
                options = select.getSelectedFontOptions();
            }
            if (hovered) {
                options = select.getHoveredFontOptions();
            }
            if (this.disabled) {
                options = select.getDisabledFontOptions();
            }
            renderer.drawText(select.font, text, x + 2, y, z + 2, options);
        }

        public boolean equals(Object obj) {
            return obj != null && obj instanceof Option && this.key.equals(((Option)obj).key);
        }
    }

    public class OptionsContainer
    extends UIComponent<OptionsContainer>
    implements IScrollable {
        protected UISlimScrollbar scrollbar;
        protected int optionOffset;
        protected GuiShape optionsShape;
        protected GuiShape optionBackground;
        protected GuiIconProvider iconsExpanded;

        public OptionsContainer(MalisisGui gui) {
            super(gui);
            gui.addToScreen(this);
            this.setZIndex(300);
            this.hide();
            this.shape = new XYResizableGuiShape(1);
            this.optionBackground = new SimpleGuiShape();
            this.scrollbar = new UISlimScrollbar(gui, this, UIScrollBar.Type.VERTICAL);
            this.scrollbar.setFade(false);
            this.scrollbar.setAutoHide(true);
            this.scrollbar.setOffset(0, 0);
            this.iconsExpanded = new GuiIconProvider(gui.getGuiTexture().getXYResizableIcon(200, 30, 9, 12, 1));
        }

        @Override
        public int getWidth() {
            return UISelect.this.optionsWidth;
        }

        @Override
        public int getHeight() {
            int h = 0;
            for (int i = this.optionOffset; i < Math.min(this.optionOffset + UISelect.this.maxDisplayedOptions, UISelect.this.options.size()); ++i) {
                h += ((Option)UISelect.this.options.get(i)).getHeight(UISelect.this);
            }
            return h + 2;
        }

        private void display() {
            this.setVisible(true);
            this.setPosition(UISelect.this.screenX(), UISelect.this.screenY() + UISelect.this.getHeight());
            this.optionOffset = Math.max(0, Math.min(UISelect.this.options.size() - UISelect.this.maxDisplayedOptions, UISelect.this.getSelectedIndex()));
            this.scrollbar.updateScrollbar();
            this.setFocused(true);
            UISelect.this.expanded = true;
        }

        private void hide() {
            if (this.isFocused()) {
                this.setFocused(false);
            }
            this.setVisible(false);
            UISelect.this.expanded = false;
        }

        private void updateOptionOffset() {
            int i = UISelect.this.getSelectedIndex();
            if (i < this.optionOffset) {
                this.optionOffset = i;
            } else if (i >= this.optionOffset + UISelect.this.maxDisplayedOptions) {
                this.optionOffset = i - UISelect.this.maxDisplayedOptions + 1;
            }
            this.optionOffset = Math.max(0, Math.min(UISelect.this.options.size() - UISelect.this.maxDisplayedOptions, this.optionOffset));
        }

        protected Option<T> getOptionAt(int mouseX, int mouseY) {
            if (!this.isInsideBounds(mouseX, mouseY)) {
                return null;
            }
            int y = this.relativeY(mouseY);
            int cy = 2;
            for (int i = this.optionOffset; i < this.optionOffset + UISelect.this.maxDisplayedOptions && i < UISelect.this.options.size(); ++i) {
                Option option = (Option)UISelect.this.options.get(i);
                if (cy + option.getHeight(UISelect.this) > y) {
                    return option;
                }
                cy += option.getHeight(UISelect.this);
            }
            return null;
        }

        @Override
        public int getContentHeight() {
            int h = 0;
            for (Option option : UISelect.this) {
                h += option.getHeight(UISelect.this);
            }
            return h;
        }

        @Override
        public int getContentWidth() {
            return 0;
        }

        @Override
        public float getOffsetX() {
            return 0.0f;
        }

        @Override
        public void setOffsetX(float offsetX, int delta) {
        }

        @Override
        public float getOffsetY() {
            if (UISelect.this.options.size() < UISelect.this.maxDisplayedOptions) {
                return 0.0f;
            }
            return (float)this.optionOffset / (float)(UISelect.this.options.size() - UISelect.this.maxDisplayedOptions);
        }

        @Override
        public void setOffsetY(float offsetY, int delta) {
            this.optionOffset = Math.round(offsetY / this.getScrollStep());
            this.optionOffset = Math.max(0, Math.min(UISelect.this.options.size() - UISelect.this.maxDisplayedOptions, this.optionOffset));
        }

        @Override
        public float getScrollStep() {
            return 1.0f / (float)(UISelect.this.options.size() - UISelect.this.maxDisplayedOptions);
        }

        @Override
        public int getVerticalPadding() {
            return 1;
        }

        @Override
        public int getHorizontalPadding() {
            return 1;
        }

        @Override
        public void drawBackground(GuiRenderer renderer, int mouseX, int mouseY, float partialTick) {
            this.rp.iconProvider.set(this.iconsExpanded);
            this.rp.colorMultiplier.set(UISelect.this.bgColor);
            renderer.drawShape(this.shape, this.rp);
            renderer.next();
        }

        @Override
        public void drawForeground(GuiRenderer renderer, int mouseX, int mouseY, float partialTick) {
            if (!(this.isFocused() || UISelect.this.isFocused() || this.scrollbar.isFocused())) {
                this.hide();
            }
            Option hover = this.getOptionAt(mouseX, mouseY);
            int y = 1;
            for (int i = this.optionOffset; i < this.optionOffset + UISelect.this.maxDisplayedOptions && i < UISelect.this.options.size(); ++i) {
                Option option = (Option)UISelect.this.options.get(i);
                option.draw(UISelect.this, renderer, 0, y + 1, 0, partialTick, option.equals(hover), false);
                y += option.getHeight(UISelect.this);
            }
        }

        @Override
        public boolean onClick(int x, int y) {
            Option opt = this.getOptionAt(x, y);
            if (opt != null) {
                if (opt.isDisabled()) {
                    this.setFocused(true);
                    return true;
                }
                UISelect.this.select(opt);
            }
            this.hide();
            UISelect.this.setFocused(true);
            this.scrollbar.updateScrollbar();
            return true;
        }

        @Override
        public boolean onKeyTyped(char keyChar, int keyCode) {
            return UISelect.this.onKeyTyped(keyChar, keyCode);
        }
    }
}

