/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.core.client.gui.component.interaction;

import net.malisis.core.client.gui.GuiRenderer;
import net.malisis.core.client.gui.MalisisGui;
import net.malisis.core.client.gui.component.IGuiText;
import net.malisis.core.client.gui.component.UIComponent;
import net.malisis.core.client.gui.component.decoration.UIImage;
import net.malisis.core.client.gui.element.XYResizableGuiShape;
import net.malisis.core.client.gui.event.ComponentEvent;
import net.malisis.core.renderer.font.FontOptions;
import net.malisis.core.renderer.font.MalisisFont;
import net.malisis.core.renderer.icon.GuiIcon;
import net.malisis.core.renderer.icon.provider.GuiIconProvider;
import net.malisis.core.util.MouseButton;
import net.minecraft.init.SoundEvents;

public class UIButton
extends UIComponent<UIButton>
implements IGuiText<UIButton> {
    protected MalisisFont font = MalisisFont.minecraftFont;
    protected FontOptions fontOptions = FontOptions.builder().color(0xFFFFFF).shadow().build();
    protected FontOptions hoveredFontOptions = FontOptions.builder().color(0xFFFFA0).shadow().build();
    protected String text;
    protected UIImage image;
    protected boolean autoSize = true;
    protected boolean isPressed = false;
    protected int bgColor = 0xFFFFFF;
    protected int offsetX;
    protected int offsetY;
    protected GuiIconProvider iconPressedProvider;

    public UIButton(MalisisGui gui) {
        super(gui);
        this.shape = new XYResizableGuiShape();
        this.iconProvider = new GuiIconProvider(gui.getGuiTexture().getXYResizableIcon(0, 20, 200, 20, 5), gui.getGuiTexture().getXYResizableIcon(0, 40, 200, 20, 5), gui.getGuiTexture().getXYResizableIcon(0, 0, 200, 20, 5));
        this.iconPressedProvider = new GuiIconProvider((GuiIcon)gui.getGuiTexture().getXYResizableIcon(0, 40, 200, 20, 5).flip(true, true));
    }

    public UIButton(MalisisGui gui, String text) {
        this(gui);
        this.setText(text);
    }

    public UIButton(MalisisGui gui, UIImage image) {
        this(gui);
        this.setImage(image);
    }

    @Override
    public MalisisFont getFont() {
        return this.font;
    }

    @Override
    public UIButton setFont(MalisisFont font) {
        this.font = font;
        this.setSize(this.width, this.height);
        return this;
    }

    @Override
    public FontOptions getFontOptions() {
        return this.fontOptions;
    }

    @Override
    public UIButton setFontOptions(FontOptions options) {
        this.fontOptions = options;
        this.setSize(this.width, this.height);
        return this;
    }

    public FontOptions getHoveredFontOptions() {
        return this.hoveredFontOptions;
    }

    public UIButton setHoveredFontOptions(FontOptions hoveredOptions) {
        this.hoveredFontOptions = hoveredOptions;
        return this;
    }

    public String getText() {
        return this.text;
    }

    public UIButton setText(String text) {
        this.text = text;
        this.setSize(this.width, this.height);
        this.image = null;
        return this;
    }

    public UIImage getImage() {
        return this.image;
    }

    public UIButton setImage(UIImage image) {
        this.image = image;
        image.setParent(this);
        this.setSize(this.width, this.height);
        this.text = null;
        return this;
    }

    public UIButton setSize(int width) {
        return this.setSize(width, 20);
    }

    @Override
    public UIButton setSize(int width, int height) {
        if (this.autoSize) {
            if (this.image != null) {
                int w = this.image.getRawWidth();
                int h = this.image.getRawHeight();
                width = Math.max(width, w + 2);
                height = Math.max(height, h + 2);
            } else {
                int w = (int)this.font.getStringWidth(this.text, this.fontOptions);
                int h = (int)this.font.getStringHeight(this.fontOptions);
                width = Math.max(width, w + 6);
                height = Math.max(height, h + 6);
            }
        }
        this.width = width;
        this.height = height;
        return this;
    }

    public boolean isAutoSize() {
        return this.autoSize;
    }

    public UIButton setAutoSize(boolean autoSize) {
        this.autoSize = autoSize;
        this.setSize(this.width, this.height);
        return this;
    }

    public int getBgColor() {
        return this.bgColor;
    }

    public UIButton setBgColor(int bgColor) {
        this.bgColor = bgColor;
        return this;
    }

    public int getOffsetX() {
        return this.offsetX;
    }

    public int getOffsetY() {
        return this.offsetY;
    }

    public UIButton setOffset(int x, int y) {
        this.offsetX = x;
        this.offsetY = y;
        return this;
    }

    @Override
    public boolean onClick(int x, int y) {
        MalisisGui.playSound(SoundEvents.field_187909_gi);
        this.fireEvent(new ClickEvent(this, x, y));
        return true;
    }

    @Override
    public boolean onButtonPress(int x, int y, MouseButton button) {
        if (button == MouseButton.LEFT) {
            this.isPressed = true;
        }
        return super.onButtonPress(x, y, button);
    }

    @Override
    public boolean onButtonRelease(int x, int y, MouseButton button) {
        if (button == MouseButton.LEFT) {
            this.isPressed = false;
        }
        return super.onButtonRelease(x, y, button);
    }

    @Override
    public void drawBackground(GuiRenderer renderer, int mouseX, int mouseY, float partialTick) {
        if (this.isPressed && this.isHovered()) {
            this.rp.iconProvider.set(this.iconPressedProvider);
        }
        this.rp.colorMultiplier.set(this.bgColor);
        renderer.drawShape(this.shape, this.rp);
    }

    @Override
    public void drawForeground(GuiRenderer renderer, int mouseX, int mouseY, float partialTick) {
        int w = 0;
        int h = 0;
        if (this.image != null) {
            w = this.image.getWidth();
            h = this.image.getHeight();
        } else {
            w = (int)this.font.getStringWidth(this.text, this.fontOptions);
            h = (int)this.font.getStringHeight(this.fontOptions);
        }
        int x = (this.getWidth() - w) / 2;
        int y = (this.getHeight() - h) / 2;
        if (x == 0) {
            x = 1;
        }
        if (y == 0) {
            y = 1;
        }
        if (this.isPressed && this.isHovered()) {
            ++x;
            ++y;
        }
        x += this.offsetX;
        y += this.offsetY;
        if (this.image != null) {
            this.image.setPosition(x, y);
            this.image.setZIndex(this.zIndex);
            this.image.draw(renderer, mouseX, mouseY, partialTick);
        } else {
            renderer.drawText(this.font, this.text, x, y, 0.0f, this.isHovered() ? this.hoveredFontOptions : this.fontOptions);
        }
    }

    @Override
    public String getPropertyString() {
        return (this.image != null ? "{" + this.image + "}" : this.text) + " | " + super.getPropertyString();
    }

    public static class ClickEvent
    extends ComponentEvent<UIButton> {
        private int x;
        private int y;

        public ClickEvent(UIButton component, int x, int y) {
            super(component);
            this.x = x;
            this.y = y;
        }

        public int getX() {
            return this.x;
        }

        public int getY() {
            return this.y;
        }
    }
}

