/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.core.client.gui.component.decoration;

import net.malisis.core.client.gui.GuiRenderer;
import net.malisis.core.client.gui.GuiTexture;
import net.malisis.core.client.gui.MalisisGui;
import net.malisis.core.client.gui.component.UIComponent;
import net.malisis.core.client.gui.element.SimpleGuiShape;
import net.malisis.core.renderer.icon.Icon;
import net.malisis.core.renderer.icon.VanillaIcon;

public class UIProgressBar
extends UIComponent<UIProgressBar> {
    protected float progress = 0.0f;
    protected boolean reversed = false;
    protected boolean vertical = false;
    protected GuiTexture texture;
    protected Icon backgroundIcon;
    protected Icon filledIcon;

    public UIProgressBar(MalisisGui gui) {
        super(gui);
        this.setSize(22, 16);
        this.shape = new SimpleGuiShape();
        this.texture = this.getGui().getGuiTexture();
        this.backgroundIcon = this.texture.createIcon(246, 0, 22, 16);
        this.filledIcon = this.texture.createIcon(246, 16, 22, 16);
    }

    public UIProgressBar(MalisisGui gui, int width, int height, GuiTexture texture, Icon backgroundIcon, Icon filledIcon) {
        super(gui);
        this.setSize(width, height);
        this.shape = new SimpleGuiShape();
        this.texture = texture;
        this.backgroundIcon = backgroundIcon;
        this.filledIcon = filledIcon;
    }

    public UIProgressBar setReversed() {
        this.reversed = true;
        return this;
    }

    public UIProgressBar setVertical() {
        this.vertical = true;
        return this;
    }

    public float getProgress() {
        return this.progress;
    }

    public void setProgress(float progress) {
        if (progress < 0.0f) {
            progress = 0.0f;
        }
        if (progress > 1.0f) {
            progress = 1.0f;
        }
        this.progress = progress;
    }

    @Override
    public void drawBackground(GuiRenderer renderer, int mouseX, int mouseY, float partialTick) {
        renderer.bindTexture(this.texture);
        this.rp.icon.set(this.backgroundIcon.flip(!this.vertical && this.reversed, this.vertical && this.reversed));
        this.shape.resetState();
        this.shape.setSize(this.getWidth(), this.getHeight());
        renderer.drawShape(this.shape, this.rp);
    }

    @Override
    public void drawForeground(GuiRenderer renderer, int mouseX, int mouseY, float partialTick) {
        renderer.bindTexture(this.texture);
        int width = this.getWidth();
        int height = this.getHeight();
        int length = (int)((float)(this.vertical ? width : height) * this.progress);
        Icon icon = this.filledIcon;
        if (icon instanceof VanillaIcon) {
            icon = new Icon(icon);
        }
        icon = this.vertical ? icon.clip(0, icon.func_94216_b() - length, icon.func_94211_a(), length) : icon.clip(0, 0, length, icon.func_94216_b());
        icon.flip(!this.vertical && this.reversed, this.vertical && this.reversed);
        this.rp.icon.set(icon);
        this.shape.resetState();
        this.shape.setSize(this.vertical ? width : length, this.vertical ? length : height);
        if (this.vertical) {
            this.shape.translate(0, this.reversed ? 0 : height - length);
        } else {
            this.shape.translate(this.reversed ? width - length : 0, 0);
        }
        renderer.drawShape(this.shape, this.rp);
    }
}

