/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.core.block;

import com.google.common.collect.Lists;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Random;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.annotation.Nullable;
import net.malisis.core.MalisisCore;
import net.malisis.core.asm.AsmUtils;
import net.malisis.core.block.BoundingBoxType;
import net.malisis.core.block.IBlockComponent;
import net.malisis.core.block.IBoundingBox;
import net.malisis.core.block.IComponent;
import net.malisis.core.block.IComponentProvider;
import net.malisis.core.block.IRegisterable;
import net.malisis.core.block.component.ITickableComponent;
import net.malisis.core.block.component.LadderComponent;
import net.malisis.core.item.MalisisItemBlock;
import net.malisis.core.renderer.DefaultRenderer;
import net.malisis.core.renderer.MalisisRendered;
import net.malisis.core.renderer.icon.Icon;
import net.minecraft.block.Block;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import org.apache.commons.lang3.StringUtils;

@MalisisRendered(value=DefaultRenderer.Block.class)
public class MalisisBlock
extends Block
implements IBoundingBox,
IRegisterable,
IComponentProvider {
    private static Field blockStateField = AsmUtils.changeFieldAccess(Block.class, "blockState", "field_176227_L");
    protected String name;
    protected AxisAlignedBB boundingBox;
    protected final List<IBlockComponent> blockComponents = Lists.newArrayList();
    protected final List<IComponent> components = Lists.newArrayList();

    protected MalisisBlock(Material material) {
        super(material);
    }

    protected List<IProperty<?>> getProperties() {
        return Lists.newArrayList();
    }

    protected void buildBlockState() {
        List<IProperty<?>> properties = this.getProperties();
        for (IBlockComponent component : this.getBlockComponents()) {
            properties.addAll(Arrays.asList(component.getProperties()));
        }
        try {
            blockStateField.set(this, new BlockStateContainer((Block)this, properties.toArray(new IProperty[0])));
        }
        catch (ReflectiveOperationException e) {
            MalisisCore.log.error("[MalisisBlock] Failed to set the new BlockState for {}.", new Object[]{this.getClass().getSimpleName(), e});
        }
    }

    private void buildDefaultState() {
        IBlockState state = this.field_176227_L.func_177621_b();
        for (IBlockComponent component : this.getBlockComponents()) {
            state = component.setDefaultState(this, state);
        }
        this.func_180632_j(state);
    }

    public List<IBlockComponent> getBlockComponents() {
        return this.blockComponents;
    }

    @Override
    public List<IComponent> getComponents() {
        return Stream.concat(this.blockComponents.stream(), this.components.stream()).collect(Collectors.toList());
    }

    @Override
    public void addComponent(IComponent component) {
        if (component.isClientComponent() && !MalisisCore.isClient()) {
            throw new IllegalStateException("Trying to add component " + component.getClass().getSimpleName() + " on server.");
        }
        if (component instanceof IBlockComponent) {
            this.blockComponents.add((IBlockComponent)component);
            for (IComponent dep : ((IBlockComponent)component).getDependencies()) {
                this.addComponent(dep);
            }
            this.buildBlockState();
            this.buildDefaultState();
        } else {
            this.components.add(component);
        }
        component.onComponentAdded(this);
        this.field_149786_r = this.func_176223_P().func_185914_p() ? 255 : 0;
    }

    public Block setName(String name) {
        this.name = name;
        this.func_149663_c(name);
        return this;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public String getUnlocalizedName(IBlockState state) {
        for (IBlockComponent component : this.getBlockComponents()) {
            String name = component.getUnlocalizedName(this, state);
            if (name == null) continue;
            return name;
        }
        return this.func_149739_a();
    }

    @Override
    public Item getItem(Block block) {
        for (IBlockComponent component : this.getBlockComponents()) {
            Item item = component.getItem(this);
            if (item != null && item.getClass() == MalisisItemBlock.class) continue;
            return item;
        }
        return IRegisterable.super.getItem(this);
    }

    public boolean hasItemSubtypes(Item item) {
        for (IBlockComponent component : this.getBlockComponents()) {
            if (!component.getHasSubtypes(this, item)) continue;
            return true;
        }
        return false;
    }

    public void setTexture(String textureName) {
        if (!StringUtils.isEmpty((CharSequence)textureName) && MalisisCore.isClient()) {
            Icon icon = Icon.from(textureName);
            this.addComponent(() -> icon);
        }
    }

    public void setTexture(Item item) {
        if (item != null && MalisisCore.isClient()) {
            Icon icon = Icon.from(item);
            this.addComponent(() -> icon);
        }
    }

    public void setTexture(Block block) {
        if (block != null) {
            this.setTexture(block.func_176223_P());
        }
    }

    public void setTexture(IBlockState state) {
        if (state != null && MalisisCore.isClient()) {
            Icon icon = Icon.from(state);
            this.addComponent(() -> icon);
        }
    }

    public IBlockState getStateFromItemStack(ItemStack itemStack) {
        return this.func_176203_a(itemStack.func_77973_b().func_77647_b(itemStack.func_77960_j()));
    }

    public void func_176213_c(World world, BlockPos pos, IBlockState state) {
        this.getBlockComponents().forEach(c -> c.onBlockAdded(this, world, pos, state));
    }

    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, EnumHand hand) {
        IBlockState state = super.getStateForPlacement(world, pos, facing, hitX, hitY, hitZ, meta, placer, hand);
        for (IBlockComponent component : this.getBlockComponents()) {
            state = component.getStateForPlacement(this, world, pos, state, facing, hitX, hitY, hitZ, meta, placer, hand);
        }
        return state;
    }

    public void func_180633_a(World world, BlockPos pos, IBlockState state, EntityLivingBase placer, ItemStack stack) {
        this.getBlockComponents().forEach(c -> c.onBlockPlacedBy(this, world, pos, state, placer, stack));
    }

    public boolean func_180639_a(World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        boolean b = false;
        for (IBlockComponent component : this.getBlockComponents()) {
            b |= component.onBlockActivated(this, world, pos, state, player, hand, side, hitX, hitY, hitZ);
        }
        return b;
    }

    public void func_189540_a(IBlockState state, World world, BlockPos pos, Block neighborBlock, BlockPos neighborPos) {
        this.getBlockComponents().forEach(c -> c.onNeighborBlockChange(this, world, pos, state, neighborBlock, neighborPos));
    }

    public boolean func_149744_f(IBlockState state) {
        boolean b = false;
        for (IBlockComponent component : this.getBlockComponents()) {
            b |= component.canProvidePower(this, state);
        }
        return b;
    }

    public void func_180663_b(World world, BlockPos pos, IBlockState state) {
        this.getBlockComponents().forEach(c -> c.breakBlock(this, world, pos, state));
        super.func_180663_b(world, pos, state);
    }

    public void func_180645_a(World world, BlockPos pos, IBlockState state, Random rand) {
        ITickableComponent.RandomTickableComponent rtc = IComponent.getComponent(ITickableComponent.RandomTickableComponent.class, this);
        if (rtc != null) {
            rtc.update(this, world, pos, state, rand);
        }
    }

    public void func_180650_b(World world, BlockPos pos, IBlockState state, Random rand) {
        ITickableComponent.PeriodicTickableComponent ptc = IComponent.getComponent(ITickableComponent.PeriodicTickableComponent.class, this);
        if (ptc == null) {
            return;
        }
        int nextTick = ptc.update(this, world, pos, state, rand);
        if (nextTick > 0) {
            world.func_180497_b(pos, (Block)this, nextTick, nextTick);
        }
    }

    @Override
    public AxisAlignedBB getBoundingBox(IBlockAccess world, BlockPos pos, IBlockState state, BoundingBoxType type) {
        for (IBlockComponent component : this.getBlockComponents()) {
            AxisAlignedBB aabb = component.getBoundingBox(this, world, pos, state, type);
            if (aabb == null) continue;
            return aabb;
        }
        return field_185505_j;
    }

    @Override
    public AxisAlignedBB[] getBoundingBoxes(IBlockAccess world, BlockPos pos, IBlockState state, BoundingBoxType type) {
        ArrayList list = Lists.newArrayList();
        for (IBlockComponent component : this.getBlockComponents()) {
            AxisAlignedBB[] aabbs = component.getBoundingBoxes(this, world, pos, state, type);
            if (aabbs == null) continue;
            list.addAll(Arrays.asList(aabbs));
        }
        return list.size() != 0 ? list.toArray(new AxisAlignedBB[0]) : IBoundingBox.super.getBoundingBoxes(world, pos, state, type);
    }

    public void func_185477_a(IBlockState state, World world, BlockPos pos, AxisAlignedBB mask, List<AxisAlignedBB> list, @Nullable Entity collidingEntity, boolean useActualState) {
        IBoundingBox.super.addCollisionBoxToList(state, world, pos, mask, list, collidingEntity, false);
    }

    public AxisAlignedBB func_180640_a(IBlockState state, World world, BlockPos pos) {
        return IBoundingBox.super.getSelectedBoundingBox(state, world, pos);
    }

    public RayTraceResult func_180636_a(IBlockState state, World world, BlockPos pos, Vec3d src, Vec3d dest) {
        return IBoundingBox.super.collisionRayTrace(state, world, pos, src, dest);
    }

    public boolean func_176198_a(World world, BlockPos pos, EnumFacing side) {
        for (IBlockComponent component : this.getBlockComponents()) {
            if (component.canPlaceBlockOnSide(this, world, pos, side)) continue;
            return false;
        }
        return super.func_176198_a(world, pos, side);
    }

    public boolean func_176196_c(World world, BlockPos pos) {
        for (IBlockComponent component : this.getBlockComponents()) {
            if (component.canPlaceBlockAt(this, world, pos)) continue;
            return false;
        }
        return super.func_176196_c(world, pos);
    }

    public int func_180651_a(IBlockState state) {
        for (IBlockComponent component : this.getBlockComponents()) {
            int damage = component.damageDropped(this, state);
            if (damage == 0) continue;
            return damage;
        }
        return this.func_176201_c(state);
    }

    public void func_149666_a(Item item, CreativeTabs tab, NonNullList<ItemStack> list) {
        NonNullList l = NonNullList.func_191196_a();
        for (IBlockComponent component : this.getBlockComponents()) {
            component.getSubBlocks(this, item, tab, (NonNullList<ItemStack>)l);
        }
        if (l.isEmpty()) {
            super.func_149666_a(item, tab, list);
        } else {
            list.addAll((Collection)l);
        }
    }

    public MapColor func_180659_g(IBlockState state) {
        for (IBlockComponent component : this.getBlockComponents()) {
            MapColor color = component.getMapColor(this, state);
            if (color == null) continue;
            return color;
        }
        return super.func_180659_g(state);
    }

    public IBlockState func_176203_a(int meta) {
        IBlockState state = this.func_176223_P();
        for (IBlockComponent component : this.getBlockComponents()) {
            state = component.getStateFromMeta(this, state, meta);
        }
        return state;
    }

    public int func_176201_c(IBlockState state) {
        int meta = 0;
        for (IBlockComponent component : this.getBlockComponents()) {
            meta += component.getMetaFromState(this, state);
        }
        return meta;
    }

    public boolean func_176225_a(IBlockState state, IBlockAccess world, BlockPos pos, EnumFacing side) {
        for (IBlockComponent component : this.getBlockComponents()) {
            Boolean render = component.shouldSideBeRendered(this, world, pos, state, side);
            if (render == null) continue;
            return render;
        }
        return super.func_176225_a(state, world, pos, side);
    }

    public boolean func_149730_j(IBlockState state) {
        for (IBlockComponent component : this.getBlockComponents()) {
            Boolean full = component.isFullBlock(this, state);
            if (full == null) continue;
            return full;
        }
        return super.func_149730_j(state);
    }

    public boolean func_149686_d(IBlockState state) {
        for (IBlockComponent component : this.getBlockComponents()) {
            Boolean full = component.isFullCube(this, state);
            if (full == null) continue;
            return full;
        }
        return super.func_149686_d(state);
    }

    public boolean func_149662_c(IBlockState state) {
        if (this.getBlockComponents() == null) {
            return super.func_149662_c(state);
        }
        for (IBlockComponent component : this.getBlockComponents()) {
            Boolean opaque = component.isOpaqueCube(this, state);
            if (opaque == null) continue;
            return opaque;
        }
        return super.func_149662_c(state);
    }

    @SideOnly(value=Side.CLIENT)
    public int func_185484_c(IBlockState state, IBlockAccess world, BlockPos pos) {
        for (IBlockComponent component : this.getBlockComponents()) {
            Integer light = component.getPackedLightmapCoords(this, world, pos, state);
            if (light == null) continue;
            return light;
        }
        return super.func_185484_c(state, world, pos);
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        for (IBlockComponent component : this.getBlockComponents()) {
            Item item = component.getItemDropped(this, state, rand, fortune);
            if (item == null) continue;
            return item;
        }
        return super.func_180660_a(state, rand, fortune);
    }

    public int quantityDropped(IBlockState state, int fortune, Random random) {
        for (IBlockComponent component : this.getBlockComponents()) {
            Integer quantity = component.quantityDropped(this, state, fortune, random);
            if (quantity == null) continue;
            return quantity;
        }
        return super.quantityDropped(state, fortune, random);
    }

    public int getLightOpacity(IBlockState state, IBlockAccess world, BlockPos pos) {
        for (IBlockComponent component : this.getBlockComponents()) {
            Integer quantity = component.getLightOpacity(this, world, pos, state);
            if (quantity == null) continue;
            return quantity;
        }
        return super.getLightOpacity(state, world, pos);
    }

    public boolean isLadder(IBlockState state, IBlockAccess world, BlockPos pos, EntityLivingBase entity) {
        return IComponent.getComponent(LadderComponent.class, this) != null;
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.ENTITYBLOCK_ANIMATED;
    }
}

