/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.core.util.modmessage;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.lang.reflect.Parameter;
import java.util.Collection;
import net.malisis.core.IMalisisMod;
import net.malisis.core.MalisisCore;
import net.malisis.core.util.modmessage.ModMessage;
import net.minecraftforge.fml.common.Loader;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.ClassUtils;
import org.apache.commons.lang3.tuple.Pair;

public class ModMessageManager {
    private static Multimap<String, Pair<Object, Method>> messages = HashMultimap.create();

    public static void register(IMalisisMod mod, Class<?> messageHandlerClass) {
        ModMessageManager.register(mod, messageHandlerClass, null);
    }

    public static void register(IMalisisMod mod, Object messageHandler) {
        ModMessageManager.register(mod, messageHandler.getClass(), messageHandler);
    }

    private static void register(IMalisisMod mod, Class<?> messageHandlerClass, Object messageHandler) {
        Method[] methods;
        for (Method method : methods = messageHandler.getClass().getMethods()) {
            ModMessage ann = method.getAnnotation(ModMessage.class);
            if (ann == null) continue;
            String name = ann.value().equals("") ? method.getName() : ann.value();
            boolean isStatic = Modifier.isStatic(method.getModifiers());
            if (!isStatic && messageHandler == null) continue;
            messages.put((Object)(mod.getModId() + ":" + name), (Object)Pair.of((Object)(isStatic ? null : messageHandler), (Object)method));
        }
    }

    public static void message(String modid, String messageName, Object ... data) {
        if (!Loader.isModLoaded((String)modid)) {
            return;
        }
        Collection messageList = messages.get((Object)(modid + ":" + messageName));
        if (messageList.size() == 0) {
            MalisisCore.log.warn("No message handler matching the parameters passed for {}", new Object[]{modid + ":" + messageName});
            return;
        }
        for (Pair message : messageList) {
            if (!ModMessageManager.checkParameters((Method)message.getRight(), data)) continue;
            try {
                ((Method)message.getRight()).invoke(message.getLeft(), data);
            }
            catch (ReflectiveOperationException e) {
                MalisisCore.log.warn("An error happened processing the message :", (Throwable)e);
            }
        }
    }

    private static boolean checkParameters(Method method, Object ... data) {
        Parameter[] parameters = method.getParameters();
        if (ArrayUtils.isEmpty((Object[])data) && parameters.length != 0) {
            return false;
        }
        if (parameters.length != data.length) {
            return false;
        }
        for (int i = 0; i < parameters.length; ++i) {
            Class<?> dataClass;
            Class<?> paramClass = parameters[i].getType();
            if (data[i] == null || ClassUtils.isAssignable(dataClass = data[i].getClass(), paramClass, (boolean)true)) continue;
            return false;
        }
        return true;
    }
}

