/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.core.util.chunkcollision;

import java.util.List;
import net.malisis.core.block.IComponent;
import net.malisis.core.block.component.DirectionalComponent;
import net.malisis.core.registry.AutoLoad;
import net.malisis.core.util.AABBUtils;
import net.malisis.core.util.BlockPosUtils;
import net.malisis.core.util.ItemUtils;
import net.malisis.core.util.MBlockState;
import net.malisis.core.util.Point;
import net.malisis.core.util.callback.CallbackResult;
import net.malisis.core.util.callback.ICallback;
import net.malisis.core.util.chunkblock.ChunkBlockHandler;
import net.malisis.core.util.chunkblock.ChunkCallbackRegistry;
import net.malisis.core.util.chunkcollision.IChunkCollidable;
import net.malisis.core.util.raytrace.Raytrace;
import net.malisis.core.util.raytrace.RaytraceBlock;
import net.malisis.core.util.raytrace.RaytraceChunk;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.tuple.Pair;

@AutoLoad
public class ChunkCollision {
    private static ChunkCollision instance = new ChunkCollision();
    private ChunkCallbackRegistry<ChunkCallbackRegistry.IChunkCallback<Void>, ChunkCallbackRegistry.IChunkCallbackPredicate, Void> collisionRegistry = new ChunkCallbackRegistry();
    private ChunkCallbackRegistry<ChunkCallbackRegistry.IChunkCallback<RayTraceResult>, ChunkCallbackRegistry.IChunkCallbackPredicate, RayTraceResult> rayTraceRegistry = new ChunkCallbackRegistry();
    private ChunkCallbackRegistry<ChunkCallbackRegistry.IChunkCallback<Boolean>, ChunkCallbackRegistry.IChunkCallbackPredicate, Boolean> placeAtRegistry = new ChunkCallbackRegistry();

    public ChunkCollision() {
        this.collisionRegistry.registerCallback(this::collisionBoxesCallback, ICallback.CallbackOption.of(this::isChunkCollidable));
        this.rayTraceRegistry.registerCallback(this::rayTraceCallback, ICallback.CallbackOption.of(this::isChunkCollidable));
        this.placeAtRegistry.registerCallback(this::placeAtCallback, ICallback.CallbackOption.of(this::isChunkCollidable));
    }

    public boolean isChunkCollidable(Chunk chunk, BlockPos listener, Object ... params) {
        return IComponent.getComponent(IChunkCollidable.class, chunk.func_177412_p().func_180495_p(listener).func_177230_c()) != null;
    }

    public void getCollisionBoxes(World world, AxisAlignedBB mask, List<AxisAlignedBB> list, Entity entity) {
        if (mask == null) {
            return;
        }
        for (Chunk chunk : ChunkBlockHandler.getAffectedChunks(world, mask)) {
            this.collisionRegistry.processCallbacks(chunk, new Object[]{mask, list});
        }
    }

    private CallbackResult<Void> collisionBoxesCallback(Chunk chunk, BlockPos listener, Object ... params) {
        AxisAlignedBB[] aabbs;
        IBlockState state = chunk.func_177412_p().func_180495_p(listener);
        IChunkCollidable cc = IComponent.getComponent(IChunkCollidable.class, state.func_177230_c());
        AxisAlignedBB mask = (AxisAlignedBB)params[0];
        List list = (List)params[1];
        for (AxisAlignedBB aabb : aabbs = cc.getCollisionBoundingBoxes(chunk.func_177412_p(), listener, state)) {
            if (aabb == null || !mask.func_72326_a(aabb = AABBUtils.offset(listener, aabb))) continue;
            list.add(aabb);
        }
        return CallbackResult.noResult();
    }

    public Pair<Point, Point> setRayTraceInfos(Vec3d src, Vec3d dest) {
        if (src == null || dest == null) {
            return null;
        }
        return Pair.of((Object)new Point(src), (Object)new Point(dest));
    }

    public RayTraceResult getRayTraceResult(World world, Pair<Point, Point> infos, RayTraceResult result, boolean stopOnLiquid, boolean ignoreBlockWithoutBoundingBox, boolean returnLastUncollidableBlock) {
        if (infos == null) {
            return result;
        }
        RayTraceResult tmp = new RaytraceChunk(world, (Point)infos.getLeft(), (Point)infos.getRight()).trace();
        result = Raytrace.getClosestHit(RayTraceResult.Type.BLOCK, (Point)infos.getLeft(), result, tmp);
        return returnLastUncollidableBlock || result == null || result.field_72313_a == RayTraceResult.Type.BLOCK ? result : null;
    }

    public RayTraceResult processCallbacks(Chunk chunk, Point src, Point dest) {
        this.rayTraceRegistry.reduce((c1, c2) -> CallbackResult.of(Raytrace.getClosestHit(RayTraceResult.Type.BLOCK, src, (RayTraceResult)c1.getValue(), (RayTraceResult)c2.getValue())));
        return this.rayTraceRegistry.processCallbacks(chunk, new Object[]{src, dest}).getValue();
    }

    private CallbackResult<RayTraceResult> rayTraceCallback(Chunk chunk, BlockPos listener, Object ... params) {
        RayTraceResult result = new RaytraceBlock(chunk.func_177412_p(), (Point)params[0], (Point)params[1], listener).trace();
        return result != null ? CallbackResult.of(result) : CallbackResult.noResult();
    }

    public boolean canPlaceBlockAt(EntityPlayer player, World world, Block block, BlockPos pos, EnumHand hand, EnumFacing side) {
        Object[] aabbs;
        ItemStack itemStack = player.func_184586_b(hand);
        if (block instanceof IChunkCollidable) {
            IBlockState state = DirectionalComponent.getPlacedState(ItemUtils.getStateFromItemStack(itemStack), side, (EntityLivingBase)player);
            aabbs = ((IChunkCollidable)block).getPlacedBoundingBox((IBlockAccess)world, pos, state, hand, side, player, itemStack);
        } else {
            aabbs = AABBUtils.getCollisionBoundingBoxes(world, block, pos);
        }
        if (ArrayUtils.isEmpty((Object[])aabbs)) {
            return true;
        }
        AABBUtils.offset(pos, (AxisAlignedBB[])aabbs);
        if (block instanceof IChunkCollidable) {
            for (Object aabb : aabbs) {
                if (aabb == null) continue;
                for (BlockPos p : BlockPosUtils.getAllInBox((AxisAlignedBB)aabb)) {
                    boolean b = false;
                    b |= !world.func_180495_p(p).func_177230_c().func_176200_f((IBlockAccess)world, p);
                    if (!(b &= AABBUtils.isColliding((AxisAlignedBB)aabb, AABBUtils.getCollisionBoundingBoxes(world, new MBlockState((IBlockAccess)world, p), true)))) continue;
                    return false;
                }
            }
        }
        for (Chunk chunk : ChunkBlockHandler.getAffectedChunks(world, (AxisAlignedBB[])aabbs)) {
            CallbackResult<Boolean> result = this.placeAtRegistry.processCallbacks(chunk, aabbs);
            if (result.getValue() == null || result.getValue().booleanValue()) continue;
            return false;
        }
        return true;
    }

    private CallbackResult<Boolean> placeAtCallback(Chunk chunk, BlockPos listener, Object ... params) {
        MBlockState state = new MBlockState((IBlockAccess)chunk.func_177412_p(), listener);
        AxisAlignedBB[] blockBounds = AABBUtils.getCollisionBoundingBoxes(chunk.func_177412_p(), state, true);
        return CallbackResult.of(!AABBUtils.isColliding((AxisAlignedBB[])params, blockBounds));
    }

    public void replaceBlocks(World world, MBlockState state) {
        AxisAlignedBB[] aabbs;
        for (AxisAlignedBB aabb : aabbs = AABBUtils.getCollisionBoundingBoxes(world, state, true)) {
            if (aabb == null) continue;
            for (BlockPos pos : BlockPosUtils.getAllInBox(aabb)) {
                if (!world.func_180495_p(pos).func_177230_c().func_176200_f((IBlockAccess)world, pos)) continue;
                world.func_175698_g(pos);
            }
        }
    }

    public void updateBlocks(World world, MBlockState state) {
        AxisAlignedBB[] aabbs;
        for (AxisAlignedBB aabb : aabbs = AABBUtils.getCollisionBoundingBoxes(world, state, true)) {
            if (aabb == null) continue;
            for (BlockPos pos : BlockPosUtils.getAllInBox(aabb)) {
                world.func_190524_a(pos, state.getBlock(), state.getPos());
            }
        }
    }

    public static ChunkCollision get() {
        return instance;
    }
}

