/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.core.util.cacheddata;

import com.google.common.base.Preconditions;
import java.util.Objects;
import java.util.function.BiPredicate;
import java.util.function.Supplier;
import net.malisis.core.util.cacheddata.ICachedData;

public class CachedData<T>
implements ICachedData {
    protected Supplier<T> getter;
    protected BiPredicate<T, T> predicate;
    protected T lastData;
    protected T currentData;

    public CachedData(Supplier<T> getter, BiPredicate<T, T> predicate) {
        this.getter = (Supplier)Preconditions.checkNotNull(getter);
        this.predicate = (BiPredicate)Preconditions.checkNotNull(predicate);
        this.currentData = getter.get();
        this.update();
    }

    public CachedData(Supplier<T> getter) {
        this(getter, Objects::equals);
    }

    public T get() {
        return this.currentData;
    }

    @Override
    public void update() {
        this.lastData = this.currentData;
        this.currentData = this.getter.get();
    }

    @Override
    public boolean hasChanged() {
        return this.predicate.test(this.lastData, this.currentData);
    }
}

