/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.core.util;

public class Timer {
    private long start;

    public Timer() {
        this.start();
    }

    public Timer(long start) {
        this.setStart(start);
    }

    public void start() {
        this.setStart(System.currentTimeMillis());
    }

    public void setStart(long start) {
        if (start < 0L) {
            this.setRelativeStart(start);
        } else {
            this.start = start;
        }
    }

    public void setRelativeStart(long start) {
        this.setStart(System.currentTimeMillis() + start);
    }

    public long getStart() {
        return this.start;
    }

    public long elapsedTime() {
        return System.currentTimeMillis() - this.start;
    }

    public long elapsedTick() {
        return Timer.timeToTick(System.currentTimeMillis() - this.start);
    }

    public static long timeToTick(long time) {
        return time * 20L / 1000L;
    }

    public static long tickToTime(long ticks) {
        return ticks * 1000L / 20L;
    }

    public String toString() {
        int elapsed = (int)(this.elapsedTime() / 1000L);
        int minutes = elapsed % 3600 / 60;
        int seconds = elapsed % 60;
        return String.format("%02d:%02d", minutes, seconds);
    }
}

