/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.core.util;

import java.util.Iterator;
import net.malisis.core.util.AABBUtils;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;

public class MBlockPos {
    private static final int NUM_X_BITS = 26;
    private static final int NUM_Z_BITS = 26;
    private static final int NUM_Y_BITS = 12;
    private static final int Y_SHIFT = 26;
    private static final int X_SHIFT = 38;
    private static final long X_MASK = 0x3FFFFFFL;
    private static final long Y_MASK = 4095L;
    private static final long Z_MASK = 0x3FFFFFFL;
    protected int x;
    protected int y;
    protected int z;

    public MBlockPos(int x, int y, int z) {
        this.x = x;
        this.y = y;
        this.z = z;
    }

    public MBlockPos(double x, double y, double z) {
        this(MathHelper.func_76128_c((double)x), MathHelper.func_76128_c((double)y), MathHelper.func_76128_c((double)z));
    }

    public int getX() {
        return this.x;
    }

    public int getY() {
        return this.y;
    }

    public int getZ() {
        return this.z;
    }

    public int chunkX() {
        return this.x >> 4;
    }

    public int chunkZ() {
        return this.z >> 4;
    }

    public Block getBlock(World world) {
        return this.getState(world).func_177230_c();
    }

    public IBlockState getState(World world) {
        return world.func_180495_p(this.toBlockPos());
    }

    public MBlockPos add(int x, int y, int z) {
        return new MBlockPos(this.getX() + x, this.getY() + y, this.getZ() + z);
    }

    public MBlockPos add(MBlockPos pos) {
        if (pos == null) {
            return new MBlockPos(this.getX(), this.getY(), this.getZ());
        }
        return this.add(pos.getX(), pos.getY(), pos.getZ());
    }

    public MBlockPos substract(MBlockPos pos) {
        return this.add(-pos.getX(), -pos.getY(), -pos.getZ());
    }

    public MBlockPos up() {
        return this.up(1);
    }

    public MBlockPos up(int n) {
        return this.offset(EnumFacing.UP, n);
    }

    public MBlockPos down() {
        return this.down(1);
    }

    public MBlockPos down(int n) {
        return this.offset(EnumFacing.DOWN, n);
    }

    public MBlockPos north() {
        return this.north(1);
    }

    public MBlockPos north(int n) {
        return this.offset(EnumFacing.NORTH, n);
    }

    public MBlockPos south() {
        return this.south(1);
    }

    public MBlockPos south(int n) {
        return this.offset(EnumFacing.SOUTH, n);
    }

    public MBlockPos west() {
        return this.west(1);
    }

    public MBlockPos west(int n) {
        return this.offset(EnumFacing.WEST, n);
    }

    public MBlockPos east() {
        return this.east(1);
    }

    public MBlockPos east(int n) {
        return this.offset(EnumFacing.EAST, n);
    }

    public MBlockPos offset(EnumFacing facing) {
        return this.offset(facing, 1);
    }

    public MBlockPos offset(EnumFacing facing, int n) {
        return new MBlockPos(this.getX() + facing.func_82601_c() * n, this.getY() + facing.func_96559_d() * n, this.getZ() + facing.func_82599_e() * n);
    }

    public boolean isInRange(MBlockPos pos, int range) {
        double x = pos.x - this.x;
        double y = pos.y - this.y;
        double z = pos.z - this.z;
        return x * x + y * y + z * z <= (double)(range * range);
    }

    public boolean isInside(AxisAlignedBB aabb) {
        return aabb.func_72326_a(AABBUtils.identity(this.toBlockPos()));
    }

    public BlockPos toBlockPos() {
        return new BlockPos(this.x, this.y, this.z);
    }

    public long toLong() {
        return ((long)this.getX() & 0x3FFFFFFL) << 38 | ((long)this.getY() & 0xFFFL) << 26 | ((long)this.getZ() & 0x3FFFFFFL) << 0;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof MBlockPos)) {
            return false;
        }
        MBlockPos pos = (MBlockPos)obj;
        return this.getX() != pos.getX() ? false : (this.getY() != pos.getY() ? false : this.getZ() == pos.getZ());
    }

    public int hashCode() {
        return (this.getY() + this.getZ() * 31) * 31 + this.getX();
    }

    public String toString() {
        return this.x + ", " + this.y + ", " + this.z;
    }

    public static MBlockPos fromLong(long serialized) {
        int j = (int)(serialized << 0 >> 38);
        int k = (int)(serialized << 26 >> 52);
        int l = (int)(serialized << 38 >> 38);
        return new MBlockPos(j, k, l);
    }

    public static MBlockPos minOf(MBlockPos p1, MBlockPos p2) {
        return new MBlockPos(Math.min(p1.getX(), p2.getX()), Math.min(p1.getY(), p2.getY()), Math.min(p1.getZ(), p2.getZ()));
    }

    public static MBlockPos maxOf(MBlockPos p1, MBlockPos p2) {
        return new MBlockPos(Math.max(p1.getX(), p2.getX()), Math.max(p1.getY(), p2.getY()), Math.max(p1.getZ(), p2.getZ()));
    }

    public static Iterable<MBlockPos> getAllInBox(AxisAlignedBB aabb) {
        return MBlockPos.getAllInBox(new MBlockPos(aabb.field_72340_a, aabb.field_72338_b, aabb.field_72339_c), new MBlockPos(Math.ceil(aabb.field_72336_d) - 1.0, Math.ceil(aabb.field_72337_e) - 1.0, Math.ceil(aabb.field_72334_f) - 1.0));
    }

    public static Iterable<MBlockPos> getAllInBox(MBlockPos from, MBlockPos to) {
        return new BlockIterator(from, to).asIterable();
    }

    public static class BlockIterator
    implements Iterator<MBlockPos> {
        private MBlockPos from;
        private MBlockPos to;
        private int x;
        private int y;
        private int z;

        public BlockIterator(MBlockPos from, MBlockPos to) {
            this.from = MBlockPos.minOf(from, to);
            this.to = MBlockPos.maxOf(from, to);
            this.x = from.getX();
            this.y = from.getY();
            this.z = from.getZ();
        }

        @Override
        public boolean hasNext() {
            return this.x <= this.to.getX() && this.y <= this.to.getY() && this.z <= this.to.getZ();
        }

        @Override
        public MBlockPos next() {
            MBlockPos retVal = this.hasNext() ? new MBlockPos(this.x, this.y, this.z) : null;
            ++this.x;
            if (this.x > this.to.getX()) {
                this.x = this.from.getX();
                ++this.y;
                if (this.y > this.to.getY()) {
                    this.y = this.from.getY();
                    ++this.z;
                }
            }
            return retVal;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        public Iterable<MBlockPos> asIterable() {
            return new Iterable<MBlockPos>(){

                @Override
                public Iterator<MBlockPos> iterator() {
                    return this;
                }
            };
        }
    }
}

