/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.core.renderer.icon;

import net.malisis.core.MalisisCore;
import net.malisis.core.renderer.icon.Icon;
import net.malisis.core.renderer.icon.ProxyIcon;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureMap;
import net.minecraft.item.Item;

public class VanillaIcon
extends ProxyIcon {
    protected Item item;
    protected IBlockState blockState;
    protected int metadata;

    VanillaIcon(String name) {
        super(name);
    }

    VanillaIcon(IBlockState blockState) {
        super(blockState.func_177230_c().getRegistryName().toString());
        this.blockState = blockState;
    }

    VanillaIcon(Block block) {
        this(block.func_176223_P());
    }

    VanillaIcon(Item item, int metadata) {
        super(item.getRegistryName().toString());
        this.item = item;
        this.metadata = metadata;
    }

    VanillaIcon(Item item) {
        this(item, 0);
    }

    @Override
    public TextureAtlasSprite getIcon() {
        if (this.proxy == null) {
            this.resolveIcon(Minecraft.func_71410_x().func_147117_R());
        }
        return super.getIcon();
    }

    @Override
    public void register(TextureMap map) {
        this.setProxy(null);
        if (this.blockState != null && this.item != null) {
            MalisisCore.log.error("[VanillaIcon] Tried to register an icon set for {}.", new Object[]{this.func_94215_i()});
            return;
        }
        TextureAtlasSprite icon = map.func_110572_b(this.func_94215_i());
        if (icon == map.func_174944_f()) {
            icon = new Icon(this.func_94215_i());
            map.setTextureEntry(icon);
        }
    }

    public void resolveIcon(TextureMap map) {
        TextureAtlasSprite icon = null;
        icon = this.item != null ? this.getItemIcon() : (this.blockState != null ? this.getBlockIcon() : map.func_110572_b(this.func_94215_i()));
        if (icon != null) {
            this.setProxy(icon);
        }
    }

    private TextureAtlasSprite getItemIcon() {
        if (Minecraft.func_71410_x().func_175599_af() == null) {
            return null;
        }
        return Minecraft.func_71410_x().func_175599_af().func_175037_a().func_178087_a(this.item, this.metadata);
    }

    private TextureAtlasSprite getBlockIcon() {
        if (this.blockState == null) {
            return null;
        }
        return Minecraft.func_71410_x().func_175602_ab().func_175023_a().func_178122_a(this.blockState);
    }

    @Override
    public String toString() {
        return "VanillaIcon [" + this.getIcon() + "]";
    }
}

