/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.core.item;

import com.google.common.collect.Lists;
import java.util.List;
import net.malisis.core.MalisisCore;
import net.malisis.core.block.IComponent;
import net.malisis.core.block.IComponentProvider;
import net.malisis.core.block.IRegisterable;
import net.malisis.core.renderer.DefaultRenderer;
import net.malisis.core.renderer.MalisisRendered;
import net.malisis.core.renderer.icon.Icon;
import net.malisis.core.renderer.icon.provider.IIconProvider;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.Item;
import org.apache.commons.lang3.StringUtils;

@MalisisRendered(value=DefaultRenderer.Item.class)
public class MalisisItem
extends Item
implements IComponentProvider,
IRegisterable {
    protected String name;
    protected final List<IComponent> components = Lists.newArrayList();

    public MalisisItem setName(String name) {
        this.name = name;
        this.func_77655_b(name);
        return this;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void addComponent(IComponent component) {
        this.components.add(component);
    }

    @Override
    public List<IComponent> getComponents() {
        return this.components;
    }

    public void setTexture(String textureName) {
        if (!StringUtils.isEmpty((CharSequence)textureName) && MalisisCore.isClient()) {
            this.addComponent(IIconProvider.create(textureName).build());
        }
    }

    public void setTexture(Item item) {
        if (item != null && MalisisCore.isClient()) {
            this.addComponent(IIconProvider.create(Icon.from(item)).build());
        }
    }

    public void setTexture(Block block) {
        if (block != null) {
            this.setTexture(block.func_176223_P());
        }
    }

    public void setTexture(IBlockState state) {
        if (state != null && MalisisCore.isClient()) {
            this.addComponent(IIconProvider.create(Icon.from(state)).build());
        }
    }
}

