/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.core.renderer.element;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.malisis.core.renderer.RenderParameters;
import net.malisis.core.renderer.animation.transformation.ITransformable;
import net.malisis.core.renderer.element.Vertex;
import net.malisis.core.renderer.icon.Icon;
import net.malisis.core.util.Vector;
import net.minecraft.util.EnumFacing;

public class Face
implements ITransformable.Translate,
ITransformable.Rotate {
    protected String name;
    protected Vertex[] vertexes;
    protected RenderParameters params;

    public Face(Vertex[] vertexes, RenderParameters params) {
        this.vertexes = vertexes;
        this.params = params != null ? params : new RenderParameters();
        this.setName(null);
    }

    public Face(Vertex ... vertexes) {
        this(vertexes, (RenderParameters)null);
    }

    public Face(List<Vertex> vertexes) {
        this(vertexes.toArray(new Vertex[0]), (RenderParameters)null);
    }

    public Face(Face face) {
        this(face, new RenderParameters(face.params));
    }

    public Face(Face face, RenderParameters params) {
        Vertex[] faceVertexes = face.getVertexes();
        this.vertexes = new Vertex[faceVertexes.length];
        for (int i = 0; i < faceVertexes.length; ++i) {
            this.vertexes[i] = new Vertex(faceVertexes[i]);
        }
        this.params = params != null ? params : new RenderParameters();
        this.name = face.name;
    }

    public void setName(String name) {
        if (name == null) {
            String[] dirs;
            name = "";
            HashMap<String, Integer> map = new HashMap<String, Integer>();
            for (String dir : dirs = new String[]{"North", "South", "East", "West", "Top", "Bottom"}) {
                map.put(dir, 0);
                for (Vertex v : this.vertexes) {
                    if (!v.name().contains(dir)) continue;
                    map.put(dir, (Integer)map.get(dir) + 1);
                }
                if ((Integer)map.get(dir) != 4) continue;
                name = dir;
            }
        }
        this.name = name;
    }

    public String name() {
        return this.name;
    }

    public Vertex[] getVertexes() {
        return this.vertexes;
    }

    public List<Vertex> getVertexes(String name) {
        ArrayList<Vertex> vertexes = new ArrayList<Vertex>();
        for (Vertex v : this.getVertexes()) {
            if (!v.baseName().toLowerCase().contains(name.toLowerCase())) continue;
            vertexes.add(v);
        }
        return vertexes;
    }

    public Face setParameters(RenderParameters params) {
        this.params = params != null ? params : new RenderParameters();
        return this;
    }

    public RenderParameters getParameters() {
        return this.params;
    }

    public Face setColor(int color) {
        for (Vertex v : this.vertexes) {
            v.setColor(color);
        }
        return this;
    }

    public Face setAlpha(int alpha) {
        for (Vertex v : this.vertexes) {
            v.setAlpha(alpha);
        }
        return this;
    }

    public Face setBrightness(int brightness) {
        for (Vertex v : this.vertexes) {
            v.setBrightness(brightness);
        }
        return this;
    }

    public Face setStandardUV() {
        if (this.vertexes.length != 4) {
            return this;
        }
        this.vertexes[0].setUV(0.0, 0.0);
        this.vertexes[1].setUV(0.0, 1.0);
        this.vertexes[2].setUV(1.0, 1.0);
        this.vertexes[3].setUV(1.0, 0.0);
        return this;
    }

    public Face interpolateUV() {
        return this.setTexture(null, false, false, true);
    }

    public Face setTexture(Icon icon) {
        return this.setTexture(icon, this.params.flipU.get(), this.params.flipV.get(), false);
    }

    public Face setTexture(Icon icon, boolean flippedU, boolean flippedV, boolean interpolate) {
        int[] cos = new int[]{1, 0, -1, 0};
        int[] sin = new int[]{0, 1, 0, -1};
        float u = 0.0f;
        float v = 0.0f;
        float U = 1.0f;
        float V = 1.0f;
        int rotation = 0;
        if (icon != null) {
            u = icon.func_94209_e();
            v = icon.func_94206_g();
            U = icon.func_94212_f();
            V = icon.func_94210_h();
            rotation = icon.getRotation();
        }
        int a = -rotation & 3;
        int s = sin[a];
        int c = cos[a];
        for (Vertex vertex : this.vertexes) {
            double factorU = interpolate ? this.getFactorU(vertex) : vertex.getU();
            double factorV = interpolate ? this.getFactorV(vertex) : vertex.getV();
            double newU = (double)c * (factorU - 0.5) - (double)s * (factorV - 0.5) + 0.5;
            double newV = (double)s * (factorU - 0.5) + (double)c * (factorV - 0.5) + 0.5;
            newU = this.interpolate(u, U, newU, flippedU);
            newV = this.interpolate(v, V, newV, flippedV);
            vertex.setUV(newU, newV);
        }
        return this;
    }

    private double getFactorU(Vertex vertex) {
        if (this.params.direction.get() == null) {
            return vertex.getU();
        }
        switch (this.params.direction.get()) {
            case EAST: 
            case WEST: {
                return vertex.getZ();
            }
            case NORTH: 
            case SOUTH: 
            case UP: 
            case DOWN: {
                return vertex.getX();
            }
        }
        return 0.0;
    }

    private double getFactorV(Vertex vertex) {
        if (this.params.direction.get() == null) {
            return vertex.getV();
        }
        switch (this.params.direction.get()) {
            case EAST: 
            case WEST: 
            case NORTH: 
            case SOUTH: {
                return 1.0 - vertex.getY();
            }
            case UP: 
            case DOWN: {
                return vertex.getZ();
            }
        }
        return 0.0;
    }

    private float interpolate(float min, float max, double factor, boolean flipped) {
        if (factor > 1.0) {
            factor = 1.0;
        }
        if (factor < 0.0) {
            factor = 0.0;
        }
        if (flipped) {
            factor = 1.0 - factor;
        }
        return min + (max - min) * (float)factor;
    }

    @Override
    public void translate(float x, float y, float z) {
        for (Vertex v : this.vertexes) {
            v.translate(x, y, z);
        }
    }

    public void scale(float f) {
        this.scale(f, f, f, 0.0f, 0.0f, 0.0f);
    }

    public void scale(float f, float offset) {
        this.scale(f, f, f, offset, offset, offset);
    }

    public void scale(float fx, float fy, float fz) {
        this.scale(fx, fy, fz, 0.0f, 0.0f, 0.0f);
    }

    public void scale(float fx, float fy, float fz, float offsetX, float offsetY, float offsetZ) {
        for (Vertex v : this.vertexes) {
            v.scale(fx, fy, fz, offsetX, offsetY, offsetZ);
        }
    }

    @Override
    public void rotate(float angle, float x, float y, float z, float offsetX, float offsetY, float offsetZ) {
        this.rotateAroundX(angle * x, offsetX, offsetY, offsetZ);
        this.rotateAroundY(angle * y, offsetX, offsetY, offsetZ);
        this.rotateAroundZ(angle * z, offsetX, offsetY, offsetZ);
    }

    public void rotateAroundX(double angle) {
        this.rotateAroundX(angle, 0.5, 0.5, 0.5);
    }

    public void rotateAroundX(double angle, double centerX, double centerY, double centerZ) {
        for (Vertex v : this.vertexes) {
            v.rotateAroundX(angle, centerX, centerY, centerZ);
        }
    }

    public void rotateAroundY(double angle) {
        this.rotateAroundY(angle, 0.5, 0.5, 0.5);
    }

    public void rotateAroundY(double angle, double centerX, double centerY, double centerZ) {
        for (Vertex v : this.vertexes) {
            v.rotateAroundY(angle, centerX, centerY, centerZ);
        }
    }

    public void rotateAroundZ(double angle) {
        this.rotateAroundZ(angle, 0.5, 0.5, 0.5);
    }

    public void rotateAroundZ(double angle, double centerX, double centerY, double centerZ) {
        for (Vertex v : this.vertexes) {
            v.rotateAroundZ(angle, centerX, centerY, centerZ);
        }
    }

    public int[][][] calculateAoMatrix(EnumFacing offset) {
        int[][][] aoMatrix = new int[this.vertexes.length][3][3];
        for (int i = 0; i < this.vertexes.length; ++i) {
            aoMatrix[i] = this.vertexes[i].getAoMatrix(offset);
        }
        return aoMatrix;
    }

    public Vector[] getVertexNormals() {
        Vector[] normals = new Vector[this.vertexes.length];
        int i = 0;
        for (Vertex v : this.vertexes) {
            normals[i++] = new Vector(v.getX(), v.getY(), v.getZ());
        }
        return normals;
    }

    public void calculateNormal() {
        this.calculateNormal(this.getVertexNormals());
    }

    public Vector calculateNormal(Vector[] normals) {
        if (normals == null || normals.length != this.vertexes.length) {
            normals = this.getVertexNormals();
        }
        double x = 0.0;
        double y = 0.0;
        double z = 0.0;
        for (int i = 0; i < this.vertexes.length; ++i) {
            Vertex current = this.vertexes[i];
            Vertex next = this.vertexes[(i + 1) % this.vertexes.length];
            x += (current.getY() - next.getY()) * (current.getZ() + next.getZ());
            y += (current.getZ() - next.getZ()) * (current.getX() + next.getX());
            z += (current.getX() - next.getX()) * (current.getY() + next.getY());
        }
        int factor = 1000;
        Vector normal = new Vector((float)Math.round(x * (double)factor) / (float)factor, (float)Math.round(y * (double)factor) / (float)factor, (float)Math.round(z * (double)factor) / (float)factor);
        normal.normalize();
        return normal;
    }

    public void deductParameters() {
        this.deductParameters(this.getVertexNormals());
    }

    public void deductParameters(Vector[] normals) {
        Vector normal = this.calculateNormal(normals);
        EnumFacing dir = null;
        if (normal.x == 0.0 && normal.y == 0.0) {
            if (normal.z == 1.0) {
                dir = EnumFacing.SOUTH;
            } else if (normal.z == -1.0) {
                dir = EnumFacing.NORTH;
            }
        } else if (normal.x == 0.0 && normal.z == 0.0) {
            if (normal.y == 1.0) {
                dir = EnumFacing.UP;
            } else if (normal.y == -1.0) {
                dir = EnumFacing.DOWN;
            }
        } else if (normal.y == 0.0 && normal.z == 0.0) {
            if (normal.x == 1.0) {
                dir = EnumFacing.EAST;
            } else if (normal.x == -1.0) {
                dir = EnumFacing.WEST;
            }
        }
        this.params.direction.set(dir);
        this.params.textureSide.set(dir);
        this.params.aoMatrix.set(this.calculateAoMatrix(dir));
        float f = (float)(normal.x * normal.x * 0.6 + normal.y * (normal.y * 3.0 + 1.0) / 4.0 + normal.z * normal.z * 0.8);
        this.params.colorFactor.set(Float.valueOf(f));
    }

    public String toString() {
        String s = this.name() + " {";
        for (Vertex v : this.vertexes) {
            s = s + v.name() + ", ";
        }
        return s + "}";
    }

    public static String nameFromDirection(EnumFacing dir) {
        if (dir == EnumFacing.UP) {
            return "top";
        }
        if (dir == EnumFacing.DOWN) {
            return "bottom";
        }
        return dir.toString();
    }
}

