/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.core.renderer.animation.transformation;

import java.util.List;
import net.malisis.core.renderer.animation.transformation.ITransformable;
import net.malisis.core.util.Timer;

public abstract class Transformation<T extends Transformation<T, S>, S extends ITransformable> {
    public static final int LINEAR = 0;
    public static final int SINUSOIDAL = 1;
    protected int movement = 0;
    protected long duration = 0L;
    protected long delay = 0L;
    protected int loops = 1;
    protected long loopStartDelay = 0L;
    protected long loopResetDelay = 0L;
    protected long elapsedTimeCurrentLoop;
    protected boolean reversed = false;

    public T movement(int movement) {
        this.movement = movement;
        return this.self();
    }

    public T delay(int delay) {
        this.delay = Timer.tickToTime(delay);
        return this.self();
    }

    public T forTicks(int duration) {
        this.duration = Timer.tickToTime(duration);
        return this.self();
    }

    public T forTicks(int duration, int delay) {
        this.duration = Timer.tickToTime(duration);
        this.delay = Timer.tickToTime(delay);
        return this.self();
    }

    public long getDuration() {
        return this.duration;
    }

    public long getDelay() {
        return this.delay;
    }

    public int getLoops() {
        return this.loops;
    }

    public long totalDuration() {
        if (this.loops == -1) {
            return Integer.MAX_VALUE;
        }
        return this.delay + (long)this.loops * this.getLoopDuration();
    }

    public long getLoopDuration() {
        return this.duration + this.loopStartDelay + this.loopResetDelay;
    }

    public T loop(int loops) {
        return this.loop(loops, 0, 0);
    }

    public T loop(int loops, int startDelay, int resetDelay) {
        if (loops == 0) {
            return this.self();
        }
        this.loops = loops;
        this.loopStartDelay = startDelay;
        this.loopResetDelay = resetDelay;
        return this.self();
    }

    public T reversed(boolean reversed) {
        this.reversed = reversed;
        return this.self();
    }

    public void transform(List<S> transformables, long elapsedTime) {
        for (ITransformable transformable : transformables) {
            this.transform(transformable, elapsedTime);
        }
    }

    public void transform(S transformable, long elapsedTime) {
        this.doTransform(transformable, this.completion(Math.max(0L, elapsedTime)));
    }

    protected float completion(long elapsedTime) {
        if (this.duration == 0L) {
            return 0.0f;
        }
        float comp = 0.0f;
        long loopDuration = this.getLoopDuration();
        this.elapsedTimeCurrentLoop = elapsedTime - this.delay;
        if (this.loops != -1 && this.elapsedTimeCurrentLoop > (long)this.loops * loopDuration) {
            return 1.0f;
        }
        if (this.loops != 1) {
            this.elapsedTimeCurrentLoop %= loopDuration;
            if (this.elapsedTimeCurrentLoop < this.loopStartDelay) {
                return 0.0f;
            }
            if (this.elapsedTimeCurrentLoop - this.loopResetDelay > loopDuration) {
                return 1.0f;
            }
            this.elapsedTimeCurrentLoop -= this.loopStartDelay;
        }
        comp = Math.min((float)this.elapsedTimeCurrentLoop / (float)this.duration, 1.0f);
        comp = Math.max(0.0f, Math.min(1.0f, comp));
        if (this.movement == 1) {
            comp = (float)(1.0 - Math.cos((double)comp * Math.PI)) / 2.0f;
        }
        return comp;
    }

    public abstract T self();

    protected abstract void doTransform(S var1, float var2);
}

