/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.core.client.gui.component.container;

import com.google.common.eventbus.Subscribe;
import java.util.LinkedHashSet;
import java.util.Set;
import net.malisis.core.client.gui.Anchor;
import net.malisis.core.client.gui.ClipArea;
import net.malisis.core.client.gui.GuiRenderer;
import net.malisis.core.client.gui.MalisisGui;
import net.malisis.core.client.gui.component.IClipable;
import net.malisis.core.client.gui.component.UIComponent;
import net.malisis.core.client.gui.component.control.ICloseable;
import net.malisis.core.client.gui.component.control.IControlComponent;
import net.malisis.core.client.gui.component.control.IScrollable;
import net.malisis.core.client.gui.component.decoration.UILabel;
import net.malisis.core.client.gui.event.component.ContentUpdateEvent;
import net.malisis.core.client.gui.event.component.SpaceChangeEvent;
import net.malisis.core.client.gui.event.component.StateChangeEvent;
import net.minecraft.client.gui.GuiScreen;
import org.apache.commons.lang3.StringUtils;

public class UIContainer<T extends UIContainer<T>>
extends UIComponent<T>
implements IClipable,
IScrollable,
ICloseable {
    protected final Set<UIComponent<?>> components = new LinkedHashSet();
    protected int horizontalPadding;
    protected int verticalPadding;
    protected UILabel titleLabel;
    protected boolean clipContent = true;
    protected int contentWidth;
    protected int contentHeight;
    protected int xOffset;
    protected int yOffset;

    public UIContainer(MalisisGui gui) {
        super(gui);
        this.titleLabel = new UILabel(gui);
    }

    public UIContainer(MalisisGui gui, String title) {
        this(gui);
        this.setTitle(title);
    }

    public UIContainer(MalisisGui gui, int width, int height) {
        this(gui);
        this.setSize(width, height);
    }

    public UIContainer(MalisisGui gui, String title, int width, int height) {
        this(gui);
        this.setTitle(title);
        this.setSize(width, height);
    }

    @Override
    public T setVisible(boolean visible) {
        if (this.isVisible() == visible) {
            return (T)((UIContainer)this.self());
        }
        super.setVisible(visible);
        if (!visible) {
            for (UIComponent<?> c : this.components) {
                c.setHovered(false);
                c.setFocused(false);
            }
        }
        return (T)((UIContainer)this.self());
    }

    @Override
    public T setDisabled(boolean disabled) {
        super.setDisabled(disabled);
        if (disabled) {
            for (UIComponent<?> c : this.components) {
                c.setHovered(false);
                c.setFocused(false);
            }
        }
        return (T)((UIContainer)this.self());
    }

    public void setPadding(int horizontal, int vertical) {
        this.horizontalPadding = horizontal;
        this.verticalPadding = vertical;
    }

    @Override
    public int getHorizontalPadding() {
        return this.horizontalPadding;
    }

    @Override
    public int getVerticalPadding() {
        return this.verticalPadding;
    }

    public T setTitle(String title) {
        if (title == null || title == "") {
            this.remove(this.titleLabel);
            return (T)((UIContainer)this.self());
        }
        this.titleLabel.setText(title);
        this.add(this.titleLabel);
        return (T)((UIContainer)this.self());
    }

    public String getTitle() {
        return this.titleLabel != null ? this.titleLabel.getText() : null;
    }

    @Override
    public int componentX(UIComponent<?> component) {
        int x = super.componentX(component);
        int a = Anchor.horizontal(component.getAnchor());
        if (a == Anchor.LEFT || a == Anchor.NONE) {
            x += this.getHorizontalPadding();
        } else if (a == Anchor.RIGHT) {
            x -= this.getHorizontalPadding();
        }
        if (!(component instanceof IControlComponent)) {
            x -= this.xOffset;
        }
        return x;
    }

    @Override
    public int componentY(UIComponent<?> component) {
        int y = super.componentY(component);
        int a = Anchor.vertical(component.getAnchor());
        if (a == Anchor.TOP || a == Anchor.NONE) {
            y += this.getVerticalPadding();
        } else if (a == Anchor.BOTTOM) {
            y -= this.getVerticalPadding();
        }
        if (!(component instanceof IControlComponent)) {
            y -= this.yOffset;
        }
        return y;
    }

    public UIComponent<?> getComponent(String name) {
        return this.getComponent(name, false);
    }

    public UIComponent<?> getComponent(String name, boolean recursive) {
        if (StringUtils.isEmpty((CharSequence)name)) {
            return null;
        }
        for (UIComponent<?> c : this.components) {
            if (!name.equals(c.getName())) continue;
            return c;
        }
        if (!recursive) {
            return null;
        }
        for (UIComponent<?> c : this.components) {
            UIComponent<?> found;
            if (!(c instanceof UIContainer) || (found = this.getComponent(name, true)) == null) continue;
            return found;
        }
        return null;
    }

    @Override
    public UIComponent<?> getComponentAt(int x, int y) {
        UIComponent<?> superComp = super.getComponentAt(x, y);
        if (superComp != null && superComp != this) {
            return superComp;
        }
        if (this.isDisabled() || !this.isVisible()) {
            return null;
        }
        LinkedHashSet list = new LinkedHashSet();
        for (UIComponent<?> c : this.components) {
            UIComponent<?> uIComponent = c.getComponentAt(x, y);
            if (uIComponent == null) continue;
            list.add(uIComponent);
        }
        if (list.size() == 0) {
            return superComp;
        }
        UIComponent component = null;
        for (UIComponent uIComponent : list) {
            if (component != null && component.getZIndex() > uIComponent.getZIndex()) continue;
            component = uIComponent;
        }
        if (component instanceof IClipable && ((IClipable)((Object)component)).shouldClipContent()) {
            return component;
        }
        if (this.clipContent && !this.getClipArea().isInside(x, y)) {
            return null;
        }
        return component;
    }

    public void onContentUpdate() {
        this.calculateContentSize();
        this.fireEvent(new ContentUpdateEvent(this.self()));
    }

    public void calculateContentSize() {
        int contentWidth = 0;
        int contentHeight = 0;
        for (UIComponent<?> c : this.components) {
            if (!c.isVisible()) continue;
            contentWidth = Math.max(contentWidth, c.parentX() + c.getWidth() + this.xOffset);
            contentHeight = Math.max(contentHeight, c.parentY() + c.getHeight() + this.yOffset);
        }
        this.contentHeight = contentHeight + 2 * this.getVerticalPadding();
        this.contentWidth = contentWidth + 2 * this.getHorizontalPadding();
    }

    @Override
    public ClipArea getClipArea() {
        return new ClipArea(this);
    }

    @Override
    public void setClipContent(boolean clipContent) {
        this.clipContent = clipContent;
    }

    @Override
    public boolean shouldClipContent() {
        return this.clipContent;
    }

    @Override
    public int getContentWidth() {
        return this.contentWidth;
    }

    @Override
    public int getContentHeight() {
        return this.contentHeight;
    }

    @Override
    public float getOffsetX() {
        return this.xOffset;
    }

    @Override
    public void setOffsetX(float offsetX, int delta) {
        this.xOffset = (int)((float)(this.getContentWidth() - this.getWidth() + delta) * offsetX);
    }

    @Override
    public float getOffsetY() {
        return (float)this.yOffset / (float)(this.getContentHeight() - this.getHeight());
    }

    @Override
    public void setOffsetY(float offsetY, int delta) {
        this.yOffset = (int)((float)(this.getContentHeight() - this.getHeight() + delta) * offsetY);
    }

    @Override
    public float getScrollStep() {
        return GuiScreen.func_146271_m() ? 0.125f : 0.025f;
    }

    public void add(UIComponent<?> ... components) {
        for (UIComponent<?> component : components) {
            if (component == null) continue;
            this.components.add(component);
            component.setParent(this);
            component.register(this);
        }
        this.onContentUpdate();
    }

    public void remove(UIComponent<?> component) {
        if (component.getParent() != this) {
            return;
        }
        this.components.remove(component);
        component.setParent(null);
        component.unregister(this);
        this.onContentUpdate();
    }

    public void removeAll() {
        for (UIComponent<?> component : this.components) {
            component.setParent(null);
        }
        this.components.clear();
        this.onContentUpdate();
    }

    @Override
    public void onAddedToScreen() {
        super.onAddedToScreen();
        for (UIComponent<?> component : this.components) {
            component.onAddedToScreen();
        }
    }

    @Override
    public void onClose() {
        if (this.getParent() instanceof UIContainer) {
            ((UIContainer)this.getParent()).remove(this);
        }
    }

    @Override
    public void drawBackground(GuiRenderer renderer, int mouseX, int mouseY, float partialTick) {
    }

    @Override
    public void drawForeground(GuiRenderer renderer, int mouseX, int mouseY, float partialTick) {
        for (UIComponent<?> c : this.components) {
            c.draw(renderer, mouseX, mouseY, partialTick);
        }
    }

    @Subscribe
    public void onComponentStateChange(StateChangeEvent.VisibleStateChange<T> event) {
        this.onContentUpdate();
    }

    @Subscribe
    public void onComponentSpaceChange(SpaceChangeEvent<T> event) {
        this.onContentUpdate();
    }
}

