/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.core.block.component;

import net.malisis.core.block.IBlockComponent;
import net.malisis.core.block.IComponent;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class PowerComponent
implements IBlockComponent {
    public static PropertyBool POWER = PropertyBool.func_177716_a((String)"power");
    private final Type type;

    public PowerComponent(Type type) {
        this.type = type;
    }

    public PropertyBool getProperty() {
        return POWER;
    }

    @Override
    public IBlockState setDefaultState(Block block, IBlockState state) {
        return state.func_177226_a((IProperty)this.getProperty(), (Comparable)Boolean.valueOf(false));
    }

    @Override
    public boolean onBlockActivated(Block block, World world, BlockPos pos, IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (this.type == Type.REDSTONE) {
            return false;
        }
        boolean isPowered = PowerComponent.isPowered(state);
        world.func_175656_a(pos, state.func_177226_a((IProperty)this.getProperty(), (Comparable)Boolean.valueOf(!isPowered)));
        return true;
    }

    @Override
    public void onNeighborBlockChange(Block block, World world, BlockPos pos, IBlockState state, Block neighborBlock) {
        if (this.type == Type.RIGHT_CLICK) {
            return;
        }
        boolean isPowered = PowerComponent.isRemotelyPowered(world, pos);
        world.func_175656_a(pos, state.func_177226_a((IProperty)this.getProperty(), (Comparable)Boolean.valueOf(isPowered)));
    }

    @Override
    public IBlockState getStateFromMeta(Block block, IBlockState state, int meta) {
        return state.func_177226_a((IProperty)this.getProperty(), (Comparable)Boolean.valueOf((meta & 8) != 0));
    }

    @Override
    public int getMetaFromState(Block block, IBlockState state) {
        return PowerComponent.isPowered(state) ? 8 : 0;
    }

    public static boolean isPowered(IBlockAccess world, BlockPos pos) {
        return world != null ? PowerComponent.isPowered(world.func_180495_p(pos)) : false;
    }

    public static boolean isPowered(IBlockState state) {
        PowerComponent pc = IComponent.getComponent(PowerComponent.class, state.func_177230_c());
        if (pc == null) {
            return false;
        }
        PropertyBool property = pc.getProperty();
        if (property == null || !state.func_177228_b().containsKey((Object)property)) {
            return false;
        }
        return (Boolean)state.func_177229_b((IProperty)property);
    }

    public static boolean isRemotelyPowered(World world, BlockPos pos) {
        return PowerComponent.isRemotelyPowered(world, pos, true);
    }

    public static boolean isRemotelyPowered(World world, BlockPos pos, boolean strongPower) {
        boolean powered;
        boolean bl = powered = world.func_175687_A(pos) != 0;
        if (powered || !strongPower) {
            return powered;
        }
        for (EnumFacing side : EnumFacing.field_82609_l) {
            if (world.func_175687_A(pos.func_177972_a(side)) == 0) continue;
            return true;
        }
        return false;
    }

    public static PropertyBool getProperty(Block block) {
        PowerComponent pc = IComponent.getComponent(PowerComponent.class, block);
        return pc != null ? pc.getProperty() : null;
    }

    public static enum Type {
        RIGHT_CLICK,
        REDSTONE;

    }
}

