/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.core.block.component;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import net.malisis.core.block.BoundingBoxType;
import net.malisis.core.block.IBlockComponent;
import net.malisis.core.block.ISmartCull;
import net.minecraft.block.Block;
import net.minecraft.block.BlockPane;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;

public class PaneComponent
implements IBlockComponent,
ISmartCull {
    public static final PropertyBool NORTH = BlockPane.field_176241_b;
    public static final PropertyBool EAST = BlockPane.field_176242_M;
    public static final PropertyBool SOUTH = BlockPane.field_176243_N;
    public static final PropertyBool WEST = BlockPane.field_176244_O;

    @Override
    public IProperty<?> getProperty() {
        return null;
    }

    @Override
    public IProperty<?>[] getProperties() {
        return new IProperty[]{NORTH, EAST, SOUTH, WEST};
    }

    @Override
    public IBlockState setDefaultState(Block block, IBlockState state) {
        return state.func_177226_a((IProperty)NORTH, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)EAST, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)SOUTH, (Comparable)Boolean.valueOf(false)).func_177226_a((IProperty)WEST, (Comparable)Boolean.valueOf(false));
    }

    public IBlockState getFullState(Block block, IBlockAccess world, BlockPos pos) {
        IBlockState state = world.func_180495_p(pos);
        if (state.func_177230_c() != block) {
            return block.func_176223_P();
        }
        return state.func_177226_a((IProperty)NORTH, (Comparable)Boolean.valueOf(this.canPaneConnectTo(block, world, pos, EnumFacing.NORTH))).func_177226_a((IProperty)SOUTH, (Comparable)Boolean.valueOf(this.canPaneConnectTo(block, world, pos, EnumFacing.SOUTH))).func_177226_a((IProperty)WEST, (Comparable)Boolean.valueOf(this.canPaneConnectTo(block, world, pos, EnumFacing.WEST))).func_177226_a((IProperty)EAST, (Comparable)Boolean.valueOf(this.canPaneConnectTo(block, world, pos, EnumFacing.EAST)));
    }

    @Override
    public AxisAlignedBB[] getBoundingBoxes(Block block, IBlockAccess world, BlockPos pos, IBlockState state, BoundingBoxType type) {
        float f = 0.4375f;
        AxisAlignedBB base = new AxisAlignedBB((double)f, 0.0, (double)f, (double)(1.0f - f), 1.0, (double)(1.0f - f));
        state = world != null ? this.getFullState(block, world, pos) : block.func_176223_P();
        boolean north = (Boolean)state.func_177229_b((IProperty)NORTH);
        boolean south = (Boolean)state.func_177229_b((IProperty)SOUTH);
        boolean east = (Boolean)state.func_177229_b((IProperty)EAST);
        boolean west = (Boolean)state.func_177229_b((IProperty)WEST);
        if (world == null) {
            north = true;
            south = true;
        }
        if (!(north || south || east || west)) {
            north = true;
            south = true;
            east = true;
            west = true;
        }
        ArrayList list = Lists.newArrayList();
        if (north || south) {
            list.add(base.func_72321_a(0.0, 0.0, north ? (double)(-f) : 0.0).func_72321_a(0.0, 0.0, south ? (double)f : 0.0));
        }
        if (east || west) {
            list.add(base.func_72321_a(west ? (double)(-f) : 0.0, 0.0, 0.0).func_72321_a(east ? (double)f : 0.0, 0.0, 0.0));
        }
        return list.toArray(new AxisAlignedBB[0]);
    }

    @Override
    public Boolean isFullCube(Block block, IBlockState state) {
        return false;
    }

    @Override
    public Boolean isOpaqueCube(Block block, IBlockState state) {
        return false;
    }

    public final boolean canPaneConnectToBlock(Block block, IBlockState state) {
        return state.func_185913_b() || block == Blocks.field_150359_w || block == Blocks.field_150399_cn || block == Blocks.field_150397_co || block instanceof BlockPane;
    }

    public boolean canPaneConnectTo(Block block, IBlockAccess world, BlockPos pos, EnumFacing dir) {
        BlockPos offset = pos.func_177972_a(dir);
        IBlockState state = world.func_180495_p(offset);
        Block connected = state.func_177230_c();
        return connected == block || this.canPaneConnectToBlock(state.func_177230_c(), state) || connected.isSideSolid(state, world, offset, dir.func_176734_d());
    }

    public static boolean isConnected(IBlockState state, PropertyBool property) {
        return (Boolean)state.func_177229_b((IProperty)property);
    }
}

