/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.core.util.clientnotif;

import com.google.common.collect.Sets;
import java.lang.reflect.Method;
import java.util.Set;
import net.malisis.core.MalisisCore;
import net.malisis.core.util.clientnotif.ClientNotification;
import net.malisis.core.util.clientnotif.NeighborChangedMessage;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class ClientNotificationManager {
    private Set<Block> clientBlocks = Sets.newHashSet();
    private static ClientNotificationManager instance;

    private ClientNotificationManager() {
    }

    private void registerBlockNotif(Block block) {
        this.clientBlocks.add(block);
    }

    private boolean needsNotification(Block block) {
        return this.clientBlocks.contains(block);
    }

    public void notifyClientBlock(World world, BlockPos pos, Block neighbor) {
        if (world.field_72995_K) {
            return;
        }
        IBlockState state = world.func_180495_p(pos);
        if (!this.needsNotification(state.func_177230_c())) {
            return;
        }
        NeighborChangedMessage.send(world, pos, neighbor);
    }

    public void discover(Block block) {
        try {
            Class<?> clazz = block.getClass();
            Method m = clazz.getMethod(MalisisCore.isObfEnv ? "func_189540_a" : "neighborChanged", IBlockState.class, World.class, BlockPos.class, Block.class);
            ClientNotification anno = m.getAnnotation(ClientNotification.class);
            if (anno != null) {
                this.registerBlockNotif(block);
            }
        }
        catch (ReflectiveOperationException e) {
            MalisisCore.log.error("Failed to find @ClientNotification annotation for {} : ", new Object[]{block, e});
        }
    }

    public static ClientNotificationManager get() {
        if (instance == null) {
            instance = new ClientNotificationManager();
        }
        return instance;
    }

    public static void notify(World world, BlockPos pos, Block neighbor) {
        ClientNotificationManager.get().notifyClientBlock(world, pos, neighbor);
    }
}

