/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.core.renderer;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.malisis.core.MalisisCoreSettings;
import net.malisis.core.block.IComponent;
import net.malisis.core.registry.MalisisRegistry;
import net.malisis.core.renderer.IAnimatedRenderable;
import net.malisis.core.renderer.IAnimatedRenderer;
import net.malisis.core.renderer.ISortedRenderable;
import net.malisis.core.renderer.MalisisRenderer;
import net.malisis.core.renderer.RenderType;
import net.malisis.core.renderer.component.AnimatedModelComponent;
import net.malisis.core.util.BlockPosUtils;
import net.malisis.core.util.Point;
import net.malisis.core.util.Utils;
import net.malisis.core.util.WeakNested;
import net.malisis.core.util.callback.CallbackResult;
import net.malisis.core.util.callback.ICallback;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderGlobal;
import net.minecraft.client.renderer.chunk.RenderChunk;
import net.minecraft.client.renderer.culling.ICamera;
import net.minecraft.entity.Entity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.client.MinecraftForgeClient;

public class AnimatedRenderer
extends MalisisRenderer<TileEntity>
implements IAnimatedRenderer {
    IAnimatedRenderable renderable;
    private static WeakNested.Map<Chunk, BlockPos, ISortedRenderable> sortedRenderables = new WeakNested.Map(Maps::newHashMap);

    public AnimatedRenderer() {
        this.isBatched = true;
    }

    public IAnimatedRenderable getRenderable() {
        return this.renderable;
    }

    @Override
    public void renderAnimated(World world, BlockPos pos, IAnimatedRenderable renderable, double x, double y, double z, float partialTicks) {
        this.set((IBlockAccess)world, pos);
        this.renderType = RenderType.ANIMATED;
        this.buffer = batchedBuffer;
        this.renderable = renderable;
        this.posOffset = new Vec3d(x, y, z);
        this.render();
        this.reset();
        renderable = null;
    }

    @Override
    public void render() {
        this.renderable.renderAnimated(this.block, this);
    }

    public static CallbackResult<Void> removeRenderable(Chunk chunk, BlockPos pos, IBlockState oldState, IBlockState newState) {
        if (oldState.func_177230_c() == newState.func_177230_c()) {
            return CallbackResult.noResult();
        }
        AnimatedModelComponent comp = IComponent.getComponent(AnimatedModelComponent.class, oldState.func_177230_c());
        if (comp != null) {
            sortedRenderables.remove(chunk, pos);
        }
        return CallbackResult.noResult();
    }

    public static Stream<ISortedRenderable> getRenderables(Chunk chunk) {
        Collection renderables = sortedRenderables.get((Object)chunk).values();
        if (renderables.isEmpty()) {
            return Stream.empty();
        }
        return ImmutableList.copyOf(renderables).stream();
    }

    public static <T extends ISortedRenderable> Optional<T> getRenderable(BlockPos pos) {
        Optional<Chunk> chunk = Utils.getLoadedChunk((World)Utils.getClientWorld(), pos);
        return chunk.map(c -> sortedRenderables.get((Chunk)c, pos));
    }

    public static void registerRenderable(BlockPos pos, AnimatedModelComponent amc) {
        Optional<Chunk> chunk = Utils.getLoadedChunk((World)Utils.getClientWorld(), pos);
        if (!chunk.isPresent()) {
            return;
        }
        ISortedRenderable r = sortedRenderables.get(chunk.get(), pos);
        if (r == null) {
            sortedRenderables.put(chunk.get(), pos, amc.createRenderable(chunk.get().func_177412_p(), pos));
        }
    }

    private static Point getRenderViewOffset(float partialTick) {
        Entity entity = Minecraft.func_71410_x().func_175606_aa();
        if (partialTick == 0.0f) {
            return new Point(entity.field_70165_t, entity.field_70163_u, entity.field_70161_v);
        }
        double x = entity.field_70142_S + (entity.field_70165_t - entity.field_70142_S) * (double)partialTick;
        double y = entity.field_70137_T + (entity.field_70163_u - entity.field_70137_T) * (double)partialTick;
        double z = entity.field_70136_U + (entity.field_70161_v - entity.field_70136_U) * (double)partialTick;
        return new Point(x, y, z);
    }

    public static List<RenderGlobal.ContainerLocalRenderInformation> sortRenderInfos(List<RenderGlobal.ContainerLocalRenderInformation> renderInfos) {
        if (MinecraftForgeClient.getRenderPass() != 0 || !MalisisCoreSettings.tileEntitySorting.get().booleanValue()) {
            return renderInfos;
        }
        Point viewOffset = AnimatedRenderer.getRenderViewOffset(0.0f).add(-8.0, -8.0, -8.0);
        return renderInfos.stream().sorted((r1, r2) -> AnimatedRenderer.compareRenderInfos(viewOffset, r1, r2)).collect(Collectors.toList());
    }

    public static int compareRenderInfos(Point viewOffset, RenderGlobal.ContainerLocalRenderInformation r1, RenderGlobal.ContainerLocalRenderInformation r2) {
        BlockPos p1 = r1.field_178036_a.func_178568_j();
        BlockPos p2 = r2.field_178036_a.func_178568_j();
        return -BlockPosUtils.compare(viewOffset, p1, p2);
    }

    public static List<TileEntity> renderSortedTileEntities(RenderChunk renderChunk, List<TileEntity> list, ICamera camera, float partialTick) {
        if (MinecraftForgeClient.getRenderPass() == 1) {
            return list;
        }
        boolean sorting = MalisisCoreSettings.tileEntitySorting.get();
        Entity entity = Minecraft.func_71410_x().func_175606_aa();
        World world = entity.field_70170_p;
        Chunk chunk = world.func_175726_f(renderChunk.func_178568_j());
        Point viewOffset = AnimatedRenderer.getRenderViewOffset(partialTick);
        Stream<ISortedRenderable> stream = Stream.concat(list.stream().map(ISortedRenderable.TE::new), AnimatedRenderer.getRenderables(chunk)).filter(r -> r.inFrustrum(camera));
        if (sorting) {
            stream = stream.sorted((r1, r2) -> -BlockPosUtils.compare(viewOffset, r1.getPos(), r2.getPos()));
        }
        stream.forEach(r -> r.render(partialTick));
        return ImmutableList.of();
    }

    static {
        MalisisRegistry.onPostSetBlock(AnimatedRenderer::removeRenderable, ICallback.CallbackOption.of());
    }
}

