/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.core.network;

import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public interface IMalisisMessageHandler<REQ extends IMessage, REPLY extends IMessage>
extends IMessageHandler<REQ, REPLY> {
    default public REPLY onMessage(REQ message, MessageContext ctx) {
        if (this.useTask()) {
            if (ctx.side.isClient()) {
                Minecraft.func_71410_x().func_152344_a(() -> this.process(message, ctx));
            } else if (ctx.side.isServer()) {
                ((WorldServer)ctx.getServerHandler().field_147369_b.field_70170_p).func_152344_a(() -> this.process(message, ctx));
            }
        } else {
            this.process(message, ctx);
        }
        return null;
    }

    public void process(REQ var1, MessageContext var2);

    default public boolean useTask() {
        return true;
    }

    public static World getWorld(MessageContext ctx) {
        if (ctx.side == Side.SERVER) {
            return ctx.getServerHandler().field_147369_b.field_70170_p;
        }
        return IMalisisMessageHandler.getClientWorld();
    }

    public static EntityPlayer getPlayer(MessageContext ctx) {
        if (ctx.side == Side.SERVER) {
            return ctx.getServerHandler().field_147369_b;
        }
        return IMalisisMessageHandler.getClientPlayer();
    }

    @SideOnly(value=Side.CLIENT)
    public static EntityPlayer getClientPlayer() {
        return Minecraft.func_71410_x().field_71439_g;
    }

    @SideOnly(value=Side.CLIENT)
    public static World getClientWorld() {
        return Minecraft.func_71410_x().field_71441_e;
    }
}

