/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.core.util.raytrace;

import java.util.Optional;
import net.malisis.core.MalisisCore;
import net.malisis.core.util.Point;
import net.malisis.core.util.Ray;
import net.malisis.core.util.Utils;
import net.malisis.core.util.Vector;
import net.malisis.core.util.chunkcollision.ChunkCollision;
import net.malisis.core.util.raytrace.Raytrace;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;

public class RaytraceChunk
extends Raytrace {
    private static final int MAX_CHUNKS = 16;
    private World world;
    private Vector step;

    public RaytraceChunk(World world, Ray ray) {
        super(ray);
        this.world = world;
        int stepX = 16;
        int stepZ = 16;
        if (ray.direction.x < 0.0) {
            stepX = -16;
        }
        if (ray.direction.z < 0.0) {
            stepZ = -1;
        }
        this.step = new Vector(stepX, 0.0, stepZ);
    }

    public RaytraceChunk(World world, Point src, Vector v) {
        this(world, new Ray(src, v));
    }

    public RaytraceChunk(World world, Point src, Point dest) {
        this(world, new Ray(src, new Vector(src, dest)));
        this.dest = dest;
    }

    public RayTraceResult trace() {
        RayTraceResult mop = null;
        RayTraceResult firstHit = null;
        int count = 0;
        boolean ret = false;
        int currentX = (int)this.src.x;
        int currentZ = (int)this.src.z;
        while (!ret && count++ <= 16) {
            Optional<Chunk> chunk;
            double tZ;
            double tX = this.ray.intersectX(currentX + (this.ray.direction.x > 0.0 ? 16 : 0));
            double min = this.getMin(tX, tZ = this.ray.intersectZ(currentZ + (this.ray.direction.z > 0.0 ? 16 : 0)));
            Point exit = this.ray.getPointAt(min);
            if (exit == null || exit.y <= 0.0 || exit.y >= 256.0) {
                ret = true;
            }
            if (this.dest != null && exit != null && Point.distanceSquared(this.src, this.dest) < Point.distanceSquared(this.src, exit)) {
                ret = true;
            }
            if ((chunk = Utils.getLoadedChunk(this.world, new BlockPos(currentX, 0, currentZ))).isPresent()) {
                mop = ChunkCollision.get().processCallbacks(chunk.get(), this.src, this.dest);
            } else {
                ret = true;
            }
            firstHit = Raytrace.getClosestHit(RayTraceResult.Type.BLOCK, this.src, firstHit, mop);
            if (this.dest != null && currentX == (int)this.dest.x && currentZ == (int)this.dest.y) {
                ret = true;
            }
            if (!ret) {
                if (min == tX) {
                    currentX = (int)((double)currentX + this.step.x);
                }
                if (min == tZ) {
                    currentZ = (int)((double)currentZ + this.step.z);
                }
            }
            if (this.dest == null || !this.dest.equals(this.ray.getPointAt(min))) continue;
            ret = true;
        }
        if (firstHit == null && this.dest != null) {
            firstHit = new RayTraceResult(RayTraceResult.Type.MISS, this.dest.toVec3d(), null, new BlockPos(currentX, 0, currentZ));
        }
        if (!ret) {
            MalisisCore.message("Trace fail : 16 chunks passed (" + currentX + "," + currentZ + ")");
        }
        return firstHit;
    }

    public double getMin(double x, double z) {
        double ret = Double.NaN;
        if (!Double.isNaN(x)) {
            ret = x;
        }
        if (!Double.isNaN(z)) {
            ret = !Double.isNaN(ret) ? Math.min(ret, z) : z;
        }
        return ret;
    }
}

