/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.core.util.blockdata;

import io.netty.buffer.ByteBuf;
import net.malisis.core.MalisisCore;
import net.malisis.core.network.IMalisisMessageHandler;
import net.malisis.core.network.MalisisMessage;
import net.malisis.core.util.blockdata.BlockDataHandler;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;

@MalisisMessage
public class BlockDataMessage
implements IMalisisMessageHandler<Packet, IMessage> {
    public BlockDataMessage() {
        MalisisCore.network.registerMessage(this, Packet.class, Side.CLIENT);
    }

    @Override
    public void process(Packet message, MessageContext ctx) {
        BlockDataHandler.setBlockData(message.x, message.z, message.identifier, message.data);
    }

    public static void sendBlockData(Chunk chunk, String identifier, ByteBuf data, EntityPlayerMP player) {
        MalisisCore.network.sendTo(new Packet(chunk, identifier, data), player);
    }

    public static class Packet
    implements IMessage {
        private int x;
        private int z;
        private String identifier;
        private ByteBuf data;

        public Packet() {
        }

        public Packet(Chunk chunk, String identifier, ByteBuf data) {
            this.x = chunk.field_76635_g;
            this.z = chunk.field_76647_h;
            this.identifier = identifier;
            this.data = data;
        }

        public void fromBytes(ByteBuf buf) {
            this.x = buf.readInt();
            this.z = buf.readInt();
            this.identifier = ByteBufUtils.readUTF8String((ByteBuf)buf);
            this.data = buf.readBytes(buf);
        }

        public void toBytes(ByteBuf buf) {
            buf.writeInt(this.x);
            buf.writeInt(this.z);
            ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.identifier);
            buf.writeBytes(this.data);
        }
    }
}

