/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.core.util.blockdata;

import com.google.common.base.Function;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import net.malisis.core.MalisisCore;
import net.malisis.core.asm.AsmUtils;
import net.malisis.core.registry.AutoLoad;
import net.malisis.core.util.Silenced;
import net.malisis.core.util.blockdata.BlockDataMessage;
import net.minecraft.client.Minecraft;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.ChunkCache;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.world.ChunkDataEvent;
import net.minecraftforge.event.world.ChunkEvent;
import net.minecraftforge.event.world.ChunkWatchEvent;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;

@AutoLoad
public class BlockDataHandler {
    private static BlockDataHandler instance = new BlockDataHandler();
    private static Field chunkCacheField = MalisisCore.isClient() && FMLClientHandler.instance().hasOptifine() ? AsmUtils.changeFieldAccess(Silenced.get(() -> Class.forName("ChunkCacheOF")), "chunkCache") : null;
    private Map<String, HandlerInfo<?>> handlerInfos = new HashMap();
    private Table<String, Chunk, ChunkData<?>> serverDatas = HashBasedTable.create();
    private Table<String, Chunk, ChunkData<?>> clientDatas = HashBasedTable.create();

    private BlockDataHandler() {
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    private Table<String, Chunk, ChunkData<?>> data(World world) {
        return this.world((IBlockAccess)world).field_72995_K ? BlockDataHandler.instance.clientDatas : BlockDataHandler.instance.serverDatas;
    }

    private World world(IBlockAccess world) {
        if (world instanceof World) {
            return (World)world;
        }
        if (world instanceof ChunkCache) {
            return ((ChunkCache)world).field_72815_e;
        }
        if (FMLClientHandler.instance().hasOptifine() && chunkCacheField != null) {
            return this.world((IBlockAccess)Silenced.get(() -> (ChunkCache)chunkCacheField.get(world)));
        }
        return null;
    }

    private <T> ChunkData<T> chunkData(String identifier, World world, BlockPos pos) {
        return world != null ? this.chunkData(identifier, world, world.func_175726_f(pos)) : null;
    }

    private <T> ChunkData<T> chunkData(String identifier, World world, Chunk chunk) {
        return (ChunkData)instance.data(world).get((Object)identifier, (Object)chunk);
    }

    private <T> ChunkData<T> createChunkData(String identifier, World world, BlockPos pos) {
        Chunk chunk = world.func_175726_f(pos);
        ChunkData chunkData = new ChunkData(this.handlerInfos.get(identifier));
        instance.data(world).put((Object)identifier, (Object)chunk, chunkData);
        return chunkData;
    }

    public static <T> void registerBlockData(String identifier, Function<ByteBuf, T> from, Function<T, ByteBuf> to) {
        BlockDataHandler.instance.handlerInfos.put(identifier, new HandlerInfo<T>(identifier, from, to));
    }

    public static <T> T getData(String identifier, IBlockAccess world, BlockPos pos) {
        ChunkData<T> chunkData = instance.chunkData(identifier, instance.world(world), pos);
        return chunkData != null ? (T)chunkData.getData(pos) : null;
    }

    public static <T> void setData(String identifier, IBlockAccess world, BlockPos pos, T data) {
        ChunkData<T> chunkData = instance.chunkData(identifier, instance.world(world), pos);
        if (chunkData == null) {
            chunkData = instance.createChunkData(identifier, instance.world(world), pos);
        }
        chunkData.setData(pos, data);
    }

    public static <T> void removeData(String identifier, IBlockAccess world, BlockPos pos) {
        BlockDataHandler.setData(identifier, world, pos, null);
    }

    @SubscribeEvent
    public void onDataLoad(ChunkDataEvent.Load event) {
        NBTTagCompound nbt = event.getData();
        for (HandlerInfo<?> handlerInfo : this.handlerInfos.values()) {
            if (!nbt.func_74764_b(handlerInfo.identifier)) continue;
            ChunkData chunkData = new ChunkData(handlerInfo);
            chunkData.fromBytes(Unpooled.copiedBuffer((byte[])nbt.func_74770_j(handlerInfo.identifier)));
            this.data(event.getWorld()).put((Object)handlerInfo.identifier, (Object)event.getChunk(), chunkData);
        }
    }

    @SubscribeEvent
    public void onDataSave(ChunkDataEvent.Save event) {
        NBTTagCompound nbt = event.getData();
        for (HandlerInfo<?> handlerInfo : this.handlerInfos.values()) {
            ChunkData chunkData = this.chunkData(handlerInfo.identifier, event.getWorld(), event.getChunk());
            if (chunkData == null || !chunkData.hasData()) continue;
            ByteBuf buf = Unpooled.buffer();
            chunkData.toBytes(buf);
            nbt.func_74773_a(handlerInfo.identifier, buf.capacity(buf.writerIndex()).array());
        }
    }

    @SubscribeEvent
    public void onDataUnload(ChunkEvent.Unload event) {
        for (HandlerInfo<?> handlerInfo : this.handlerInfos.values()) {
            this.data(event.getWorld()).remove((Object)handlerInfo.identifier, (Object)event.getChunk());
        }
    }

    @SubscribeEvent
    public void onChunkWatched(ChunkWatchEvent.Watch event) {
        Chunk chunk = event.getPlayer().field_70170_p.func_72964_e(event.getChunk().field_77276_a, event.getChunk().field_77275_b);
        for (HandlerInfo<?> handlerInfo : this.handlerInfos.values()) {
            ChunkData chunkData = instance.chunkData(handlerInfo.identifier, chunk.func_177412_p(), chunk);
            if (chunkData == null || !chunkData.hasData()) continue;
            BlockDataMessage.sendBlockData(chunk, handlerInfo.identifier, chunkData.toBytes(Unpooled.buffer()), event.getPlayer());
        }
    }

    static void setBlockData(int chunkX, int chunkZ, String identifier, ByteBuf data) {
        HandlerInfo<?> handlerInfo = BlockDataHandler.instance.handlerInfos.get(identifier);
        if (handlerInfo == null) {
            return;
        }
        Chunk chunk = Minecraft.func_71410_x().field_71441_e.func_72964_e(chunkX, chunkZ);
        ChunkData<?> chunkData = new ChunkData(handlerInfo).fromBytes(data);
        instance.data(chunk.func_177412_p()).put((Object)handlerInfo.identifier, (Object)chunk, chunkData);
    }

    public static BlockDataHandler get() {
        return instance;
    }

    static class ChunkData<T> {
        private HandlerInfo<T> handlerInfos;
        private HashMap<BlockPos, T> data = new HashMap();

        public ChunkData(HandlerInfo<T> handlerInfo) {
            this.handlerInfos = handlerInfo;
        }

        public boolean hasData() {
            return this.data.size() > 0;
        }

        public T getData(BlockPos pos) {
            return this.data.get(pos);
        }

        public void setData(BlockPos pos, T blockData) {
            if (blockData != null) {
                this.data.put(pos, blockData);
            } else {
                this.data.remove(pos);
            }
        }

        public ChunkData<T> fromBytes(ByteBuf buf) {
            while (buf.isReadable()) {
                BlockPos pos = BlockPos.func_177969_a((long)buf.readLong());
                ByteBuf b = buf.readBytes(buf.readInt());
                Object blockData = ((HandlerInfo)this.handlerInfos).from.apply((Object)b);
                this.data.put(pos, blockData);
            }
            return this;
        }

        public ByteBuf toBytes(ByteBuf buf) {
            for (Map.Entry<BlockPos, T> entry : this.data.entrySet()) {
                ByteBuf b = (ByteBuf)((HandlerInfo)this.handlerInfos).to.apply(entry.getValue());
                buf.writeLong(entry.getKey().func_177986_g());
                buf.writeInt(b.writerIndex());
                buf.writeBytes(b);
            }
            return buf;
        }
    }

    static class HandlerInfo<T> {
        String identifier;
        private Function<ByteBuf, T> from;
        private Function<T, ByteBuf> to;

        public HandlerInfo(String identifier, Function<ByteBuf, T> from, Function<T, ByteBuf> to) {
            this.identifier = identifier;
            this.from = from;
            this.to = to;
        }
    }
}

